/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui.controls;

import de.uniks.networkparser.SimpleObject;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import java.util.List;

public abstract class Control
extends SimpleObject {
    public static final String PROPERTY = "property";
    private SimpleKeyValueList<EventTypes, List<ObjectCondition>> events;
    protected String property;

    public boolean addEventListener(EventTypes type, ObjectCondition listener) {
        List<ObjectCondition> list;
        if (this.events == null) {
            this.events = new SimpleKeyValueList();
        }
        if ((list = this.events.get((Object)type)) == null) {
            list = new SimpleList<ObjectCondition>();
            list.add(listener);
            return this.events.add(type, list);
        }
        list.add(listener);
        return true;
    }

    public boolean addClickListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.CLICK, listener);
    }

    public boolean addDoubleClickListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.DOUBLECLICK, listener);
    }

    public boolean addMouseUpListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.MOUSEUP, listener);
    }

    public boolean addMouseDownListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.MOUSEDOWN, listener);
    }

    public boolean addMouseEnterListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.MOUSEENTER, listener);
    }

    public boolean addMouseLeaveListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.MOUSELEAVE, listener);
    }

    public boolean addMouseMoveListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.MOUSEMOVE, listener);
    }

    public boolean addKeyPressListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.KEYPRESS, listener);
    }

    public boolean addKeyDownListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.KEYDOWN, listener);
    }

    public boolean addKeyUpListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.KEYUP, listener);
    }

    public boolean addResizeListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.RESIZE, listener);
    }

    public boolean addDragStartListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.DRAGSTART, listener);
    }

    public boolean addDragOverListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.DRAGOVER, listener);
    }

    public boolean addDropListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.DROP, listener);
    }

    public boolean addChangeListener(ObjectCondition listener) {
        return this.addEventListener(EventTypes.CHANGE, listener);
    }

    public List<ObjectCondition> getEvents(EventTypes type) {
        if (this.events == null) {
            return null;
        }
        return this.events.get((Object)type);
    }

    public Control() {
        this.addBaseElements(PROPERTY);
    }

    public String getProperty() {
        return this.property;
    }

    public boolean setProperty(String value) {
        String oldValue = this.property;
        this.property = value;
        return this.firePropertyChange(PROPERTY, oldValue, value);
    }

    @Override
    public Object getValue(String key) {
        if (PROPERTY.equalsIgnoreCase(key)) {
            return this.property;
        }
        return super.getValue(key);
    }

    @Override
    public boolean setValue(String key, Object value) {
        if (PROPERTY.equalsIgnoreCase(key = key.trim())) {
            return this.setProperty("" + value);
        }
        return super.setValue(key, value);
    }
}

