/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.NetworkParserLog;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.SimpleObject;
import de.uniks.networkparser.gui.BridgeCommand;
import de.uniks.networkparser.gui.Event;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.gui.JavaViewAdapter;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.HTMLEntity;
import java.util.List;
import java.util.Map;

public abstract class JavaBridge
implements ObjectCondition {
    public static String CONTENT_TYPE_INCLUDE = "INCLUDE";
    public static String CONTENT_TYPE_EXCLUDE = "EXCLUDE";
    protected static final String JAVA_BRIDGE = "JavaBridge";
    protected IdMap map;
    protected SimpleKeyValueList<String, Control> controls = null;
    private boolean isApplyingChangeMSG;
    private JavaViewAdapter webView;
    private NetworkParserLog logger;

    public JavaBridge() {
        this(null, null);
    }

    public JavaBridge(IdMap map, JavaViewAdapter webView) {
        if (map == null) {
            map = new IdMap();
        }
        this.map = map;
        map.add(this);
        this.webView = webView;
        this.webView.withOwner(this);
        HTMLEntity entity = this.init(CONTENT_TYPE_INCLUDE, "var bridge = new DiagramJS.Bridge();");
        this.webView.load(entity);
    }

    public HTMLEntity init(String type, String script) {
        HTMLEntity entity = new HTMLEntity();
        entity.withScript(script);
        if (CONTENT_TYPE_EXCLUDE.equals(type)) {
            entity.withHeader("./res/diagram.js");
            entity.withHeader("./res/material.css");
        } else {
            entity.withHeaderScript(this.readFile("./res/diagram.js"));
            entity.withHeaderStyle(this.readFile("./res/material.css"));
        }
        return entity;
    }

    protected String readFile(String file) {
        return this.webView.readFile(file);
    }

    @Override
    public boolean update(Object event) {
        if (this.isApplyingChangeMSG) {
            return false;
        }
        SimpleEvent simpleEvent = (SimpleEvent)event;
        if (!simpleEvent.isNewEvent()) {
            return true;
        }
        JsonObject jsonObject = (JsonObject)simpleEvent.getEntity();
        if (jsonObject == null) {
            return false;
        }
        this.executeScript(BridgeCommand.load(jsonObject));
        return true;
    }

    public IdMap getMap() {
        return this.map;
    }

    public String put(SimpleObject so) {
        this.map.getMapListener().suspendNotification();
        JsonObject jsonObject = this.map.toJsonObject(so);
        this.map.getMapListener().resetNotification();
        Object result = this.executeScript(BridgeCommand.load(jsonObject));
        String id = null;
        if (result instanceof JsonObject) {
            JsonObject json = (JsonObject)result;
            id = json.getString("id");
            so.setId(id);
        }
        return id;
    }

    public String addControl(Control c) {
        String key = null;
        if (this.controls != null) {
            key = this.controls.getKey(c);
        }
        if (key != null) {
            return key;
        }
        this.map.getMapListener().suspendNotification();
        JsonObject jsonObject = this.map.toJsonObject(c, Filter.SIMPLEFORMAT);
        this.map.getMapListener().resetNotification();
        Object result = this.executeScript(BridgeCommand.load(jsonObject));
        String id = null;
        if (result instanceof JsonObject) {
            JsonObject json = (JsonObject)result;
            id = json.getString("id");
            c.setId(id);
            this.getControls().put(id, c);
        }
        return id;
    }

    protected Map<String, Control> getControls() {
        if (this.controls == null) {
            this.controls = new SimpleKeyValueList();
        }
        return this.controls;
    }

    public Object executeScript(String script) {
        if (script == null) {
            return null;
        }
        return this.webView.executeScript(script);
    }

    public void addEventListener(Control c, EventTypes eventType, ObjectCondition eventListener) {
        if (c.getEvents(eventType) == null) {
            this.executeScript(BridgeCommand.register(eventType, c.getId()));
        }
        c.addEventListener(eventType, eventListener);
    }

    public void fireEvent(JsonObject event) {
        this.map.decode(event);
    }

    public void fireEvent(Event event) {
        List<ObjectCondition> events;
        Control control = this.getControls().get(event.getId());
        if (control != null && (events = control.getEvents(event.getEventType())) != null) {
            for (ObjectCondition listener : events) {
                listener.update(event);
            }
        }
    }

    public void fireControlChange(Control control, String property, Object value) {
        this.executeScript(BridgeCommand.load("{id:\"" + control.getId() + "\", " + property + ":\"" + value + "\"}"));
    }

    public boolean setApplyingChangeMSG(boolean value) {
        this.isApplyingChangeMSG = value;
        return this.isApplyingChangeMSG;
    }

    public JavaViewAdapter getViewAdapter() {
        return this.webView;
    }

    public Object getWebView() {
        return this.webView.getWebView();
    }

    public JavaBridge withWebView(JavaViewAdapter webView) {
        this.webView = webView;
        return this;
    }

    public void logScript(String msg, String level, Object owner, String method) {
        if (this.logger != null) {
            this.logger.log(msg, level, owner, method);
        }
    }

    public void addListener(Control c, EventTypes type, String methodName, Object object) {
    }
}

