/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.StringFilter;

public class Modifier
extends GraphMember {
    public static final StringFilter<Modifier> NAME = new StringFilter("name");
    public static final Modifier PUBLIC = new Modifier("public");
    public static final Modifier PACKAGE = new Modifier("");
    public static final Modifier PROTECTED = new Modifier("protected");
    public static final Modifier PRIVATE = new Modifier("private");
    public static final Modifier FINAL = new Modifier("final");
    public static final Modifier ABSTRACT = new Modifier("abstract");
    public static final Modifier STATIC = new Modifier("static");
    public static final Modifier DEFAULT = new Modifier("default");

    Modifier(String value) {
        this.setName(value);
    }

    @Override
    public Modifier with(String name) {
        super.with(name);
        return this;
    }

    public static Modifier create(String value) {
        return new Modifier(value);
    }

    public static Modifier create(Modifier ... values) {
        if (values == null || values.length < 1) {
            return null;
        }
        Modifier mod = new Modifier(values[0].getName());
        mod.withModifier(values);
        return mod;
    }

    public boolean has(Modifier other) {
        if (this.getName().equals(other.getName())) {
            return true;
        }
        if (this.children != null) {
            for (GraphMember member : this.getChildren()) {
                if (!(member instanceof Modifier) || !((Modifier)member).has(other)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public GraphMember getParent() {
        return (GraphMember)this.parentNode;
    }

    public String toString() {
        CharacterBuffer buffer = new CharacterBuffer();
        String name = this.getName();
        GraphSimpleSet list = this.getChildren();
        if (name != null && name.length() > 0) {
            buffer.with(name);
            if (list.size() > 0) {
                buffer.with(" ");
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            GraphMember member = (GraphMember)list.get(i);
            if (!(member instanceof Modifier) || (name = member.getName()) == null || name.length() <= 0) continue;
            buffer.with(name);
            if (i + 1 >= list.size()) continue;
            buffer.with(" ");
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.hashCode() == this.hashCode()) {
            return true;
        }
        if (obj instanceof Modifier) {
            return this.has((Modifier)obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

