/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.Parameter;
import de.uniks.networkparser.graph.StringFilter;
import de.uniks.networkparser.graph.Throws;
import de.uniks.networkparser.graph.util.ParameterSet;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.SimpleSet;

public class Method
extends GraphMember {
    public static final StringFilter<Method> NAME = new StringFilter("name");
    public static final String PROPERTY_RETURNTYPE = "returnType";
    public static final String PROPERTY_PARAMETER = "parameter";
    public static final String PROPERTY_NODE = "node";
    public static final String PROPERTY_MODIFIER = "modifier";
    public static final String PROPERTY_ANNOTATIONS = "annotations";
    private DataType returnType = DataType.VOID;
    private String body;

    @Override
    public Method with(String name) {
        if (name == null) {
            return this;
        }
        int pos = name.indexOf("(");
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        super.with(name);
        return this;
    }

    public String getName(boolean shortName) {
        return this.getName(shortName, false);
    }

    public String getName(boolean shortName, boolean removeParameterNames) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getName());
        if (this.children != null) {
            sb.append(this.getParameterString(shortName, removeParameterNames));
        }
        if (this.returnType != null && this.returnType != DataType.VOID) {
            sb.append(" " + this.returnType.getName(shortName));
        }
        return sb.toString();
    }

    public Method() {
    }

    public Method(String name) {
        this.with(name);
    }

    public Method(String name, DataType returnType, Parameter ... parameters) {
        this.with(name);
        this.with(parameters);
        this.with(returnType);
    }

    public Method(String name, Parameter ... parameters) {
        this.with(parameters);
        this.with(name);
    }

    public Method withParameter(String paramName, DataType dataType) {
        new Parameter().with(paramName).with(dataType).withParent(this);
        return this;
    }

    public Method withParameter(String paramName, Clazz dataType) {
        new Parameter().with(paramName).with(DataType.create(dataType)).withParent(this);
        return this;
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = super.getModifier();
        if (modifier == null) {
            modifier = new Modifier(Modifier.PUBLIC.getName());
            super.withChildren(modifier);
        }
        return modifier;
    }

    public Method with(Modifier ... modifiers) {
        super.withModifier(modifiers);
        return this;
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    public Parameter create(DataType type) {
        return new Parameter().with(type).withParent(this);
    }

    public Parameter create(Clazz type) {
        return new Parameter().with(DataType.create(type)).withParent(this);
    }

    public Method withParent(Clazz value) {
        super.setParentNode(value);
        return this;
    }

    CharacterBuffer getParameterString(boolean shortName, boolean removeParameterNames) {
        CharacterBuffer sb = new CharacterBuffer().with("(");
        GraphSimpleSet collection = this.getChildren();
        for (int i = 0; i < collection.size(); ++i) {
            if (!(collection.get(i) instanceof Parameter)) continue;
            Parameter param = (Parameter)collection.get(i);
            if (i > 0) {
                sb.with(", ");
            }
            if (param.getName() == null || removeParameterNames) {
                sb.with(param.getType(shortName) + " p" + i);
                continue;
            }
            sb.with(param.getType(shortName) + " " + ((GraphMember)collection.get(i)).getName());
        }
        sb.with(")");
        return sb;
    }

    public String getBody() {
        return this.body;
    }

    public Method withBody(String value) {
        this.body = value;
        return this;
    }

    public SimpleSet<Throws> getThrows() {
        SimpleSet<Throws> collection = new SimpleSet<Throws>();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Throws) {
            collection.add((Throws)this.children);
        } else if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet items = (GraphSimpleSet)this.children;
            for (GraphMember child : items) {
                if (!(child instanceof Throws)) continue;
                collection.add((Throws)child);
            }
        }
        return collection;
    }

    public ParameterSet getParameter(Condition<?> ... filters) {
        ParameterSet collection = new ParameterSet();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Parameter) {
            if (this.check((Parameter)this.children, filters)) {
                collection.add((Parameter)this.children);
            }
        } else if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet items = (GraphSimpleSet)this.children;
            for (GraphMember item : items) {
                if (!(item instanceof Parameter) || !this.check(item, filters)) continue;
                collection.add((Parameter)item);
            }
        }
        return collection;
    }

    public Method with(Throws ... values) {
        super.withChildren(values);
        return this;
    }

    public Method with(Parameter ... values) {
        super.withChildren(values);
        return this;
    }

    public Method with(DataType returnType) {
        this.returnType = returnType;
        return this;
    }

    public Method with(Clazz returnType) {
        this.returnType = DataType.create(returnType);
        return this;
    }

    public Method without(Parameter ... values) {
        super.without(values);
        return this;
    }

    public Method without(Annotation ... values) {
        super.without(values);
        return this;
    }

    @Override
    public Annotation getAnnotation() {
        return super.getAnnotation();
    }

    public Method with(Annotation value) {
        if (this.children != null) {
            if (this.children instanceof Annotation) {
                this.children = null;
            } else if (this.children instanceof GraphSimpleSet) {
                GraphSimpleSet collection = (GraphSimpleSet)this.children;
                for (int i = collection.size(); i >= 0; --i) {
                    if (!(collection.get(i) instanceof Annotation)) continue;
                    collection.remove(i);
                }
            }
        }
        super.withChildren(value);
        return this;
    }

    public String toString() {
        return this.getName(true);
    }

    public boolean isValidReturn() {
        if (this.getReturnType() == null || DataType.VOID.equals(this.getReturnType())) {
            return true;
        }
        if (this.body == null) {
            return false;
        }
        String[] lines = this.body.split("\n");
        if (lines.length < 1) {
            return false;
        }
        return lines[lines.length - 1].trim().startsWith("return");
    }
}

