/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.story;

import de.uniks.networkparser.ext.story.StoryStep;
import de.uniks.networkparser.ext.story.StoryStepCondition;
import de.uniks.networkparser.ext.story.StoryStepSourceCode;
import de.uniks.networkparser.ext.story.StoryStepText;
import de.uniks.networkparser.ext.story.StoryStepTitle;
import de.uniks.networkparser.ext.story.StoryUtil;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.BooleanCondition;
import de.uniks.networkparser.logic.Equals;
import de.uniks.networkparser.logic.Not;
import de.uniks.networkparser.xml.HTMLEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Story {
    private String outputFile;
    private SimpleList<StoryStep> steps = new SimpleList();
    private int counter = -1;
    private boolean breakOnAssert = true;

    public Story() {
        this.add(new StoryStepTitle());
    }

    public void add(StoryStep step) {
        this.steps.add(step);
    }

    public StoryStepSourceCode addSourceCode(Class<?> className) {
        StoryStepTitle titleStep;
        StoryStep firstStep;
        StoryStepSourceCode step = new StoryStepSourceCode();
        step.withCode(className);
        this.add(step);
        if (this.outputFile == null) {
            this.withFileName(step.getMethodName());
        }
        if ((firstStep = (StoryStep)this.steps.first()) instanceof StoryStepTitle && (titleStep = (StoryStepTitle)firstStep).getTitle() == null) {
            titleStep.setTitle(step.getMethodName());
        }
        return step;
    }

    public Story withFileName(String name) {
        this.outputFile = name.toLowerCase().endsWith(".html") ? name : name + ".html";
        return this;
    }

    public void finish() {
        if (this.steps != null) {
            ((StoryStep)this.steps.last()).finish();
        }
    }

    public boolean dumpHTML() {
        if (this.outputFile == null) {
            return false;
        }
        boolean success = true;
        HTMLEntity output = new HTMLEntity();
        output.withHeader("../src/main/resources/de/uniks/networkparser/graph/diagramstyle.css");
        output.withEncoding("utf-8");
        output.withHeader("highlight.pack.js");
        output.withHeader("highlightjs-line-numbers.min.js");
        output.withHeader("github.css");
        output.withHeader("default.css");
        output.withScript("hljs.initHighlightingOnLoad();\r\nhljs.initLineNumbersOnLoad();");
        for (StoryStep step : this.steps) {
            if (step.dump(this, output)) continue;
            success = false;
            break;
        }
        this.writeFile(output);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeFile(HTMLEntity output) {
        block20: {
            boolean bl;
            File file = new File("doc/" + this.outputFile);
            FileOutputStream fop = null;
            try {
                fop = new FileOutputStream(file);
                if (!file.exists() && !file.createNewFile()) {
                    boolean bl2 = false;
                    return bl2;
                }
                byte[] contentInBytes = output.toString().getBytes();
                fop.write(contentInBytes);
                fop.flush();
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                break block20;
            }
            catch (IOException iOException) {
                break block20;
            }
            finally {
                if (fop != null) {
                    try {
                        fop.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    public boolean addDescription(String key, String value) {
        StoryStepSourceCode source = null;
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            StoryStep step = (StoryStep)this.steps.get(i);
            if (!(this.steps.get(i) instanceof StoryStepSourceCode)) continue;
            source = (StoryStepSourceCode)step;
            break;
        }
        if (source != null) {
            source.addDescription(key, value);
            return true;
        }
        return false;
    }

    public Story withCounter(int counter) {
        this.counter = counter;
        return this;
    }

    public int getCounter() {
        int value;
        if ((value = this.counter++) >= 0) {
            // empty if block
        }
        return value;
    }

    public Story addText(String text) {
        StoryStepText step = new StoryStepText();
        step.setText(text);
        this.add(step);
        return this;
    }

    protected Story withBreakOnAssert(boolean value) {
        this.breakOnAssert = value;
        return this;
    }

    private void addCondition(StoryStepCondition step) {
        this.add(step);
        if (!step.checkCondition() && this.breakOnAssert) {
            block4: {
                this.dumpHTML();
                Method assertClass = null;
                try {
                    assertClass = Class.forName("org.junit.Assert").getMethod("assertTrue", String.class, Boolean.TYPE);
                    if (assertClass != null) {
                        assertClass.invoke(null, "FAILED: " + step.getMessage(), false);
                    }
                }
                catch (ReflectiveOperationException e) {
                    if (!(e instanceof InvocationTargetException)) break block4;
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    StoryUtil.throwException(targetException);
                }
            }
            throw new RuntimeException(step.getMessage());
        }
    }

    public void assertEquals(String message, double expected, double actual, double delta) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected, delta));
        this.addCondition(step);
    }

    public void assertEquals(String message, int expected, int actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertEquals(String message, long expected, long actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertTrue(String message, boolean actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new BooleanCondition().withValue(true));
        this.addCondition(step);
    }

    public void assertFalse(String message, boolean actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new BooleanCondition().withValue(false));
        this.addCondition(step);
    }

    public void assertNull(String message, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, Equals.createNullCondition());
        this.addCondition(step);
    }

    public void assertNotNull(String message, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Not().with(Equals.createNullCondition()));
        this.addCondition(step);
    }
}

