/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.dialog;

import de.uniks.networkparser.ext.javafx.dialog.DialogBox;
import de.uniks.networkparser.ext.javafx.dialog.DialogElement;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;

public class DialogButton
extends Button
implements DialogElement {
    private DialogBox owner;

    public DialogButton withName(String value) {
        this.setText(value);
        return this;
    }

    public DialogButton withAction(Grafik value) {
        if (Grafik.close.equals((Object)value)) {
            this.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DialogButton.this.owner.hide(DialogButton.this);
                }
            });
        }
        if (Grafik.minimize.equals((Object)value)) {
            this.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DialogButton.this.owner.minimize();
                }
            });
        }
        if (Grafik.maximize.equals((Object)value)) {
            this.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    DialogButton.this.owner.maximize();
                }
            });
        }
        return this;
    }

    public DialogButton withGrafik(Grafik type) {
        this.withAction(type);
        this.setFocusTraversable(false);
        this.getStyleClass().setAll((Object[])new String[]{"window-button", "window-" + (Object)((Object)type) + "-button"});
        StackPane graphic = new StackPane();
        graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
        this.setGraphic((Node)graphic);
        this.setMinSize(17.0, 17.0);
        this.setPrefSize(17.0, 17.0);
        return this;
    }

    @Override
    public DialogElement withOwner(DialogBox value) {
        this.owner = value;
        return this;
    }

    public DialogBox getOwner() {
        return this.owner;
    }

    public static enum Grafik {
        minimize,
        maximize,
        close;

    }
}

