/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.dialog;

import com.sun.javafx.tk.Toolkit;
import de.uniks.networkparser.ext.javafx.dialog.DialogButton;
import de.uniks.networkparser.ext.javafx.dialog.DialogElement;
import de.uniks.networkparser.ext.javafx.dialog.ShowTask;
import de.uniks.networkparser.ext.javafx.dialog.TitleSpacer;
import de.uniks.networkparser.ext.javafx.dialog.TitleText;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class DialogBox {
    protected static final PseudoClass ACTIVE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"active");
    protected static final int HEADER_HEIGHT = 28;
    protected static final URL DIALOGS_CSS_URL = DialogBox.class.getResource("dialogs.css");
    protected ToolBar dialogTitleBar;
    BorderPane root;
    Stage stage;
    boolean modal = true;
    Scene scene;
    boolean alwaysOnTop;
    DialogButton action;
    private Parent owner;
    private TitleText titleElement = new TitleText();
    private ArrayList<DialogElement> titleElements = new ArrayList();
    private ArrayList<DialogElement> actionElements = new ArrayList();
    private double mouseDragDeltaY;
    private double mouseDragDeltaX;
    private boolean isInline;
    private Parent originalParent;
    private Pane dialogStack;
    private Region opaqueLayer;
    private boolean iconified;
    private Node center;

    public DialogBox() {
        this.titleElements.add(this.titleElement);
        this.titleElements.add(new TitleSpacer());
        this.titleElements.add(new DialogButton().withGrafik(DialogButton.Grafik.close));
    }

    public DialogBox withTitle(String value) {
        if (value != null) {
            this.titleElement.setText(value);
        }
        return this;
    }

    public DialogButton show(Window owner) {
        if (this.titleElement.getText().length() < 1 && owner instanceof Stage) {
            this.titleElement.setText(((Stage)owner).getTitle());
        }
        if (this.isInline) {
            return this.showIntern(owner);
        }
        return this.showExtern(owner);
    }

    private DialogButton showIntern(Window parent) {
        if (!(parent instanceof Stage)) {
            return null;
        }
        this.stage = (Stage)parent;
        this.scene = this.stage.getScene();
        this.configScene();
        this.originalParent = this.scene.getRoot();
        this.createContent();
        this.buildDialogStack((Node)this.originalParent);
        this.root.pseudoClassStateChanged(ACTIVE_PSEUDO_CLASS, true);
        this.root.setVisible(true);
        Parent originalParent = this.scene.getRoot();
        this.scene.setRoot((Parent)this.dialogStack);
        if (originalParent != null) {
            this.dialogStack.getChildren().add(0, (Object)originalParent);
            this.dialogStack.getProperties().putAll((Map)originalParent.getProperties());
        }
        this.root.requestFocus();
        if (!this.modal) {
            Toolkit.getToolkit().enterNestedEventLoop((Object)this.root);
            return this.action;
        }
        return null;
    }

    public void hide(DialogButton value) {
        if (this.action == null) {
            this.setAction(value);
        }
    }

    public void setAction(DialogButton value) {
        this.action = value;
        if (this.isInline) {
            this.root.setVisible(false);
            Parent oldParent = this.scene.getRoot();
            if (oldParent instanceof Pane) {
                ((Pane)oldParent).getChildren().remove((Object)this.originalParent);
                this.originalParent.getStyleClass().remove((Object)"root");
                this.scene.setRoot(this.originalParent);
            }
            if (!this.modal) {
                Toolkit.getToolkit().exitNestedEventLoop((Object)this.root, null);
            }
            return;
        }
        if (this.stage != null) {
            this.stage.hide();
        }
    }

    public void minimize() {
        if (this.stage != null) {
            this.stage.setIconified(this.iconified);
        }
    }

    public void maximize() {
        if (this.isInline) {
            // empty if block
        }
        if (this.stage != null) {
            this.stage.setFullScreen(true);
        }
    }

    private void buildDialogStack(final Node parent) {
        this.dialogStack = new Pane(){
            private boolean isFirstRun = true;
            {
                if (!DialogBox.this.modal) {
                    DialogBox.this.opaqueLayer = new Region();
                    DialogBox.this.opaqueLayer.getStyleClass().add((Object)"lightweight-dialog-background");
                    this.getChildren().add(0, (Object)DialogBox.this.opaqueLayer);
                }
                this.getChildren().add((Object)DialogBox.this.root);
            }

            protected void layoutChildren() {
                double w = DialogBox.this.getOverlayWidth();
                double h = DialogBox.this.getOverlayHeight();
                double x = DialogBox.this.getOverlayX();
                double y = DialogBox.this.getOverlayY();
                if (parent != null) {
                    parent.resizeRelocate(x, y, w, h);
                }
                if (DialogBox.this.opaqueLayer != null) {
                    DialogBox.this.opaqueLayer.resizeRelocate(x, y, w, h);
                }
                double dialogWidth = DialogBox.this.root.prefWidth(-1.0);
                double dialogHeight = DialogBox.this.root.prefHeight(-1.0);
                DialogBox.this.root.resize((double)((int)dialogWidth), (double)((int)dialogHeight));
                if (this.isFirstRun) {
                    this.isFirstRun = false;
                    double dialogX = DialogBox.this.root.getLayoutX();
                    dialogX = dialogX == 0.0 ? w / 2.0 - dialogWidth / 2.0 : dialogX;
                    double dialogY = DialogBox.this.root.getLayoutY();
                    dialogY = dialogY == 0.0 ? h / 2.0 - dialogHeight / 2.0 : dialogY;
                    DialogBox.this.root.relocate((double)((int)dialogX), (double)((int)dialogY));
                }
            }

            protected double computeMinHeight(double width) {
                return parent.minHeight(width);
            }

            protected double computeMinWidth(double height) {
                return parent.minWidth(height);
            }

            protected double computePrefHeight(double width) {
                return parent.prefHeight(width);
            }

            protected double computePrefWidth(double height) {
                return parent.prefWidth(height);
            }

            protected double computeMaxHeight(double width) {
                return parent.maxHeight(width);
            }

            protected double computeMaxWidth(double height) {
                return parent.maxWidth(height);
            }
        };
        this.dialogStack.setManaged(true);
    }

    private double getOverlayWidth() {
        if (this.owner != null) {
            return this.owner.getLayoutBounds().getWidth();
        }
        if (this.scene != null) {
            return this.scene.getWidth();
        }
        return 0.0;
    }

    private double getOverlayHeight() {
        if (this.owner != null) {
            return this.owner.getLayoutBounds().getHeight();
        }
        if (this.scene != null) {
            return this.scene.getHeight();
        }
        return 0.0;
    }

    private double getOverlayX() {
        return 0.0;
    }

    private double getOverlayY() {
        return 0.0;
    }

    private DialogButton showExtern(Window owner) {
        if (Toolkit.getToolkit().isFxUserThread()) {
            new ShowTask(this, owner).run();
            return this.action;
        }
        Platform.runLater((Runnable)new ShowTask(this, owner));
        return null;
    }

    public DialogBox withInline(boolean value) {
        this.isInline = value;
        return this;
    }

    public DialogBox withAlwaysOnTop(boolean value) {
        this.alwaysOnTop = value;
        return this;
    }

    public DialogBox withModal(boolean modal) {
        this.modal = modal;
        return this;
    }

    void configScene() {
        Scene element = this.scene;
        String dialogsCssUrl = DIALOGS_CSS_URL.toExternalForm();
        if (this.scene != null) {
            if (!this.scene.getStylesheets().contains((Object)dialogsCssUrl)) {
                this.scene.getStylesheets().addAll((Object[])new String[]{dialogsCssUrl});
            }
        } else if (this.owner != null && (element = this.owner.getScene()) != null && !element.getStylesheets().contains((Object)dialogsCssUrl)) {
            element.getStylesheets().addAll((Object[])new String[]{dialogsCssUrl});
        }
    }

    public void createContent() {
        this.root = new BorderPane();
        this.root.getStyleClass().addAll((Object[])new String[]{"dialog", "decorated-root"});
        this.stage.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                boolean active = ((ReadOnlyBooleanProperty)valueModel).get();
                DialogBox.this.root.pseudoClassStateChanged(ACTIVE_PSEUDO_CLASS, active);
            }
        });
        this.dialogTitleBar = new ToolBar();
        this.dialogTitleBar.getStyleClass().add((Object)"window-header");
        this.dialogTitleBar.setPrefHeight(28.0);
        this.dialogTitleBar.setMinHeight(28.0);
        this.dialogTitleBar.setMaxHeight(28.0);
        for (DialogElement element : this.titleElements) {
            this.dialogTitleBar.getItems().add((Object)((Node)element.withOwner(this)));
        }
        this.dialogTitleBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DialogBox.this.mouseDragDeltaX = event.getSceneX();
                DialogBox.this.mouseDragDeltaY = event.getSceneY();
            }
        });
        this.dialogTitleBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (DialogBox.this.isInline) {
                    DialogBox.this.root.setLayoutX(DialogBox.this.root.getLayoutX() + (event.getSceneX() - DialogBox.this.mouseDragDeltaX));
                    DialogBox.this.root.setLayoutY(DialogBox.this.root.getLayoutY() + (event.getSceneY() - DialogBox.this.mouseDragDeltaY));
                    DialogBox.this.mouseDragDeltaX = event.getSceneX();
                    DialogBox.this.mouseDragDeltaY = event.getSceneY();
                } else {
                    DialogBox.this.stage.setX(event.getScreenX() - DialogBox.this.mouseDragDeltaX);
                    DialogBox.this.stage.setY(event.getScreenY() - DialogBox.this.mouseDragDeltaY);
                }
            }
        });
        this.root.setTop((Node)this.dialogTitleBar);
        this.root.setCenter(this.center);
        if (this.actionElements.size() > 0) {
            HBox actionToolbar = new HBox();
            actionToolbar.getStyleClass().add((Object)"window-action");
            for (DialogElement item : this.actionElements) {
                item.withOwner(this);
                actionToolbar.getChildren().add((Object)((Node)item));
            }
            actionToolbar.setAlignment(Pos.TOP_RIGHT);
            this.root.setBottom((Node)actionToolbar);
        }
    }

    public DialogBox withCenter(Node node) {
        this.center = node;
        return this;
    }

    public DialogBox withTitleButton(int index, DialogElement ... value) {
        if (value == null) {
            return this;
        }
        ArrayList<DialogElement> items = new ArrayList<DialogElement>();
        for (DialogElement item : value) {
            items.add(item);
        }
        this.titleElements.addAll(index, items);
        return this;
    }

    public DialogBox withTitleButton(DialogElement ... value) {
        if (value == null) {
            return this;
        }
        for (DialogElement item : value) {
            this.titleElements.add(item);
        }
        return this;
    }

    public DialogBox withActionButton(int index, DialogElement ... value) {
        if (value == null) {
            return this;
        }
        ArrayList<DialogElement> items = new ArrayList<DialogElement>();
        for (DialogElement item : value) {
            items.add(item);
        }
        this.actionElements.addAll(index, items);
        return this;
    }

    public DialogBox withActionButton(DialogElement ... value) {
        if (value == null) {
            return this;
        }
        for (DialogElement item : value) {
            this.actionElements.add(item);
        }
        return this;
    }

    public DialogBox withCenterInfo(String value) {
        this.withCenterText("information.png", value);
        return this;
    }

    public DialogBox withCenterQuestion(String value) {
        this.withCenterText("confirm.png", value);
        return this;
    }

    public DialogBox withCenterText(String image, String value) {
        HBox box = new HBox();
        ImageView imageView = new ImageView(DialogBox.class.getResource(image).toString());
        Label text = new Label(value);
        text.getStyleClass().add((Object)"labelText");
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER);
        vBox.getChildren().add((Object)text);
        box.getChildren().add((Object)imageView);
        box.getChildren().add((Object)vBox);
        box.getStyleClass().add((Object)"centerbox");
        this.center = box;
        return this;
    }

    public static DialogButton showInfo(Window parent, String title, String text) {
        return new DialogBox().withTitle(title).withCenterInfo(text).withActionButton(new DialogButton().withName("OK").withAction(DialogButton.Grafik.close)).show(parent);
    }

    public static DialogButton showInfo(String title, String text) {
        return new DialogBox().withTitle(title).withCenterInfo(text).withActionButton(new DialogButton().withName("OK").withAction(DialogButton.Grafik.close)).show(null);
    }

    public static DialogButton showQuestion(Window parent, String title, String text) {
        return new DialogBox().withTitle(title).withCenterQuestion(text).withActionButton(new DialogButton().withName("Yes").withAction(DialogButton.Grafik.close), new DialogButton().withName("No").withAction(DialogButton.Grafik.close)).show(parent);
    }

    public static boolean createQuestionCheck(Window parent, String title, String text, String ... check) {
        DialogButton action = DialogBox.showQuestion(parent, title, text);
        if (action == null) {
            return false;
        }
        for (String item : check) {
            if (item == null || !item.equalsIgnoreCase(action.getText())) continue;
            return true;
        }
        return false;
    }

    public DialogButton getAction() {
        return this.action;
    }
}

