/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter;

public class ByteConverter64
extends ByteConverter {
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/', '='};
    private static final byte PADDING = 127;
    private static byte[] pem_convert_array = null;

    @Override
    public String toString(BufferedBuffer values) {
        CharacterBuffer buffer = new CharacterBuffer();
        values.back();
        while (!values.isEnd()) {
            byte i = values.getByte();
            byte j = values.getByte();
            byte k = values.getByte();
            buffer.with(pem_array[i >>> 2 & 0x3F]);
            buffer.with(pem_array[(i << 4 & 0x30) + (j >>> 4 & 0xF)]);
            buffer.with(pem_array[(j << 2 & 0x3C) + (k >>> 6 & 3)]);
            buffer.with(pem_array[k & 0x3F]);
        }
        return buffer.toString();
    }

    private int getStaticSize(int size) {
        return (size + 2) / 3 * 4;
    }

    public String toStaticString(CharSequence values) {
        if (values.length() == 0) {
            return values.toString();
        }
        if (values instanceof CharacterBuffer) {
            return this.encode((CharacterBuffer)values, 0, values.length());
        }
        CharacterBuffer buffer = new CharacterBuffer();
        buffer.withObjects(values);
        return this.encode(buffer, 0, buffer.length());
    }

    private String encode(CharacterBuffer buffer, int off, int size) {
        int val;
        byte[] outbuf = new byte[this.getStaticSize(size)];
        int inpos = off;
        int outpos = 0;
        while (size >= 3) {
            val = buffer.charAt(inpos++) & 0xFF;
            val <<= 8;
            val |= buffer.charAt(inpos++) & 0xFF;
            val <<= 8;
            outbuf[outpos + 3] = (byte)pem_array[(val |= buffer.charAt(inpos++) & 0xFF) & 0x3F];
            outbuf[outpos + 2] = (byte)pem_array[(val >>= 6) & 0x3F];
            outbuf[outpos + 1] = (byte)pem_array[(val >>= 6) & 0x3F];
            outbuf[outpos + 0] = (byte)pem_array[(val >>= 6) & 0x3F];
            size -= 3;
            outpos += 4;
        }
        if (size == 1) {
            val = buffer.charAt(inpos++) & 0xFF;
            outbuf[outpos + 3] = 61;
            outbuf[outpos + 2] = 61;
            outbuf[outpos + 1] = (byte)pem_array[(val <<= 4) & 0x3F];
            outbuf[outpos + 0] = (byte)pem_array[(val >>= 6) & 0x3F];
        } else if (size == 2) {
            val = buffer.charAt(inpos++) & 0xFF;
            val <<= 8;
            val |= buffer.charAt(inpos++) & 0xFF;
            outbuf[outpos + 3] = 61;
            outbuf[outpos + 2] = (byte)pem_array[(val <<= 2) & 0x3F];
            outbuf[outpos + 1] = (byte)pem_array[(val >>= 6) & 0x3F];
            outbuf[outpos + 0] = (byte)pem_array[(val >>= 6) & 0x3F];
        }
        return new String(outbuf);
    }

    private void initPEMArray() {
        int i;
        pem_convert_array = new byte[256];
        for (i = 0; i < 255; ++i) {
            ByteConverter64.pem_convert_array[i] = -1;
        }
        for (i = 0; i < pem_array.length; ++i) {
            ByteConverter64.pem_convert_array[ByteConverter64.pem_array[i]] = (byte)i;
        }
        ByteConverter64.pem_convert_array[61] = 127;
    }

    @Override
    public byte[] decode(String value) {
        byte j;
        byte k;
        byte m;
        byte n;
        int i;
        if (value == null) {
            return new byte[0];
        }
        if (pem_convert_array == null) {
            this.initPEMArray();
        }
        byte[] bytes = value.getBytes();
        byte[] result = null;
        for (i = bytes.length - 1; i >= bytes.length - 3; --i) {
            byte c = pem_convert_array[value.charAt(i)];
            if (c == 127) continue;
            if (c != -1) break;
            result = new byte[bytes.length * 3 / 4];
            break;
        }
        result = result == null && value.length() - i > 2 ? new byte[bytes.length * 3 / 4] : new byte[bytes.length * 3 / 4 - bytes.length + ++i];
        int pos = 0;
        for (i = 0; i < bytes.length - 7; i += 4) {
            n = pem_convert_array[bytes[i + 3] & 0xFF];
            m = pem_convert_array[bytes[i + 2] & 0xFF];
            k = pem_convert_array[bytes[i + 1] & 0xFF];
            j = pem_convert_array[bytes[i + 0] & 0xFF];
            result[pos++] = (byte)(j << 2 & 0xFC | k >>> 4 & 3);
            result[pos++] = (byte)(k << 4 & 0xF0 | m >>> 2 & 0xF);
            result[pos++] = (byte)(m << 6 & 0xC0 | n & 0x3F);
        }
        n = pem_convert_array[bytes[i + 3] & 0xFF];
        m = pem_convert_array[bytes[i + 2] & 0xFF];
        k = pem_convert_array[bytes[i + 1] & 0xFF];
        j = pem_convert_array[bytes[i + 0] & 0xFF];
        result[pos++] = (byte)(j << 2 & 0xFC | k >>> 4 & 3);
        if (pos < result.length) {
            result[pos++] = (byte)(k << 4 & 0xF0 | m >>> 2 & 0xF);
            if (pos < result.length) {
                result[pos++] = (byte)(m << 6 & 0xC0 | n & 0x3F);
            }
        }
        return result;
    }
}

