/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverterString;

public class AES {
    public static final int ROUNDS = 14;
    public static final int BLOCK_SIZE = 16;
    public static final int KEY_LENGTH = 32;
    int numRounds;
    byte[][] Ke;
    byte[][] Kd;
    static final byte[] S;
    static final byte[] Si;
    static final byte[] rcon;
    public static final int COL_SIZE = 4;
    public static final int NUM_COLS = 4;
    public static final int ROOT = 283;
    static final int[] row_shift;
    static final int[] alog;
    static final int[] log;
    private ByteConverterString converter = new ByteConverterString();

    public static int getRounds(int keySize) {
        switch (keySize) {
            case 16: {
                return 10;
            }
            case 24: {
                return 12;
            }
        }
        return 14;
    }

    private int mul(int a, int b) {
        return a != 0 && b != 0 ? alog[(log[a & 0xFF] + log[b & 0xFF]) % 255] : 0;
    }

    public CharacterBuffer encode(BufferedBuffer plain) {
        CharacterBuffer result = new CharacterBuffer().withBufferLength(plain.length());
        for (int p = 0; p < plain.length(); p += 16) {
            byte[] partByte = this.encodeBlock(plain);
            if (partByte == null) continue;
            for (int pos = 0; pos < 16; ++pos) {
                result.with((char)partByte[pos]);
            }
        }
        return result;
    }

    public CharacterBuffer encode(String data) {
        CharacterBuffer string = new CharacterBuffer().with(data);
        int rest = data.length() / 32 * 32;
        if (rest < data.length()) {
            rest = 32 - data.length() + rest;
            string.withRepeat(" ", rest);
        }
        CharacterBuffer result = new CharacterBuffer().withBufferLength(string.length());
        ByteBuffer buffer = new ByteBuffer().with(string.array(string.length(), true));
        for (int p = 0; p < string.length(); p += 16) {
            buffer.withPosition(p);
            byte[] partByte = this.encodeBlock(buffer);
            for (int pos = 0; pos < 16; ++pos) {
                result.with((char)partByte[pos]);
            }
        }
        return result;
    }

    private byte[] encodeBlock(BufferedBuffer plain) {
        byte[] a = new byte[16];
        byte[] Ker = this.Ke[0];
        int from = plain.position();
        for (int i = 0; i < 16; ++i) {
            a[i] = (byte)(plain.byteAt(i + from) ^ Ker[i]);
        }
        return this.encodeBlock(a);
    }

    public byte[] encodeBlock(byte[] plain) {
        int k;
        int row;
        int i;
        if (plain == null || plain.length != 16) {
            return null;
        }
        byte[] ta = new byte[16];
        byte[] Ker = this.Ke[0];
        for (int r = 1; r < this.numRounds; ++r) {
            Ker = this.Ke[r];
            for (i = 0; i < 16; ++i) {
                int pos = plain[i] & 0xFF;
                ta[i] = S[pos];
            }
            for (i = 0; i < 16; ++i) {
                row = i % 4;
                k = (i + row_shift[row] * 4) % 16;
                plain[i] = ta[k];
            }
            for (int col = 0; col < 4; ++col) {
                i = col * 4;
                ta[i] = (byte)(this.mul(2, plain[i]) ^ this.mul(3, plain[i + 1]) ^ plain[i + 2] ^ plain[i + 3]);
                ta[i + 1] = (byte)(plain[i] ^ this.mul(2, plain[i + 1]) ^ this.mul(3, plain[i + 2]) ^ plain[i + 3]);
                ta[i + 2] = (byte)(plain[i] ^ plain[i + 1] ^ this.mul(2, plain[i + 2]) ^ this.mul(3, plain[i + 3]));
                ta[i + 3] = (byte)(this.mul(3, plain[i]) ^ plain[i + 1] ^ plain[i + 2] ^ this.mul(2, plain[i + 3]));
            }
            for (i = 0; i < 16; ++i) {
                plain[i] = (byte)(ta[i] ^ Ker[i]);
            }
        }
        Ker = this.Ke[this.numRounds];
        for (i = 0; i < 16; ++i) {
            int pos = plain[i] & 0xFF;
            plain[i] = S[pos];
        }
        for (i = 0; i < 16; ++i) {
            row = i % 4;
            k = (i + row_shift[row] * 4) % 16;
            ta[i] = plain[k];
        }
        for (i = 0; i < 16; ++i) {
            plain[i] = (byte)(ta[i] ^ Ker[i]);
        }
        return plain;
    }

    public CharacterBuffer decode(String data) {
        CharacterBuffer string = new CharacterBuffer().with(data);
        int rest = data.length() / 32 * 32;
        if (rest < data.length()) {
            rest = 32 - data.length() + rest;
            string.withRepeat(" ", rest);
        }
        CharacterBuffer result = new CharacterBuffer().withBufferLength(string.length());
        for (int p = 0; p < string.length(); p += 16) {
            byte[] partByte = this.decodeBlock(string.toCharArray(), p);
            if (partByte == null) continue;
            for (int pos = 0; pos < 16; ++pos) {
                result.with((char)partByte[pos]);
            }
        }
        return result.trim();
    }

    public byte[] decodeString(String value) {
        return this.decode(value).array(-2, true);
    }

    public byte[] decodeBlock(char[] plain, int from) {
        byte[] Kdr = this.Kd[0];
        byte[] a = new byte[16];
        for (int i = 0; i < 16; ++i) {
            a[i] = (byte)(plain[i + from] ^ Kdr[i]);
        }
        return this.decodeBlock(a);
    }

    public byte[] decodeBlock(byte[] cipher) {
        int k;
        int row;
        int i;
        byte[] Kdr;
        if (cipher == null || cipher.length != 16) {
            return null;
        }
        byte[] ta = new byte[16];
        for (int r = 1; r < this.numRounds; ++r) {
            Kdr = this.Kd[r];
            for (i = 0; i < 16; ++i) {
                row = i % 4;
                k = (i + 16 - row_shift[row] * 4) % 16;
                ta[i] = cipher[k];
            }
            for (i = 0; i < 16; ++i) {
                int pos = ta[i] & 0xFF;
                cipher[i] = Si[pos];
            }
            for (i = 0; i < 16; ++i) {
                ta[i] = (byte)(cipher[i] ^ Kdr[i]);
            }
            for (int col = 0; col < 4; ++col) {
                i = col * 4;
                cipher[i] = (byte)(this.mul(14, ta[i]) ^ this.mul(11, ta[i + 1]) ^ this.mul(13, ta[i + 2]) ^ this.mul(9, ta[i + 3]));
                cipher[i + 1] = (byte)(this.mul(9, ta[i]) ^ this.mul(14, ta[i + 1]) ^ this.mul(11, ta[i + 2]) ^ this.mul(13, ta[i + 3]));
                cipher[i + 2] = (byte)(this.mul(13, ta[i]) ^ this.mul(9, ta[i + 1]) ^ this.mul(14, ta[i + 2]) ^ this.mul(11, ta[i + 3]));
                cipher[i + 3] = (byte)(this.mul(11, ta[i]) ^ this.mul(13, ta[i + 1]) ^ this.mul(9, ta[i + 2]) ^ this.mul(14, ta[i + 3]));
            }
        }
        Kdr = this.Kd[this.numRounds];
        for (i = 0; i < 16; ++i) {
            row = i % 4;
            k = (i + 16 - row_shift[row] * 4) % 16;
            ta[i] = cipher[k];
        }
        for (i = 0; i < 16; ++i) {
            ta[i] = Si[ta[i] & 0xFF];
        }
        for (i = 0; i < 16; ++i) {
            cipher[i] = (byte)(ta[i] ^ Kdr[i]);
        }
        return cipher;
    }

    public AES withKey(String key) {
        this.withKey(this.converter.decode(key));
        return this;
    }

    public AES withKey(byte[] key) throws IllegalArgumentException {
        int i;
        int Klen;
        int BC = 4;
        if (key.length == 16 || key.length == 24 || key.length == 32) {
            Klen = key.length;
        } else if (key.length > 32) {
            Klen = 32;
        } else {
            Klen = key.length > 24 ? 32 : (key.length > 16 ? 24 : 16);
            byte[] old = key;
            key = new byte[Klen];
            for (i = 0; i < old.length; ++i) {
                key[i] = old[i];
            }
        }
        int Nk = Klen / 4;
        this.numRounds = AES.getRounds(Klen);
        int ROUND_KEY_COUNT = (this.numRounds + 1) * 4;
        byte[] w0 = new byte[ROUND_KEY_COUNT];
        byte[] w1 = new byte[ROUND_KEY_COUNT];
        byte[] w2 = new byte[ROUND_KEY_COUNT];
        byte[] w3 = new byte[ROUND_KEY_COUNT];
        this.Ke = new byte[this.numRounds + 1][16];
        this.Kd = new byte[this.numRounds + 1][16];
        int j = 0;
        for (i = 0; i < Nk; ++i) {
            w0[i] = key[j++];
            w1[i] = key[j++];
            w2[i] = key[j++];
            w3[i] = key[j++];
        }
        for (i = Nk; i < ROUND_KEY_COUNT; ++i) {
            byte t0 = w0[i - 1];
            byte t1 = w1[i - 1];
            byte t2 = w2[i - 1];
            byte t3 = w3[i - 1];
            if (i % Nk == 0) {
                byte old0 = t0;
                t0 = (byte)(S[t1 & 0xFF] ^ rcon[i / Nk]);
                t1 = S[t2 & 0xFF];
                t2 = S[t3 & 0xFF];
                t3 = S[old0 & 0xFF];
            } else if (Nk > 6 && i % Nk == 4) {
                t0 = S[t0 & 0xFF];
                t1 = S[t1 & 0xFF];
                t2 = S[t2 & 0xFF];
                t3 = S[t3 & 0xFF];
            }
            w0[i] = (byte)(w0[i - Nk] ^ t0);
            w1[i] = (byte)(w1[i - Nk] ^ t1);
            w2[i] = (byte)(w2[i - Nk] ^ t2);
            w3[i] = (byte)(w3[i - Nk] ^ t3);
        }
        i = 0;
        for (int r = 0; r < this.numRounds + 1; ++r) {
            for (j = 0; j < 4; ++j) {
                this.Ke[r][4 * j] = w0[i];
                this.Ke[r][4 * j + 1] = w1[i];
                this.Ke[r][4 * j + 2] = w2[i];
                this.Ke[r][4 * j + 3] = w3[i];
                this.Kd[this.numRounds - r][4 * j] = w0[i];
                this.Kd[this.numRounds - r][4 * j + 1] = w1[i];
                this.Kd[this.numRounds - r][4 * j + 2] = w2[i];
                this.Kd[this.numRounds - r][4 * j + 3] = w3[i];
                ++i;
            }
        }
        return this;
    }

    static {
        int i;
        S = new byte[]{99, 124, 119, 123, -14, 107, 111, -59, 48, 1, 103, 43, -2, -41, -85, 118, -54, -126, -55, 125, -6, 89, 71, -16, -83, -44, -94, -81, -100, -92, 114, -64, -73, -3, -109, 38, 54, 63, -9, -52, 52, -91, -27, -15, 113, -40, 49, 21, 4, -57, 35, -61, 24, -106, 5, -102, 7, 18, -128, -30, -21, 39, -78, 117, 9, -125, 44, 26, 27, 110, 90, -96, 82, 59, -42, -77, 41, -29, 47, -124, 83, -47, 0, -19, 32, -4, -79, 91, 106, -53, -66, 57, 74, 76, 88, -49, -48, -17, -86, -5, 67, 77, 51, -123, 69, -7, 2, 127, 80, 60, -97, -88, 81, -93, 64, -113, -110, -99, 56, -11, -68, -74, -38, 33, 16, -1, -13, -46, -51, 12, 19, -20, 95, -105, 68, 23, -60, -89, 126, 61, 100, 93, 25, 115, 96, -127, 79, -36, 34, 42, -112, -120, 70, -18, -72, 20, -34, 94, 11, -37, -32, 50, 58, 10, 73, 6, 36, 92, -62, -45, -84, 98, -111, -107, -28, 121, -25, -56, 55, 109, -115, -43, 78, -87, 108, 86, -12, -22, 101, 122, -82, 8, -70, 120, 37, 46, 28, -90, -76, -58, -24, -35, 116, 31, 75, -67, -117, -118, 112, 62, -75, 102, 72, 3, -10, 14, 97, 53, 87, -71, -122, -63, 29, -98, -31, -8, -104, 17, 105, -39, -114, -108, -101, 30, -121, -23, -50, 85, 40, -33, -116, -95, -119, 13, -65, -26, 66, 104, 65, -103, 45, 15, -80, 84, -69, 22};
        Si = new byte[]{82, 9, 106, -43, 48, 54, -91, 56, -65, 64, -93, -98, -127, -13, -41, -5, 124, -29, 57, -126, -101, 47, -1, -121, 52, -114, 67, 68, -60, -34, -23, -53, 84, 123, -108, 50, -90, -62, 35, 61, -18, 76, -107, 11, 66, -6, -61, 78, 8, 46, -95, 102, 40, -39, 36, -78, 118, 91, -94, 73, 109, -117, -47, 37, 114, -8, -10, 100, -122, 104, -104, 22, -44, -92, 92, -52, 93, 101, -74, -110, 108, 112, 72, 80, -3, -19, -71, -38, 94, 21, 70, 87, -89, -115, -99, -124, -112, -40, -85, 0, -116, -68, -45, 10, -9, -28, 88, 5, -72, -77, 69, 6, -48, 44, 30, -113, -54, 63, 15, 2, -63, -81, -67, 3, 1, 19, -118, 107, 58, -111, 17, 65, 79, 103, -36, -22, -105, -14, -49, -50, -16, -76, -26, 115, -106, -84, 116, 34, -25, -83, 53, -123, -30, -7, 55, -24, 28, 117, -33, 110, 71, -15, 26, 113, 29, 41, -59, -119, 111, -73, 98, 14, -86, 24, -66, 27, -4, 86, 62, 75, -58, -46, 121, 32, -102, -37, -64, -2, 120, -51, 90, -12, 31, -35, -88, 51, -120, 7, -57, 49, -79, 18, 16, 89, 39, -128, -20, 95, 96, 81, 127, -87, 25, -75, 74, 13, 45, -27, 122, -97, -109, -55, -100, -17, -96, -32, 59, 77, -82, 42, -11, -80, -56, -21, -69, 60, -125, 83, -103, 97, 23, 43, 4, 126, -70, 119, -42, 38, -31, 105, 20, 99, 85, 33, 12, 125};
        rcon = new byte[]{0, 1, 2, 4, 8, 16, 32, 64, -128, 27, 54, 108, -40, -85, 77, -102, 47, 94, -68, 99, -58, -105, 53, 106, -44, -77, 125, -6, -17, -59, -111};
        row_shift = new int[]{0, 1, 2, 3};
        alog = new int[256];
        log = new int[256];
        AES.alog[0] = 1;
        for (i = 1; i < 256; ++i) {
            int j = alog[i - 1] << 1 ^ alog[i - 1];
            if ((j & 0x100) != 0) {
                j ^= 0x11B;
            }
            AES.alog[i] = j;
        }
        for (i = 1; i < 255; ++i) {
            AES.log[AES.alog[i]] = i;
        }
    }
}

