/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui.controls;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.list.SimpleList;
import java.util.Collection;

public class Form
extends Control {
    public static final String FORM = "form";
    public static final String METHOD = "method";
    public static final String ELEMENTS = "elements";
    protected String method = "get";
    private SimpleList<Control> elements;

    public Form() {
        this.className = FORM;
        this.addBaseElements(METHOD);
        this.addBaseElements(ELEMENTS);
    }

    public String getMethod() {
        return this.method;
    }

    public boolean setMethod(String value) {
        String oldValue = this.method;
        this.method = value;
        return this.firePropertyChange(METHOD, oldValue, value);
    }

    public SimpleList<Control> getElements() {
        return this.elements;
    }

    public Form withElement(Control ... elements) {
        this.addElement(elements);
        return this;
    }

    public boolean addElement(Control ... elements) {
        if (elements == null) {
            return false;
        }
        boolean changed = false;
        if (this.elements == null) {
            this.elements = new SimpleList();
        }
        for (Control control : elements) {
            if (!this.elements.add(control)) continue;
            changed = true;
            this.firePropertyChange(ELEMENTS, null, control);
        }
        return changed;
    }

    @Override
    public Object getValue(String key) {
        if (METHOD.equals(key)) {
            return this.getMethod();
        }
        if (ELEMENTS.equals(key)) {
            return this.getElements();
        }
        return super.getValue(key);
    }

    @Override
    public boolean setValue(String key, Object value) {
        if (METHOD.equals(key)) {
            return this.setMethod("" + value);
        }
        if (ELEMENTS.equals(key)) {
            if (value instanceof Control) {
                return this.addElement((Control)value);
            }
            if (value instanceof Control[]) {
                return this.addElement((Control[])value);
            }
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                Control[] array = ((Collection)value).toArray(new Control[list.size()]);
                return this.addElement(array);
            }
        }
        return super.setValue(key, value);
    }

    public Form withDataBinding(IdMap map, Object entity, boolean addCommandBtn) {
        return this;
    }
}

