/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.beans.PropertyChangeEvent;

public class CompareTo
implements ObjectCondition,
SendableEntityCreator {
    public static final String VALUE = "value";
    public static final String COMPARE = "compare";
    public static final int GREATER = 1;
    public static final int LOWER = -1;
    private Comparable<Object> value;
    private int compare;

    public Comparable<?> getValue() {
        return this.value;
    }

    public CompareTo withValue(Comparable<Object> value) {
        this.value = value;
        return this;
    }

    public int getCompare() {
        return this.compare;
    }

    public CompareTo withCompare(int compare) {
        this.compare = compare;
        return this;
    }

    @Override
    public boolean update(Object value) {
        PropertyChangeEvent evt = (PropertyChangeEvent)value;
        Object entityValue = evt.getNewValue();
        if (entityValue != null && entityValue instanceof Comparable) {
            Comparable comparatorValue = (Comparable)entityValue;
            if (this.compare < 0) {
                return this.value.compareTo(comparatorValue) <= this.compare;
            }
            return this.value.compareTo(comparatorValue) >= this.compare;
        }
        return false;
    }

    @Override
    public String[] getProperties() {
        return new String[]{COMPARE, VALUE};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new CompareTo();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (COMPARE.equalsIgnoreCase(attribute)) {
            return ((CompareTo)entity).getCompare();
        }
        if (VALUE.equalsIgnoreCase(attribute)) {
            return ((CompareTo)entity).getValue();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (COMPARE.equalsIgnoreCase(attribute)) {
            ((CompareTo)entity).withCompare(Integer.parseInt("" + value));
            return true;
        }
        if (VALUE.equalsIgnoreCase(attribute)) {
            if (value instanceof Comparable) {
                ((CompareTo)entity).withValue((Comparable)value);
            }
            return true;
        }
        return false;
    }
}

