/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.dialog;

import de.uniks.networkparser.ext.javafx.dialog.DialogBox;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ShowTask
implements Runnable {
    public DialogBox parent;
    private Window owner;

    public ShowTask(DialogBox parent, Window owner) {
        this.parent = parent;
        this.owner = owner;
    }

    @Override
    public void run() {
        this.parent.stage = new Stage(StageStyle.TRANSPARENT){

            public void showAndWait() {
                this.centerOnScreen();
                super.showAndWait();
            }

            public void centerOnScreen() {
                Window owner = this.getOwner();
                if (owner != null && owner.getScene() != null) {
                    double y;
                    double x;
                    Scene scene = owner.getScene();
                    double titleBarHeight = scene.getY();
                    double dialogWidth = ShowTask.this.parent.root.prefWidth(-1.0);
                    double dialogHeight = ShowTask.this.parent.root.prefHeight(-1.0);
                    if (owner.getX() < 0.0 || owner.getY() < 0.0) {
                        Screen screen = Screen.getPrimary();
                        double maxW = screen.getVisualBounds().getWidth();
                        double maxH = screen.getVisualBounds().getHeight();
                        x = maxW / 2.0 - dialogWidth / 2.0;
                        y = maxH / 2.0 - dialogHeight / 2.0 + titleBarHeight;
                    } else {
                        x = owner.getX() + scene.getWidth() / 2.0 - dialogWidth / 2.0;
                        y = owner.getY() + titleBarHeight + scene.getHeight() / 2.0 - dialogHeight / 2.0;
                    }
                    this.setX(x);
                    this.setY(y);
                }
            }
        };
        if (this.owner != null) {
            this.parent.stage.initOwner(this.owner);
        }
        if (this.parent.modal) {
            if (this.owner != null) {
                this.parent.stage.initModality(Modality.WINDOW_MODAL);
            } else {
                this.parent.stage.initModality(Modality.APPLICATION_MODAL);
            }
        } else {
            this.parent.stage.initModality(Modality.NONE);
        }
        this.parent.createContent();
        this.parent.scene = new Scene((Parent)this.parent.root);
        this.parent.scene.setFill((Paint)Color.TRANSPARENT);
        this.parent.stage.setScene(this.parent.scene);
        this.parent.configScene();
        if (this.parent.modal) {
            this.parent.stage.showAndWait();
            return;
        }
        this.parent.stage.show();
    }
}

