/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class FileBuffer
extends Buffer {
    private BufferedReader reader;
    private File file;
    private CharacterBuffer lookAHead = new CharacterBuffer();
    private int length;
    private char currentChar;

    public FileBuffer withFile(String fileName) {
        this.withFile(new File(fileName));
        return this;
    }

    public FileBuffer withFile(File file) {
        this.file = file;
        this.length = (int)this.file.length();
        try {
            FileInputStream fis = new FileInputStream(this.file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
            this.reader = new BufferedReader(isr, 0x100000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.position = 0;
        return this;
    }

    @Override
    public int length() {
        return this.length;
    }

    public boolean exist() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    @Override
    public char getChar() {
        char value = '\u0000';
        if (this.lookAHead.length() > 0) {
            value = this.lookAHead.charAt(0);
            if (this.lookAHead.length() == 1) {
                this.lookAHead.clear();
            } else {
                this.lookAHead.addStart(1);
            }
            ++this.position;
            return value;
        }
        try {
            this.currentChar = value = (char)this.reader.read();
            ++this.position;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    public String toString() {
        char[] values = new char[this.remaining()];
        int len = this.lookAHead.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                values[i] = this.lookAHead.charAt(i);
            }
        }
        try {
            int max = values.length - len;
            int read = this.reader.read(values, len, max);
            if (read < max) {
                this.length = max - read;
            }
            this.position = this.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(values);
    }

    @Override
    public FileBuffer withLookAHead(CharSequence lookahead) {
        this.lookAHead.set(lookahead);
        this.currentChar = lookahead.charAt(0);
        this.lookAHead.addStart(1);
        this.position -= this.lookAHead.length();
        return this;
    }

    @Override
    public FileBuffer withLookAHead(char current) {
        this.lookAHead.set(this.currentChar);
        this.currentChar = current;
        --this.position;
        return this;
    }

    @Override
    public char nextClean(boolean currentValid) {
        char current;
        this.currentChar = current = super.nextClean(currentValid);
        return current;
    }

    @Override
    public char getCurrentChar() {
        if (this.currentChar != '\u0000') {
            return this.currentChar;
        }
        char value = this.getChar();
        return value;
    }

    @Override
    public byte getByte() {
        return (byte)this.getChar();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final boolean writeFile(String fileName, CharSequence data, boolean appendData) {
        FileBuffer buffer = new FileBuffer();
        buffer.withFile(fileName);
        if (!buffer.exist() && !buffer.createFile()) {
            return false;
        }
        return buffer.write(data, appendData);
    }

    public static final boolean writeFile(String fileName, CharSequence data) {
        return FileBuffer.writeFile(fileName, data, false);
    }

    private boolean createFile() {
        if (this.file == null) {
            return false;
        }
        File parentFile = this.file.getParentFile();
        if (parentFile.exists()) {
            return true;
        }
        return parentFile.mkdirs();
    }

    public boolean write(CharSequence data, boolean append) {
        if (this.file == null) {
            return false;
        }
        try {
            FileOutputStream os = new FileOutputStream(this.file, append);
            os.write(data.toString().getBytes());
            os.flush();
            os.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

