/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.error;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class ErrorHandler
implements Thread.UncaughtExceptionHandler {
    private String path;

    public ErrorHandler(String path) {
        this.path = path;
    }

    public boolean writeErrorFile(String fileName, String filepath, Throwable e, Object extra) {
        boolean success;
        try {
            String fullfilename;
            File file;
            filepath = ErrorHandler.createDir(filepath);
            if (!filepath.endsWith("/")) {
                filepath = filepath + "/";
            }
            if (!(file = new File(fullfilename = filepath + fileName)).exists()) {
                file.createNewFile();
            }
            FileOutputStream networkFile = new FileOutputStream(filepath + "/" + fileName);
            PrintStream ps = new PrintStream(networkFile);
            ps.println("Error: " + e.getMessage());
            if (extra != null) {
                ps.println("Extra: " + extra.toString());
            }
            ps.println("Thread: " + Thread.currentThread().getName());
            ps.println("------------ SYSTEM-INFO ------------");
            ErrorHandler.printProperty(ps, "java.class.version");
            ErrorHandler.printProperty(ps, "java.runtime.version");
            ErrorHandler.printProperty(ps, "java.specification.version");
            ErrorHandler.printProperty(ps, "java.version");
            ErrorHandler.printProperty(ps, "os.arch");
            ErrorHandler.printProperty(ps, "os.name");
            ErrorHandler.printProperty(ps, "os.version");
            ErrorHandler.printProperty(ps, "user.dir");
            ErrorHandler.printProperty(ps, "user.home");
            ErrorHandler.printProperty(ps, "user.language");
            ErrorHandler.printProperty(ps, "user.name");
            ErrorHandler.printProperty(ps, "user.timezone");
            ps.println("");
            Runtime r = Runtime.getRuntime();
            ps.println("Prozessoren :       " + r.availableProcessors());
            ps.println("Freier Speicher JVM:    " + r.freeMemory());
            ps.println("Maximaler Speicher JVM: " + r.maxMemory());
            ps.println("Gesamter Speicher JVM:  " + r.totalMemory());
            ps.println("***  ***");
            ps.println();
            e.printStackTrace(ps);
            ps.close();
            success = true;
        }
        catch (FileNotFoundException exception) {
            success = false;
        }
        catch (IOException exception) {
            success = false;
        }
        return success;
    }

    public static void printProperty(PrintStream ps, String property) {
        ps.println(property + ": " + System.getProperty(property));
    }

    public static String createDir(String path) {
        File dirPath = new File(path);
        if (!(dirPath = new File(dirPath.getPath())).exists()) {
            if (dirPath.mkdirs()) {
                return path;
            }
        } else {
            return path;
        }
        return null;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        GregorianCalendar temp = new GregorianCalendar();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String prefixName = formatter.format(temp.getTime()) + "_";
        this.writeErrorFile(prefixName + "error.txt", this.path, e, null);
    }
}

