/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.CharacterBuffer;

public class CharacterReader
extends CharacterBuffer {
    protected int line;
    protected int character;
    private boolean isString = true;

    public boolean isString() {
        return this.isString;
    }

    public CharacterReader withString(boolean isString) {
        this.isString = isString;
        return this;
    }

    @Override
    public boolean back() {
        if (super.back()) {
            --this.character;
            return true;
        }
        return false;
    }

    @Override
    public char getChar() {
        char c = super.getChar();
        if (c == '\n') {
            ++this.line;
            this.character = 0;
        } else {
            ++this.character;
        }
        return c;
    }

    @Override
    public CharacterBuffer nextString(CharacterBuffer sc, boolean allowQuote, boolean nextStep, char ... quotes) {
        if (quotes == null) {
            return sc;
        }
        boolean found = false;
        for (char quote : quotes) {
            if ('\"' != quote) continue;
            found = true;
            this.isString = this.getCurrentChar() == quote ? true : !this.isString;
        }
        if (!found && this.getCurrentChar() == '\"') {
            this.isString = true;
            while (true) {
                int len = sc.length();
                super.nextString(sc, allowQuote, nextStep, quotes);
                if (sc.length() <= len || sc.endsWith("\"", false)) break;
                sc.with(',');
            }
            return sc;
        }
        super.nextString(sc, allowQuote, nextStep, quotes);
        return sc;
    }

    @Override
    public CharacterReader with(CharSequence ... items) {
        super.with(items);
        return this;
    }
}

