/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.DateField;
import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.TextItems;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import java.util.Date;
import java.util.HashMap;

public class DateTimeEntity {
    public static final String W3CDTF_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private boolean dirty;
    private Long time;
    private Byte timeZone = 1;
    private HashMap<DateField, Long> fields = new HashMap();
    private TextItems items;
    public String[] monthOfYear = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public String[] weekDays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private boolean isInitConstants = false;
    static final int[] MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int ONE_SECOND = 1000;
    public static final int ONE_MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    public static final long ONE_YEAR = 31536000000L;
    public static final long ONE_YEAR_LY = 31622400000L;
    private transient int GREGORIANCUTOVERYEAR = 1582;

    public int getMonthLength(int month, int year) {
        if (this.isLeapYear(year)) {
            return this.getMonthLengthLP(month);
        }
        return MONTH_LENGTH[month];
    }

    private int getMonthLengthLP(int month) {
        if (month == 1) {
            return MONTH_LENGTH[month] + 1;
        }
        if (month < 0 || month > 11) {
            return 0;
        }
        return MONTH_LENGTH[month];
    }

    public int getYearLength(int year) {
        return this.isLeapYear(year) ? 366 : 365;
    }

    public boolean isLeapYear(int year) {
        if ((year & 3) != 0) {
            return false;
        }
        if (year > this.GREGORIANCUTOVERYEAR) {
            return year % 100 != 0 || year % 400 == 0;
        }
        return true;
    }

    private boolean internCalculate(long time, boolean calc) {
        long daymillis;
        long temp;
        long years = time / 31536000000L + 1970L;
        long schaltjahre = (years - 1L - 1968L) / 4L - (years - 1L - 1900L) / 100L + (years - 1L - 1600L) / 400L;
        long yearMillis = (time - (schaltjahre - 1L) * 86400000L) % 31536000000L;
        int year = (int)((time - schaltjahre * 86400000L) / 31536000000L) + 1970;
        int month = 0;
        long day = 0L;
        if (this.isLeapYear(year)) {
            for (temp = yearMillis; temp > 0L; temp -= (long)this.getMonthLengthLP(month++) * 86400000L) {
            }
            day = (temp + (long)this.getMonthLengthLP(month - 1) * 86400000L) / 86400000L;
            if (day == 0L) {
                day = ((temp += (long)this.getMonthLengthLP(--month) * 86400000L) + (long)this.getMonthLengthLP(month - 1) * 86400000L) / 86400000L;
            }
        } else {
            while (temp > 0L) {
                temp -= (long)MONTH_LENGTH[month++] * 86400000L;
            }
            day = (temp + (long)MONTH_LENGTH[month - 1] * 86400000L) / 86400000L;
            if (day == 0L) {
                day = ((temp += (long)MONTH_LENGTH[--month] * 86400000L) + (long)MONTH_LENGTH[month - 1] * 86400000L) / 86400000L;
            }
        }
        if ((daymillis = time % 86400000L) > 43200000L) {
            this.fields.put(DateField.AMPM, 1L);
        } else {
            this.fields.put(DateField.AMPM, 0L);
        }
        long hour = daymillis / 3600000L;
        long dayOfWeek = (time / 86400000L + 4L) % 7L;
        long leftDays = 31L - day;
        if (calc) {
            if (month > 3 && month < 10) {
                return true;
            }
            if (month == 3 && leftDays < 7L ? 7L - dayOfWeek >= leftDays || dayOfWeek == 7L : (month == 10 && leftDays < 7L || dayOfWeek == 7L) && 7L - dayOfWeek < leftDays) {
                return true;
            }
        }
        this.fields.put(DateField.MILLISECOND_OF_DAY, daymillis);
        this.fields.put(DateField.HOUR_OF_DAY, hour);
        this.fields.put(DateField.MINUTE_OF_HOUR, daymillis % 3600000L / 60000L);
        this.fields.put(DateField.SECOND_OF_MINUTE, daymillis % 60000L / 1000L);
        this.fields.put(DateField.MILLISECOND_OF_YEAR, yearMillis);
        long dayOfYear = yearMillis / 86400000L;
        this.fields.put(DateField.DAY_OF_YEAR, dayOfYear);
        this.fields.put(DateField.YEAR, Long.valueOf(year));
        this.fields.put(DateField.MONTH, Long.valueOf(month));
        this.fields.put(DateField.DAY_OF_MONTH, day);
        this.fields.put(DateField.DAY_OF_WEEK, dayOfWeek);
        long week = dayOfYear / 7L;
        if (dayOfYear % 7L > 0L) {
            ++week;
        }
        this.fields.put(DateField.WEEK_OF_YEAR, week);
        this.fields.put(DateField.WEEK_OF_MONTH, week - (dayOfYear - day) / 7L);
        this.fields.put(DateField.MILLISECONDSREAL, time);
        return false;
    }

    public void calculate() {
        if (this.dirty) {
            Long time = this.getTimeWithTimeZone();
            this.fields.put(DateField.MILLISECONDS, time);
            this.fields.put(DateField.MILLISECOND, time % 1000L);
            if (this.internCalculate(time, true)) {
                time = time + 3600000L;
                this.internCalculate(time, false);
            }
            this.dirty = false;
        }
    }

    public long get(DateField field) {
        if (this.time == null) {
            this.time = System.currentTimeMillis();
            this.dirty = true;
        }
        if (this.isDirty()) {
            this.calculate();
        }
        return this.fields.get((Object)field);
    }

    public Long getTimeWithTimeZone() {
        if (this.timeZone != null) {
            return this.time + (long)(this.timeZone * 3600000);
        }
        return this.time;
    }

    public DateTimeEntity withTime(Long value) {
        if (value == null || !value.equals(this.time)) {
            this.time = value;
            this.dirty = true;
        }
        return this;
    }

    public DateTimeEntity addTime(long value) {
        if (value != 0L) {
            DateTimeEntity dateTimeEntity = this;
            dateTimeEntity.time = dateTimeEntity.time + value;
            this.dirty = true;
        }
        return this;
    }

    public byte getTimezone() {
        return this.timeZone;
    }

    public DateTimeEntity withTimezone(Byte value) {
        if (this.timeZone == null && value != null || this.timeZone != null && !this.timeZone.equals(value)) {
            this.timeZone = value;
            this.dirty = true;
        }
        return this;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void add(DateField field, int value) {
        Long oldValue = this.get(field);
        if (oldValue != null) {
            this.set(field, oldValue + (long)value);
        }
    }

    public void set(DateField field, int value) {
        this.set(field, (long)value);
    }

    public void set(DateField field, long value) {
        if (field != null) {
            long oldValue = this.getValueInMillisecond(field);
            switch (field) {
                case MONTH: {
                    oldValue = this.getValueInMillisecond(DateField.MILLISECOND_OF_YEAR);
                    this.fields.put(field, value);
                    this.addTime(this.getValueInMillisecond(DateField.MILLISECOND_OF_YEAR) - oldValue);
                    break;
                }
                case TIMEZONE: {
                    this.withTimezone((byte)value);
                    break;
                }
                default: {
                    this.fields.put(field, value);
                    this.addTime(this.getValueInMillisecond(field) - oldValue);
                }
            }
        }
    }

    public DateTimeEntity withValue(long milliseconds) {
        this.withTime(milliseconds);
        return this;
    }

    public DateTimeEntity withValue(int year, int month, int day) {
        this.withYear(year);
        this.withMonth(month);
        this.withDate(day);
        return this;
    }

    public DateTimeEntity withValue(String date) {
        this.withYear(Integer.parseInt(date.substring(6, 9)));
        this.withMonth(Integer.parseInt(date.substring(3, 4)));
        this.withDate(Integer.parseInt(date.substring(0, 1)));
        return this;
    }

    public DateTimeEntity withValue(Date date) {
        this.withValue(date.getTime());
        return this;
    }

    public DateTimeEntity withNewDate(long date) {
        this.withTime(date * 1000L);
        return this;
    }

    public DateTimeEntity withTextItems(TextItems items) {
        this.items = items;
        return this;
    }

    private void initDate() {
        if (this.items != null && !this.isInitConstants) {
            int i;
            for (i = 0; i < 12; ++i) {
                this.monthOfYear[i] = this.items.getText(this.monthOfYear[i], this, null);
            }
            for (i = 0; i < 7; ++i) {
                this.weekDays[i] = this.items.getText(this.weekDays[i], this, null);
            }
            this.isInitConstants = true;
        }
    }

    public void setMidnight() {
        long result = this.getTime() % 86400000L;
        this.withTime(this.getTime() + 86400000L - result);
    }

    public static DateTimeEntity getEasterSunday(int year) {
        int i = year % 19;
        int j = year / 100;
        int k = year % 100;
        int l = (19 * i + j - j / 4 - (j - (j + 8) / 25 + 1) / 3 + 15) % 30;
        int m = (32 + 2 * (j % 4) + 2 * (k / 4) - l - k % 4) % 7;
        int n = l + m - 7 * ((i + 11 * l + 22 * m) / 451) + 114;
        int month = n / 31;
        int day = n % 31 + 1;
        return new DateTimeEntity().withValue(year, month - 1, day);
    }

    public String toString(String dateFormat) {
        String sub;
        this.initDate();
        this.calculate();
        StringBuilder sb = new StringBuilder();
        Tokener tokener = new Tokener();
        dateFormat = dateFormat.replaceAll("'", "\"");
        tokener.withBuffer(dateFormat);
        boolean isString = false;
        do {
            if ((sub = tokener.nextString(new CharacterBuffer(), false, false, '\"').toString()).length() > 0 && !isString) {
                sub = sub.replace("HZ", EntityUtil.strZero(this.get(DateField.HOUR_OF_DAY) - (long)this.getTimezone(), 2));
                sub = sub.replace("HH", EntityUtil.strZero(this.get(DateField.HOUR_OF_DAY), 2));
                sub = sub.replace("H", String.valueOf(this.get(DateField.HOUR_OF_DAY)));
                sub = sub.replace("MM", EntityUtil.strZero(this.get(DateField.MINUTE_OF_HOUR), 2));
                sub = sub.replace("M", String.valueOf(this.get(DateField.MINUTE_OF_HOUR)));
                sub = sub.replace("SS", EntityUtil.strZero(this.get(DateField.SECOND_OF_MINUTE), 2));
                sub = sub.replace("S", String.valueOf(this.get(DateField.SECOND_OF_MINUTE)));
                sub = sub.replace("dddd", this.weekDays[(int)this.get(DateField.DAY_OF_WEEK)]);
                sub = sub.replace("ddd", this.weekDays[(int)this.get(DateField.DAY_OF_WEEK)].substring(0, 2));
                sub = sub.replace("dd", EntityUtil.strZero(this.get(DateField.DAY_OF_MONTH), 2));
                sub = sub.replace("d", String.valueOf(this.get(DateField.DAY_OF_MONTH)));
                sub = sub.replace("mmmm", this.monthOfYear[(int)this.get(DateField.MONTH) - 1]);
                sub = sub.replace("mmm", this.monthOfYear[(int)this.get(DateField.MONTH) - 1].substring(0, 3));
                sub = sub.replace("mm", EntityUtil.strZero(this.get(DateField.MONTH), 2));
                sub = sub.replace("m", String.valueOf(this.get(DateField.MONTH)));
                sub = sub.replace("yyyy", String.valueOf(this.get(DateField.YEAR)));
                sub = sub.replace("yyy", String.valueOf(this.get(DateField.YEAR)));
                sub = sub.replace("yy", EntityUtil.strZero(this.get(DateField.YEAR), 2, 2));
                sub = sub.replace("y", EntityUtil.strZero(this.get(DateField.YEAR), 1, 2));
                sub = this.timeZone > 0 ? sub.replace("Z", "+" + EntityUtil.strZero(this.timeZone.byteValue(), 2, 2) + "00") : (this.timeZone < 0 ? sub.replace("Z", "-" + EntityUtil.strZero(this.timeZone.byteValue(), 2, 2) + "00") : sub.replace("Z", "0000"));
                sub = sub.replace("z", "CEST");
            }
            sb.append(sub);
            if (tokener.getCurrentChar() == '\"') {
                tokener.getChar();
            }
            boolean bl = isString = !isString;
        } while (sub.length() > 0);
        return sb.toString();
    }

    public String toString() {
        return this.fields.get((Object)DateField.DAY_OF_MONTH) + "." + this.fields.get((Object)DateField.MONTH) + "." + this.fields.get((Object)DateField.YEAR);
    }

    public DateTimeEntity withYear(int value) {
        this.set(DateField.YEAR, value);
        return this;
    }

    public DateTimeEntity withMonth(int value) {
        this.set(DateField.MONTH, value);
        return this;
    }

    public DateTimeEntity withDate(int value) {
        this.set(DateField.DAY_OF_MONTH, value);
        return this;
    }

    public DateTimeEntity withHour(int value) {
        this.set(DateField.HOUR_OF_DAY, value);
        return this;
    }

    public DateTimeEntity withMinute(int value) {
        this.set(DateField.MINUTE_OF_HOUR, value);
        return this;
    }

    public DateTimeEntity withSecond(int value) {
        this.set(DateField.SECOND_OF_MINUTE, value);
        return this;
    }

    public long getTime() {
        if (this.time == null) {
            this.time = System.currentTimeMillis();
            this.dirty = true;
        }
        return this.time;
    }

    public long getValueInMillisecond(DateField field) {
        long value = this.fields.get((Object)field);
        if (field == DateField.MILLISECOND || field == DateField.MILLISECONDS || field == DateField.MILLISECOND_OF_YEAR || field == DateField.MILLISECOND_OF_DAY || field == DateField.MILLISECONDSREAL) {
            return value;
        }
        if (field == DateField.SECOND_OF_MINUTE) {
            return value * 1000L;
        }
        if (field == DateField.MINUTE_OF_HOUR) {
            return value * 60000L;
        }
        if (field == DateField.HOUR_OF_DAY) {
            return value * 3600000L;
        }
        if (field == DateField.DAY_OF_WEEK || field == DateField.DAY_OF_MONTH || field == DateField.DAY_OF_YEAR) {
            return value * 86400000L;
        }
        if (field == DateField.AMPM) {
            return value * 43200000L;
        }
        if (field == DateField.WEEK_OF_MONTH || field == DateField.WEEK_OF_YEAR) {
            return value * 604800000L;
        }
        if (field == DateField.YEAR) {
            int year = Integer.parseInt("" + value);
            int schaltjahre = (year - 1 - 1968) / 4 - (year - 1 - 1900) / 100 + (year - 1 - 1600) / 400;
            return (long)(year - schaltjahre) * 31536000000L + (long)schaltjahre * 31622400000L;
        }
        return 0L;
    }
}

