/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.SimpleIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public abstract class AbstractList<V>
extends AbstractArray<V>
implements Iterable<V> {
    public boolean addAll(Collection<? extends V> c) {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        for (V e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    public ListIterator<V> listIterator() {
        return new SimpleIterator(this);
    }

    public ListIterator<V> listIterator(int index) {
        return new SimpleIterator(this, index);
    }

    public ListIterator<V> iteratorReverse() {
        return new SimpleIterator(this, this.size());
    }

    @Override
    public AbstractList<V> withList(Collection<?> values) {
        super.withList(values);
        return this;
    }

    public void copyEntity(BaseItem target, int pos) {
        if (target != null) {
            target.add(this.get(pos));
        }
    }

    public BaseItem subSet(V fromElement, V toElement) {
        BaseItem newList = this.getNewList(false);
        int end = this.indexOf(toElement);
        for (int pos = this.indexOf(fromElement); pos < end; ++pos) {
            this.copyEntity(newList, pos);
        }
        return newList;
    }

    public V ceiling(V element, boolean sameElement) {
        int pos = this.indexOf(element);
        if (pos < this.size) {
            return this.get(pos + 1);
        }
        if (sameElement) {
            return element;
        }
        return null;
    }

    public void add(int index, V element) {
        int pos = this.hasKey(element);
        if (pos >= 0) {
            this.grow(this.size + 1);
            this.addKey(index, element, this.size + 1);
        }
    }

    public V set(int index, V element) {
        if (index < 0 || index > this.size) {
            return null;
        }
        this.setValue(index, element, 0);
        return element;
    }

    public V remove(int index) {
        if (index < 0 || index > this.size) {
            return null;
        }
        return (V)this.removeByIndex(index, 0, this.index);
    }

    public boolean addAll(int index, Collection<? extends V> values) {
        if (values == null) {
            return false;
        }
        boolean allAdded = true;
        int newSize = this.size + values.size();
        this.grow(newSize);
        Iterator<V> i = values.iterator();
        while (i.hasNext()) {
            if (this.addKey(index++, i.next(), newSize) >= 0) continue;
            allAdded = false;
        }
        return allAdded;
    }

    protected <ST extends AbstractList<V>> ST filterItems(ST filterCollection, Condition<?> newValue) {
        for (int i = 0; i < this.size(); ++i) {
            Condition<?> filter = newValue;
            Object item = this.get(i);
            if (!filter.update(item)) continue;
            filterCollection.add(item);
        }
        return filterCollection;
    }

    @Override
    public Iterator<V> iterator() {
        return new SimpleIterator(this).withCheckPointer(true);
    }

    public Iterator<V> iterator(boolean checkPointer) {
        return new SimpleIterator(this).withCheckPointer(checkPointer);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)obj;
        if (collection.size() != this.size()) {
            return false;
        }
        for (V item : this) {
            if (collection.contains(item)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

