/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphDiff;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.SimpleSet;

public abstract class GraphMember {
    public static final String PROPERTY_NAME = "name";
    protected String name;
    protected Object children;
    protected Object parentNode;

    public String getValue(String attribute) {
        if (PROPERTY_NAME.equals(attribute)) {
            return this.name;
        }
        return null;
    }

    protected boolean check(GraphMember element, Condition<?> ... filters) {
        if (filters == null) {
            return element != null;
        }
        boolean result = true;
        for (Condition<?> item : filters) {
            Condition<?> filter = item;
            if (filter == null || !result) continue;
            result = filter.update(element);
        }
        return result;
    }

    public Clazz getClazz() {
        if (this instanceof Clazz) {
            return (Clazz)this;
        }
        if (this.parentNode instanceof Clazz) {
            return (Clazz)this.parentNode;
        }
        if (this.parentNode instanceof GraphMember) {
            return ((GraphMember)this.parentNode).getClazz();
        }
        return null;
    }

    protected String getFullId() {
        return this.name;
    }

    protected GraphSimpleSet getChildren() {
        if (this.children instanceof GraphSimpleSet) {
            return (GraphSimpleSet)this.children;
        }
        GraphSimpleSet collection = new GraphSimpleSet();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof GraphMember) {
            collection.with(this.children);
        }
        return collection;
    }

    public int size() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof GraphSimpleSet) {
            return ((GraphSimpleSet)this.children).size();
        }
        return 1;
    }

    protected SimpleSet<GraphEntity> getNodes() {
        SimpleSet<GraphEntity> collection = new SimpleSet<GraphEntity>();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof GraphEntity) {
            collection.add((GraphEntity)this.children);
            return collection;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                if (!(item instanceof GraphEntity)) continue;
                collection.add((GraphEntity)item);
            }
        }
        return collection;
    }

    public GraphMember with(String name) {
        this.setName(name);
        return this;
    }

    protected boolean setName(String value) {
        if (value != null && !value.equals(this.name) || value == null && this.name != null) {
            this.name = value;
            return true;
        }
        return false;
    }

    protected boolean setParentNode(GraphMember value) {
        if (this.parentNode != value) {
            GraphMember oldValue = (GraphMember)this.parentNode;
            if (this.parentNode != null) {
                this.parentNode = null;
                oldValue.without(this);
            }
            this.parentNode = value;
            if (value != null) {
                value.withChildren(this);
            }
            return true;
        }
        return false;
    }

    protected Object getParent() {
        return this.parentNode;
    }

    protected GraphMember withChildren(GraphMember ... values) {
        GraphSimpleSet list;
        if (values == null || values.length == 1 && this.children == values[0]) {
            return this;
        }
        if (this.children == null && values.length == 1) {
            this.children = values[0];
            values[0].setParentNode(this);
            return this;
        }
        if (this.children instanceof GraphSimpleSet) {
            list = (GraphSimpleSet)this.children;
        } else {
            list = new GraphSimpleSet();
            list.with((GraphMember)this.children);
            this.children = list;
        }
        for (GraphMember value : values) {
            if (value == null || !list.add(value)) continue;
            value.setParentNode(this);
        }
        return this;
    }

    protected GraphMember without(GraphMember ... values) {
        if (values == null || this.children == null) {
            return this;
        }
        if (this.children instanceof GraphMember) {
            for (GraphMember value : values) {
                if (this.children != value) continue;
                this.children = null;
                value.setParentNode(null);
            }
            return this;
        }
        GraphSimpleSet collection = (GraphSimpleSet)this.children;
        for (GraphMember value : values) {
            if (value == null) continue;
            collection.remove(value);
            value.setParentNode(null);
        }
        return this;
    }

    protected GraphDiff getDiff() {
        if (this.children == null) {
            GraphDiff graphDiff = new GraphDiff();
            this.withChildren(graphDiff);
            return graphDiff;
        }
        for (GraphMember item : this.getChildren()) {
            if (!(item instanceof GraphDiff)) continue;
            return (GraphDiff)item;
        }
        GraphDiff graphDiff = new GraphDiff();
        this.withChildren(graphDiff);
        return graphDiff;
    }

    public String getName() {
        return this.name;
    }

    protected GraphMember withAnnotaion(Annotation value) {
        if (this.children != null) {
            if (this.children instanceof GraphMember && this.children instanceof Annotation) {
                ((Annotation)this.children).setParentNode(null);
                this.children = null;
            }
            if (this.children instanceof GraphSimpleSet) {
                GraphSimpleSet collection = (GraphSimpleSet)this.children;
                for (int i = collection.size(); i >= 0; --i) {
                    GraphMember oldValue;
                    if (!(collection.get(i) instanceof Annotation) || (oldValue = (GraphMember)collection.remove(i)) == null) continue;
                    oldValue.setParentNode(null);
                }
            }
        }
        this.withChildren(value);
        return this;
    }

    protected Annotation getAnnotation() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof Annotation) {
            return (Annotation)this.children;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet collection = (GraphSimpleSet)this.children;
            for (GraphMember item : collection) {
                if (!(item instanceof Annotation)) continue;
                return (Annotation)item;
            }
        }
        return null;
    }

    public Modifier getModifier() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof Modifier) {
            return (Modifier)this.children;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet collection = (GraphSimpleSet)this.children;
            for (GraphMember item : collection) {
                if (!(item instanceof Modifier)) continue;
                return (Modifier)item;
            }
        }
        return null;
    }

    protected GraphMember withModifier(Modifier ... values) {
        if (values == null) {
            return this;
        }
        Modifier rootModifier = this.getModifier();
        if (rootModifier == null && this instanceof Modifier) {
            rootModifier = (Modifier)this;
        }
        for (Modifier item : values) {
            if (item.has(Modifier.PUBLIC) || item.has(Modifier.PACKAGE) || item.has(Modifier.PROTECTED) || item.has(Modifier.PRIVATE)) {
                rootModifier.with(item.getName());
                continue;
            }
            rootModifier.withChildren(new Modifier(item.getName()));
        }
        return this;
    }
}

