/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.Deep;
import de.uniks.networkparser.Filter;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.NetworkParserLog;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.SimpleGrammar;
import de.uniks.networkparser.SimpleObject;
import de.uniks.networkparser.TextItems;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.bytes.ByteEntity;
import de.uniks.networkparser.bytes.ByteTokener;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphPatternMatch;
import de.uniks.networkparser.graph.GraphTokener;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.DateCreator;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.MapListener;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntity;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.json.UpdateJson;
import de.uniks.networkparser.json.util.JsonArrayCreator;
import de.uniks.networkparser.json.util.JsonObjectCreator;
import de.uniks.networkparser.list.EntityComparator;
import de.uniks.networkparser.list.ObjectMapEntry;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.EMFTokener;
import de.uniks.networkparser.xml.MapEntityStack;
import de.uniks.networkparser.xml.XMLEntity;
import de.uniks.networkparser.xml.XMLEntityCreator;
import de.uniks.networkparser.xml.XMLTokener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IdMap
implements BaseItem,
Iterable<SendableEntityCreator> {
    public static final String VALUE = "value";
    public static final String ID = "id";
    public static final char SPACE = ' ';
    public static final char EQUALS = '=';
    public static final String MAINITEM = "main";
    public static final char DOUBLEQUOTIONMARK = '\"';
    public static final byte FLAG_NONE = 0;
    public static final byte FLAG_ID = 1;
    public static final byte FLAG_TYPESAVE = 2;
    public static final byte FLAG_SEARCHFORSUPERCLASS = 4;
    public static final byte FLAG_SIMPLEFORMAT = 8;
    private byte flag = 1;
    public static final String SESSION = "session";
    public static final String TIMESTAMP = "timestamp";
    protected String session = null;
    protected long timeStamp;
    private Grammar grammar = new SimpleGrammar();
    protected SimpleKeyValueList<String, Object> keyValue = (SimpleKeyValueList)new SimpleKeyValueList().withFlag((byte)64);
    protected Filter filter = new Filter();
    private JsonTokener jsonTokener = new JsonTokener().withMap(this);
    private XMLTokener xmlTokener = new XMLTokener().withMap(this);
    private ByteTokener byteTokener = new ByteTokener().withMap(this);
    protected NetworkParserLog logger = new NetworkParserLog();
    protected ObjectCondition updateListener;
    protected MapListener mapListener = new UpdateJson(this);
    protected SimpleKeyValueList<SendableEntityCreator, Object> referenceList = new SimpleKeyValueList();
    public static final char ENTITYSPLITTER = '.';
    protected SimpleKeyValueList<String, SendableEntityCreator> creators = (SimpleKeyValueList)new SimpleKeyValueList().withAllowDuplicate(false);

    public IdMap() {
        this.add(new TextItems());
        this.add(new DateCreator());
        this.add(new JsonObjectCreator());
        this.add(new JsonArrayCreator());
        this.add(new ObjectMapEntry());
        this.add(new XMLEntityCreator());
    }

    public SendableEntityCreator getCreatorClass(Object reference) {
        if (reference == null) {
            return null;
        }
        SendableEntityCreator creator = this.getCreator(reference.getClass().getName(), true);
        if (creator == null && reference instanceof SendableEntityCreator) {
            return (SendableEntityCreator)reference;
        }
        return creator;
    }

    public SendableEntityCreator getCreator(String clazz, boolean fullName) {
        Object creator = this.creators.getValue(clazz);
        if (creator != null || fullName) {
            return (SendableEntityCreator)creator;
        }
        String endTag = clazz.lastIndexOf(46) >= 0 ? '.' + clazz.substring(clazz.lastIndexOf(46) + 1) : '.' + clazz;
        for (int i = 0; i < this.creators.size(); ++i) {
            String key = this.creators.getKeyByIndex(i);
            SendableEntityCreator value = this.creators.getValueByIndex(i);
            if (!key.endsWith(endTag)) continue;
            return value;
        }
        return null;
    }

    public IdMap withCreator(Iterable<SendableEntityCreator> iterator) {
        if (iterator == null) {
            return null;
        }
        Iterator<SendableEntityCreator> i = iterator.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
        return this;
    }

    public IdMap withCreator(SendableEntityCreator ... createrClass) {
        if (createrClass == null) {
            return this;
        }
        for (SendableEntityCreator creator : createrClass) {
            if (creator == null) continue;
            try {
                Object reference = creator.getSendableInstance(true);
                if (reference == null) continue;
                if (reference instanceof Class) {
                    this.flag = (byte)4;
                    this.with(((Class)reference).getName(), creator);
                    continue;
                }
                this.with(reference.getClass().getName(), creator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public IdMap with(String className, SendableEntityCreator creator) {
        if (creator instanceof SendableEntityCreatorTag) {
            SendableEntityCreatorTag creatorTag = (SendableEntityCreatorTag)creator;
            this.creators.add(creatorTag.getTag(), creator);
        }
        this.creators.add(className, creator);
        return this;
    }

    public boolean removeCreator(String className) {
        return this.creators.remove(className) != null;
    }

    public String getKey(Object obj) {
        String result = null;
        try {
            int pos = this.keyValue.indexOfValue(obj);
            if (pos >= 0) {
                return this.keyValue.getKeyByIndex(pos);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return result;
    }

    public Object getObject(String key) {
        Object result = null;
        try {
            result = this.keyValue.getValue(key);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return result;
    }

    public String getId(Object obj) {
        return this.getId(obj, true);
    }

    public String getId(Object obj, boolean notificaton) {
        if (obj == null) {
            return "";
        }
        String key = this.getKey(obj);
        if (key != null) {
            return key;
        }
        key = this.grammar.getId(obj, this);
        if (key != null) {
            this.put(key, obj, notificaton);
            return key;
        }
        return this.createId(obj, notificaton);
    }

    public String createId(Object obj, boolean notification) {
        String key;
        if (this.timeStamp != 0L) {
            key = "" + obj.getClass().getSimpleName().charAt(0) + this.timeStamp++;
        } else {
            long timeStamp = System.nanoTime();
            key = "" + obj.getClass().getSimpleName().charAt(0) + timeStamp;
        }
        this.put(key, obj, notification);
        return key;
    }

    public Object put(String id, Object item) {
        return this.put(id, item, true);
    }

    protected Object put(String id, Object item, boolean notification) {
        boolean changed = this.keyValue.add(id, item);
        if (changed) {
            this.addListener(item);
        }
        if (this.updateListener != null) {
            if (item instanceof SendableEntityCreator) {
                ((SendableEntityCreator)item).setValue(item, ID, id, "new");
            }
            JsonObject json = this.toJsonObject(item, Filter.regard(Deep.create(1)));
            SimpleEvent simpleEvent = new SimpleEvent("new", json, this, "new", null, item);
            this.updateListener.update(simpleEvent);
        }
        return changed;
    }

    protected boolean addListener(Object object) {
        boolean add = false;
        if (object instanceof SendableEntity) {
            add = ((SendableEntity)object).addPropertyChangeListener(this.mapListener);
        } else {
            SendableEntityCreator creator = this.getCreatorClass(object);
            if (creator != null && creator instanceof SendableEntity) {
                add = ((SendableEntity)((Object)creator)).addPropertyChangeListener(this.mapListener);
            }
        }
        return add;
    }

    public boolean removeObj(Object oldValue, boolean destroy) {
        SendableEntityCreator creator;
        String key = this.getKey(oldValue);
        if (destroy && (creator = this.getCreatorClass(oldValue)) != null) {
            String[] props;
            for (String prop : props = creator.getProperties()) {
                Object reference = creator.getValue(oldValue, prop);
                if (reference instanceof Collection) {
                    Collection continee = (Collection)reference;
                    Iterator i = continee.iterator();
                    while (i.hasNext()) {
                        creator.setValue(oldValue, prop, i.next(), "rem");
                    }
                    continue;
                }
                creator.setValue(oldValue, prop, reference, "rem");
            }
        }
        if (key != null) {
            this.keyValue.without(key);
            if (this.updateListener != null) {
                JsonObject remJson = new JsonObject();
                JsonObject json = new JsonObject();
                json.put(ID, key);
                json.put("class", oldValue.getClass().getName());
                json.put("rem", remJson);
                SimpleEvent simpleEvent = new SimpleEvent("rem", json, this, "REMOVE_YOU", oldValue, null);
                this.updateListener.update(simpleEvent);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keyValue.size();
    }

    public Object cloneObject(Object reference, Filter filter) {
        MapEntity map = new MapEntity(filter, this.flag, this);
        return this.cloning(reference, map);
    }

    private Object cloning(Object reference, MapEntity map) {
        SendableEntityCreator creatorClass = this.getCreatorClass(reference);
        if (map.contains(reference)) {
            return null;
        }
        map.with(reference);
        Object newObject = null;
        if (creatorClass != null) {
            String[] properties;
            newObject = creatorClass.getSendableInstance(false);
            for (String property : properties = creatorClass.getProperties()) {
                Object value = creatorClass.getValue(reference, property);
                if (value instanceof Collection) {
                    if (!map.isFullSeriation() && !map.isPropertyRegard(reference, this, property, value)) continue;
                    Collection list = (Collection)value;
                    map.add();
                    for (Object item : list) {
                        Object refValue = map.getRefByEntity(item);
                        if (refValue != null) {
                            creatorClass.setValue(newObject, property, refValue, "new");
                            continue;
                        }
                        SendableEntityCreator childCreatorClass = this.getCreatorClass(item);
                        if (childCreatorClass != null) {
                            if (!map.isConvertable(reference, this, property, item)) {
                                creatorClass.setValue(newObject, property, item, "new");
                                continue;
                            }
                            Object clonedChild = this.cloning(item, map);
                            if (clonedChild == null) continue;
                            creatorClass.setValue(newObject, property, clonedChild, "new");
                            continue;
                        }
                        creatorClass.setValue(newObject, property, item, "new");
                    }
                    map.minus();
                    continue;
                }
                if (!map.isPropertyRegard(reference, this, property, value)) continue;
                Object refValue = map.getRefByEntity(value);
                if (refValue != null) {
                    creatorClass.setValue(newObject, property, refValue, "new");
                    continue;
                }
                SendableEntityCreator childCreatorClass = this.getCreatorClass(value);
                if (childCreatorClass != null) {
                    Object clonedChild;
                    map.add();
                    if (!map.isConvertable(reference, this, property, value)) {
                        creatorClass.setValue(newObject, property, value, "new");
                    } else if (map.isPropertyRegard(reference, this, property, value) && (clonedChild = this.cloning(value, map)) != null) {
                        creatorClass.setValue(newObject, property, clonedChild, "new");
                    }
                    map.minus();
                    continue;
                }
                creatorClass.setValue(newObject, property, value, "new");
            }
        }
        return newObject;
    }

    public SimpleList<Object> getTypList(SendableEntityCreator creator) {
        if (creator == null) {
            return null;
        }
        SimpleList<Object> result = new SimpleList<Object>();
        String clazzName = creator.getSendableInstance(true).getClass().getName();
        for (Object item : this.keyValue.valuesArrayIntern()) {
            if (item == null || !item.getClass().getName().equals(clazzName)) continue;
            result.add(item);
        }
        return result;
    }

    public boolean replaceObject(Object newObject) {
        String key = this.getKey(newObject);
        if (key != null) {
            return false;
        }
        if (!(newObject instanceof Comparable)) {
            return false;
        }
        SendableEntityCreator creator = this.getCreatorClass(newObject);
        if (creator == null) {
            return false;
        }
        boolean result = false;
        SimpleList<Object> oldValues = this.getTypList(creator);
        for (Object v : oldValues) {
            String oldKey;
            Comparable oldValue;
            if (!(v instanceof Comparable) || (oldValue = (Comparable)v).compareTo(newObject) != 0 || (oldKey = this.getKey(oldValue)) == null) continue;
            this.keyValue.remove(oldValue);
            this.put(oldKey, newObject, true);
        }
        return result;
    }

    public void clear() {
        this.keyValue.clear();
    }

    public IdMap withFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public boolean isCaseSensitive() {
        return this.keyValue.isCaseSensitive();
    }

    public IdMap withCaseSensitive(boolean value) {
        this.keyValue.withCaseSensitive(value);
        return this;
    }

    @Override
    public Iterator<SendableEntityCreator> iterator() {
        return this.creators.values().iterator();
    }

    public boolean notify(PropertyChangeEvent event) {
        if (this.mapListener != null) {
            this.mapListener.propertyChange(event);
            if (this.mapListener != null && this.mapListener instanceof ObjectCondition) {
                return ((ObjectCondition)((Object)this.mapListener)).update(event);
            }
        }
        if (this.updateListener != null) {
            this.updateListener.update(event);
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + this.size() + ")";
    }

    public IdMap withListener(ObjectCondition updateListener) {
        this.updateListener = updateListener;
        return this;
    }

    public JsonObject garbageCollection(Object root) {
        JsonObject initField = this.toJsonObject(root);
        ArrayList<String> classCounts = new ArrayList<String>();
        SimpleKeyValueList<String, Object> gc = new SimpleKeyValueList<String, Object>();
        this.countMessage(initField, classCounts, gc);
        for (String id : classCounts) {
            if (!this.hasKey(id)) continue;
            this.removeObj(this.getObject(id), false);
        }
        return initField;
    }

    private void countMessage(Object message, ArrayList<String> classCounts, SimpleKeyValueList<String, Object> gc) {
        block8: {
            Entity entity;
            block7: {
                if (!(message instanceof List)) break block7;
                for (Object obj : (List)message) {
                    if (!(obj instanceof JsonObject)) continue;
                    this.countMessage((JsonObject)obj, classCounts, gc);
                }
                break block8;
            }
            if (!(message instanceof Entity) || !(entity = (Entity)message).has(ID)) break block8;
            String id = entity.getString(ID);
            if (gc.containsKey(id)) {
                gc.put(id, (Integer)gc.getValue(id) + 1);
            } else {
                gc.put(id, 1);
            }
            if (entity.has("class")) {
                if (classCounts.contains(id)) {
                    return;
                }
                classCounts.add(id);
                JsonObject props = (JsonObject)entity.getValue("prop");
                for (int i = 0; i < props.size(); ++i) {
                    if (props.getValueByIndex(i) instanceof JsonObject) {
                        this.countMessage((JsonObject)props.getValueByIndex(i), classCounts, gc);
                        continue;
                    }
                    if (!(props.getValueByIndex(i) instanceof JsonArray)) continue;
                    this.countMessage((JsonArray)props.getValueByIndex(i), classCounts, gc);
                }
            }
        }
    }

    public IdMap withGrammar(Grammar value) {
        this.grammar = value;
        return this;
    }

    public IdMap withListener(MapListener listener) {
        this.mapListener = listener;
        return this;
    }

    public IdMap withSession(String value) {
        this.session = value;
        return this;
    }

    public boolean hasKey(Object element) {
        return this.keyValue.contains(element);
    }

    public Object decode(Buffer value) {
        char firstChar = value.nextClean(true);
        if (firstChar == '[') {
            return this.decode(this.jsonTokener.newInstanceList().withValue(value));
        }
        if (firstChar == '{') {
            return this.decode(this.jsonTokener.newInstance().withValue(value));
        }
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        if (firstChar == '<') {
            XMLTokener tokener = new XMLTokener().withMap(this);
            tokener.withBuffer(value);
            tokener.skipHeader();
            return this.decodingXMLEntity(tokener, map);
        }
        return this.byteTokener.decodeValue((byte)firstChar, value, map);
    }

    public Object decode(Tokener tokener) {
        char firstChar = tokener.nextClean(true);
        if (firstChar == '[') {
            return this.decode(new JsonArray().withValue(tokener));
        }
        if (firstChar == '<') {
            MapEntity map = new MapEntity(this.filter, this.flag, this);
            if (tokener instanceof XMLTokener) {
                XMLTokener xmlTokener = (XMLTokener)tokener;
                xmlTokener.skipHeader();
                return this.decodingXMLEntity(xmlTokener, map);
            }
            if (tokener instanceof EMFTokener) {
                EMFTokener xmlTokener = (EMFTokener)tokener;
                xmlTokener.withMap(this);
                return xmlTokener.decode(map, null);
            }
            return null;
        }
        Entity item = tokener.newInstance();
        if (item == null) {
            return null;
        }
        tokener.parseToEntity(item);
        return this.decode(item);
    }

    public Object decode(String value) {
        if (value == null) {
            return null;
        }
        return this.decode(new CharacterBuffer().with(value.intern()));
    }

    public Object decodeEMF(String value) {
        return this.decodeEMF(value, null);
    }

    public Object decodeEMF(String value, Object root) {
        if (value == null) {
            return null;
        }
        EMFTokener tokener = new EMFTokener();
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        tokener.withMap(this);
        tokener.withBuffer(value);
        return tokener.decode(map, root);
    }

    public Object decode(String value, ByteConverter converter) {
        if (converter == null) {
            return null;
        }
        byte[] decodeBytes = converter.decode(value);
        if (decodeBytes == null) {
            return null;
        }
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        ByteBuffer buffer = new ByteBuffer().with(decodeBytes);
        return this.byteTokener.decodeValue((byte)buffer.getCurrentChar(), buffer, map);
    }

    public Object decode(BaseItem value) {
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        return this.decoding(value, map);
    }

    public Object decode(BaseItem value, Object target, Filter filter) {
        if (filter == null) {
            filter = this.filter;
        }
        MapEntity map = new MapEntity(filter, this.flag, this);
        map.withTarget(target);
        return this.decoding(value, map);
    }

    private Object decoding(BaseItem value, MapEntity map) {
        if (value instanceof JsonArray) {
            return this.decodingJsonArray((JsonArray)value, map);
        }
        if (value instanceof XMLEntity) {
            return this.decodingXMLEntity(new XMLTokener().withMap(this).withBuffer(value.toString()), map);
        }
        if (value instanceof ByteEntity) {
            ByteEntity entity = (ByteEntity)value;
            return this.byteTokener.decodeValue(entity, map);
        }
        return this.decodingJsonObject((JsonObject)value, map);
    }

    private Object decodingXMLEntity(XMLTokener tokener, MapEntity map) {
        if (tokener.skipTo('<', false)) {
            map.withStack(new MapEntityStack());
            tokener.parseEntity(tokener, map);
            return tokener.parse(tokener, map);
        }
        return null;
    }

    private Object decodingJsonArray(JsonArray jsonArray, MapEntity map) {
        Object result = null;
        int len = jsonArray.size() - 1;
        for (int i = 0; i <= len; ++i) {
            JsonObject kidObject = jsonArray.getJSONObject(i);
            Object tmp = this.decodingJsonObject(kidObject, map);
            if (kidObject.has(MAINITEM)) {
                result = tmp;
                continue;
            }
            if (i != 0) continue;
            result = tmp;
        }
        return result;
    }

    private Object decodingJsonObject(JsonObject jsonObject, MapEntity map) {
        UpdateJson listener;
        Object result;
        if (this.mapListener instanceof UpdateJson && (result = (listener = (UpdateJson)this.mapListener).execute(jsonObject, this.filter)) != null) {
            return result;
        }
        return this.jsonTokener.decoding(jsonObject, map);
    }

    public JsonArray getJsonByIds(List<String> ids) {
        if (ids == null) {
            return null;
        }
        JsonArray items = new JsonArray();
        for (String childId : ids) {
            JsonObject jsonObject = this.toJsonObject(this.getObject(childId), Filter.convertable(Deep.create(0)));
            if (jsonObject == null) continue;
            items.add(jsonObject);
        }
        return items;
    }

    public XMLEntity toXMLEntity(Object entity) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        return (XMLEntity)this.encode(entity, map, this.xmlTokener);
    }

    public XMLEntity toXMLEntity(Object entity, Filter filter) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(filter, this.flag, this);
        return (XMLEntity)this.encode(entity, map, this.xmlTokener);
    }

    public XMLEntity toSimpleXML(Object entity) {
        if (entity == null) {
            return null;
        }
        byte flag = (byte)((this.flag | 1) - 1 | 8);
        MapEntity map = new MapEntity(this.filter, flag, this);
        map.withStack(new MapEntityStack());
        return (XMLEntity)this.encode(entity, map, this.xmlTokener);
    }

    public JsonObject toJsonObject(Object entity) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        return (JsonObject)this.encode(entity, map, this.jsonTokener);
    }

    public JsonObject toJsonObject(Object entity, Filter filter) {
        if (entity == null) {
            return null;
        }
        MapEntity map = new MapEntity(filter, this.flag, this);
        return (JsonObject)this.encode(entity, map, this.jsonTokener);
    }

    public JsonArray toJsonArray(Object object) {
        return this.toJsonArray(object, null);
    }

    public JsonArray toJsonArray(Object object, Filter filter) {
        if (filter == null) {
            filter = this.filter;
        }
        MapEntity map = new MapEntity(filter, this.flag, this);
        map.withTarget(this.jsonTokener.newInstanceList());
        return (JsonArray)this.encodeList(object, map, this.jsonTokener);
    }

    public JsonArray toJsonArray(Object object, JsonArray target, Filter filter) {
        if (filter == null) {
            filter = this.filter;
        }
        MapEntity map = new MapEntity(filter, this.flag, this);
        if (target.isComparator() && target.comparator() instanceof EntityComparator) {
            ((EntityComparator)target.comparator()).withMap(this);
        }
        map.withTarget(target);
        return (JsonArray)this.encodeList(object, map, this.jsonTokener);
    }

    public ByteItem toByteItem(Object object) {
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        return this.byteTokener.encode(object, map);
    }

    public ByteItem toByteItem(Object object, Filter filter) {
        MapEntity map = new MapEntity(filter, this.flag, this);
        return this.byteTokener.encode(object, map);
    }

    public GraphList toObjectDiagram(Object object) {
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        return new GraphTokener().withMap(this).encode(object, map);
    }

    public GraphList toClassDiagram(Object object) {
        MapEntity map = new MapEntity(this.filter, this.flag, this);
        map.withTokenerFlag((byte)1);
        return new GraphTokener().withMap(this).encode(object, map);
    }

    public GraphPatternMatch getDiff(Object source, Object target, boolean ordered) {
        byte flag = 0;
        if (ordered) {
            flag = 8;
        }
        MapEntity map = new MapEntity(this.filter, flag, this);
        map.withFlag(flag);
        return new GraphTokener().withMap(this).diffModel(source, target, map);
    }

    private EntityList encodeList(Object object, MapEntity map, Tokener tokener) {
        EntityList target = (EntityList)map.getTarget();
        SimpleList<String> ignoreIds = new SimpleList<String>();
        if (object instanceof Collection) {
            Collection list = (Collection)object;
            for (Object item : list) {
                Entity ignore = this.encode(item, map, tokener);
                if (ignore == null) continue;
                ignoreIds.add(ignore.getString(ID));
            }
        } else {
            if (object.getClass().isArray()) {
                for (Object item : (Object[])object) {
                    Entity ignore;
                    if (tokener.getKey(item) != null || (ignore = this.encode(item, map, tokener)) == null) continue;
                    ignoreIds.add(ignore.getString(ID));
                }
                return target;
            }
            Entity ignore = this.encode(object, map, tokener);
            if (ignore != null) {
                ignoreIds.add(ignore.getString(ID));
            }
        }
        if (!target.isComparator()) {
            SimpleIterator queueIterator = new SimpleIterator(target);
            while (queueIterator.hasNext()) {
                Object item;
                Entity json = (Entity)queueIterator.next();
                String id = json.getString(ID);
                if (ignoreIds.contains(id) || (item = this.getObject(id)) == null) continue;
                String className = item.getClass().getName();
                this.encode(item, className, map, tokener, null);
            }
        }
        return target;
    }

    public BaseItem encode(Object model, Tokener tokener) {
        return this.encode(model, tokener, this.filter);
    }

    public IdMap withFlag(byte flag) {
        this.flag = flag;
        return this;
    }

    public BaseItem encode(Object model, Tokener tokener, Filter filter) {
        MapEntity map = new MapEntity(filter, this.flag, this);
        if (tokener == null) {
            tokener = this.jsonTokener;
        }
        tokener.withMap(this);
        BaseItem item = this.grammar.encode(model, map, tokener);
        if (item != null) {
            return item;
        }
        return this.encode(model, map, tokener);
    }

    Entity encode(Object entity, MapEntity map, Tokener tokener) {
        if (entity == null) {
            return null;
        }
        String className = entity.getClass().getName();
        return this.encode(entity, className, map, tokener, null);
    }

    public boolean isError(Object owner, String method, String type, Object entity, String className) {
        return this.logger.error(owner, method, type, entity, className);
    }

    private Entity encode(Object entity, String className, MapEntity map, Tokener tokener, BaseItem parentNode) {
        String[] properties;
        SendableEntityCreator creator = map.getCreator("write", entity, className);
        if (creator == null) {
            return null;
        }
        EntityList targetList = (EntityList)map.getTarget();
        String id = null;
        if (!(creator instanceof SendableEntityCreatorNoIndex)) {
            Object temp = creator.getValue(entity, ID);
            if (temp == null) {
                id = map.getId(entity, this, className);
            } else {
                id = "" + temp;
                if (this.getKey(entity) == null) {
                    boolean newMessage = !"upd".equals(map.getFilter().getStrategy());
                    this.put(id, entity, newMessage);
                }
            }
        }
        boolean isSimple = targetList != null && !targetList.isComparator();
        Entity item = null;
        if (isSimple) {
            if (parentNode != null) {
                ObjectCondition filter;
                item = map.writeBasicValue(creator, tokener.newInstance(), parentNode, className, id);
                if (map.getDeep() > 0 && (filter = map.getFilter().getPropertyRegard()) != null && filter instanceof Deep && map.getDeep() <= ((Deep)filter).getDepth()) {
                    return item;
                }
                for (int i = 0; i < targetList.size(); ++i) {
                    Entity childEntity;
                    BaseItem childItem = targetList.getChild(i);
                    if (!(childItem instanceof Entity) || !id.equals((childEntity = (Entity)childItem).getString(ID))) continue;
                    return item;
                }
                targetList.add(item);
                return item;
            }
            if (targetList instanceof JsonArray) {
                JsonArray list = (JsonArray)targetList;
                item = list.get(id);
            }
        }
        if (!isSimple || item == null) {
            String type;
            if (entity instanceof SimpleObject && (type = ((SimpleObject)entity).getClassName()) != null) {
                className = type;
            }
            if ((item = map.writeBasicValue(creator, tokener.newInstance(), parentNode, className, id)) == null) {
                return null;
            }
            if (isSimple) {
                targetList.add(item);
            }
        }
        if ((properties = map.getProperties(tokener, creator)) != null) {
            map.pushStack(className, entity, creator);
            item.setAllowEmptyValue(map.isFullSeriation());
            Object referenceObject = this.referenceList.get(creator);
            if (referenceObject == null) {
                referenceObject = map.getNewEntity(creator, className, true);
                this.referenceList.add(creator, referenceObject);
            }
            map.add();
            CharacterBuffer prop = map.getPrefixProperties(creator, tokener, entity, className);
            int pos = prop.length();
            for (String property : properties) {
                Object value = creator.getValue(entity, property);
                if (value != null) {
                    SendableEntityCreator childCreater;
                    Object child;
                    if (!map.isPropertyRegard(entity, tokener.getMap(), property, value)) continue;
                    boolean encoding = map.isFullSeriation();
                    if (referenceObject instanceof Class) {
                        encoding = true;
                    }
                    if (!encoding) {
                        Object refValue = creator.getValue(referenceObject, property);
                        boolean bl = encoding = !value.equals(refValue);
                    }
                    if (!encoding) continue;
                    prop.setNextString(property, pos);
                    Entity parent = map.convertProperty(prop, item);
                    if (parent.has(property) && this.isError(this, "Encode", "DUPPLICATE", entity, className)) {
                        throw new RuntimeException("Property duplicate:" + property + "(" + className + ")");
                    }
                    if (value instanceof Entity && parent instanceof XMLEntity) {
                        parent.add(value);
                        continue;
                    }
                    className = value.getClass().getName();
                    String fullProp = prop.toString();
                    SendableEntityCreator valueCreater = map.getCreator("write", value, className);
                    Object key = value;
                    if (map.isId(value, tokener.getMap(), className)) {
                        key = tokener.getKey(value);
                    }
                    boolean contains = false;
                    if (key != null) {
                        contains = map.contains(key);
                    }
                    if (valueCreater != null && targetList != null) {
                        if (map.isConvertable(entity, tokener.getMap(), property, value) && !contains) {
                            this.encode(value, className, map, tokener, item);
                        }
                        if ((child = tokener.createLink(item, fullProp, className, tokener.getId(value))) == null) continue;
                        childCreater = map.getCreator("write", child, child.getClass().getName());
                        this.parseValue(fullProp, child, null, childCreater, map, tokener, parent);
                        continue;
                    }
                    if (valueCreater != null && (contains || !map.isConvertable(entity, tokener.getMap(), property, value))) {
                        child = null;
                        if (map.isAddOwnerLink(value)) {
                            child = tokener.createLink(item, fullProp, className, tokener.getId(value));
                        }
                        if (child == null) continue;
                        childCreater = map.getCreator("write", child, child.getClass().getName());
                        this.parseValue(fullProp, child, null, childCreater, map, tokener, parent);
                        continue;
                    }
                    this.parseValue(fullProp, value, className, valueCreater, map, tokener, parent);
                    continue;
                }
                if (!map.isFullSeriation()) continue;
                if (property.startsWith(".")) {
                    --pos;
                }
                prop.setNextString(property, pos);
                Entity parent = map.convertProperty(prop, item);
                parent.put(prop.toString(), value);
            }
            map.minus();
            map.popStack();
        }
        if (targetList != null && targetList.isComparator()) {
            targetList.add(item);
        }
        return item;
    }

    private void parseValue(String property, Object value, String className, SendableEntityCreator valueCreater, MapEntity map, Tokener tokener, BaseItem parent) {
        Object writeValue = null;
        if (value instanceof Collection && valueCreater == null) {
            boolean isArray = map.getTarget() != null;
            EntityList subValues = tokener.newInstanceList();
            for (Object child : (Collection)value) {
                if (child == null) continue;
                String childClassName = child.getClass().getName();
                SendableEntityCreator childCreater = map.getCreator("write", child, childClassName);
                Object key = child;
                if (map.isId(child, tokener.getMap(), className)) {
                    key = tokener.getKey(child);
                }
                if (map.contains(key)) {
                    child = tokener.createLink((Entity)parent, property, childClassName, tokener.getKey(child));
                    childClassName = null;
                } else if (isArray) {
                    if (!map.isPropertyRegard(value, tokener.getMap(), property, child)) continue;
                    if (map.isConvertable(value, tokener.getMap(), property, child)) {
                        this.encode(child, childClassName, map, tokener, parent);
                    }
                    child = tokener.createLink((Entity)parent, property, childClassName, tokener.getId(child));
                    childClassName = null;
                } else if (childCreater != null && !map.isConvertable(value, tokener.getMap(), property, child)) {
                    child = tokener.createLink((Entity)parent, property, childClassName, tokener.getKey(child));
                    childClassName = null;
                }
                this.parseValue(property, child, childClassName, childCreater, map, tokener, subValues);
            }
            writeValue = subValues;
        } else if (value instanceof Map && valueCreater == null) {
            Map list = (Map)value;
            EntityList subValues = tokener.newInstanceList();
            String packageName = ObjectMapEntry.class.getName();
            for (Map.Entry mapEntry : list.entrySet()) {
                SendableEntityCreator childCreater = map.getCreator("write", mapEntry, packageName);
                this.parseValue(property, mapEntry, packageName, childCreater, map, tokener, subValues);
            }
            writeValue = subValues;
        } else {
            writeValue = valueCreater != null && className != null ? this.encode(value, className, map, tokener, parent) : value;
        }
        if (!map.writeValue(parent, property, writeValue, tokener)) {
            if (parent instanceof EntityList && tokener.isChild(writeValue)) {
                ((EntityList)parent).add(writeValue);
            } else if (parent instanceof Entity) {
                if (property.length() == 1 && property.charAt(0) == '.') {
                    CharacterBuffer buffer = new CharacterBuffer().with("" + tokener.transformValue(value, parent));
                    ((Entity)parent).withValue(buffer);
                } else if (map.isTypSave()) {
                    Entity child = tokener.newInstance();
                    if (child != null) {
                        child.put("class", className);
                        child.put(VALUE, tokener.transformValue(writeValue, parent));
                        ((Entity)parent).put(property, child);
                    }
                } else {
                    ((Entity)parent).put(property, tokener.transformValue(writeValue, parent));
                }
            }
        }
    }

    public MapListener getMapListener() {
        return this.mapListener;
    }

    public SimpleKeyValueList<String, Object> getKeyValue() {
        return this.keyValue;
    }

    public IdMap withKeyValue(SimpleKeyValueList<String, Object> parent) {
        if (parent != null) {
            this.keyValue = parent;
        }
        return this;
    }

    public SimpleKeyValueList<String, SendableEntityCreator> getCreators() {
        return this.creators;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new IdMap();
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        return converter.encode(this);
    }

    public IdMap with(Object ... values) {
        this.add(values);
        return this;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return false;
        }
        for (Object item : values) {
            if (item instanceof SendableEntityCreator) {
                this.withCreator((SendableEntityCreator)item);
                continue;
            }
            if (item instanceof ObjectCondition) {
                this.withListener((ObjectCondition)item);
                continue;
            }
            if (item instanceof MapListener) {
                this.withListener((MapListener)item);
                continue;
            }
            if (item instanceof Filter) {
                this.withFilter((Filter)item);
                continue;
            }
            if (item instanceof Grammar) {
                this.withGrammar((Grammar)item);
                continue;
            }
            if (!(item instanceof Iterable)) continue;
            for (Object value : (Iterable)item) {
                if (!(value instanceof SendableEntityCreator)) continue;
                this.withCreator((SendableEntityCreator)value);
            }
        }
        return true;
    }

    public IdMap withTimeStamp(long newValue) {
        this.timeStamp = newValue;
        return this;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public String getSession() {
        return this.session;
    }
}

