/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.StringFilter;
import de.uniks.networkparser.graph.Value;

public class Attribute
extends Value {
    public static final StringFilter<Attribute> NAME = new StringFilter("name");

    Attribute() {
    }

    public Attribute(String name, DataType datatyp) {
        this.with(name);
        this.with(datatyp);
    }

    @Override
    public Attribute with(Class<?> value) {
        super.with(value);
        return this;
    }

    @Override
    public Attribute withValue(String value) {
        super.withValue(value);
        return this;
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = super.getModifier();
        if (modifier == null) {
            modifier = new Modifier(Modifier.PRIVATE.getName());
            super.withChildren(modifier);
        }
        return modifier;
    }

    public Attribute with(Modifier ... modifier) {
        super.withModifier(modifier);
        return this;
    }

    public Attribute without(Modifier ... modifier) {
        this.getModifier().without(modifier);
        return this;
    }

    public Attribute without(Annotation ... annotation) {
        super.without(annotation);
        return this;
    }

    @Override
    public Attribute with(String value) {
        super.with(value);
        return this;
    }

    @Override
    public Attribute with(DataType value) {
        super.with(value);
        return this;
    }

    @Override
    public Attribute with(Clazz value) {
        super.with(value);
        return this;
    }

    public Attribute with(String name, DataType typ) {
        this.with(typ);
        this.with(name);
        return this;
    }

    public Attribute with(String name, Clazz typ) {
        this.with(typ);
        this.with(name);
        return this;
    }

    public String getValue(String typ, boolean shortName) {
        if (typ.equals("objectdiagram")) {
            if (DataType.STRING == this.type && !this.value.startsWith("\"")) {
                return "\"" + this.value + "\"";
            }
            return this.value;
        }
        return this.getType(shortName);
    }

    @Override
    public Annotation getAnnotation() {
        return super.getAnnotation();
    }

    public Attribute with(Annotation value) {
        super.withAnnotaion(value);
        return this;
    }

    public String toString() {
        CharacterBuffer sb = new CharacterBuffer();
        sb.with(this.getName());
        sb.with(':');
        sb.with(this.getType(true));
        if (this.getValue() != null) {
            sb.with('=');
            sb.with(this.getValue());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Attribute) {
            Attribute other = (Attribute)obj;
            String myName = this.getName();
            if (myName == null) {
                return other.getName() == null;
            }
            if (myName.equalsIgnoreCase(other.getName())) {
                return true;
            }
        } else if (obj instanceof Association) {
            Association assoc = (Association)obj;
            String myName = this.getName();
            if (myName != null && myName.equalsIgnoreCase(assoc.getOther().getName())) {
                return true;
            }
        }
        return super.equals(obj);
    }
}

