/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.story;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.story.Story;
import de.uniks.networkparser.ext.story.StoryStep;
import de.uniks.networkparser.list.EntityComparator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.HTMLEntity;
import de.uniks.networkparser.xml.XMLEntity;

public class StoryStepSourceCode
implements StoryStep {
    public static final String FORMAT_JAVA = "java";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_JSON = "json";
    public static final String TEMPLATESTART = "<i class=\"conum\" data-value=\"";
    public static final String TEMPLATEEND = "\"></i>";
    private String format = null;
    private String contentFile;
    private int startLine;
    private int endLine;
    private CharacterBuffer body;
    private String packageName;
    private String methodName;
    private SimpleKeyValueList<String, String> variables = new SimpleKeyValueList().withComparator(EntityComparator.createComparator());
    private String fullPath;

    private void startStory(String path) {
        this.packageName = path;
        try {
            throw new Exception("get File");
        }
        catch (Exception e) {
            this.getLineFromThrowable(e);
            return;
        }
    }

    private String getLineFromThrowable(Throwable e) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement ste : stackTrace = e.getStackTrace()) {
            String name = ste.getClassName();
            if (!name.startsWith(this.packageName)) continue;
            if (this.methodName == null) {
                this.contentFile = ste.getFileName();
                this.methodName = ste.getMethodName();
                this.startLine = ste.getLineNumber() + 1;
            } else {
                this.endLine = ste.getLineNumber() - 1;
            }
            return name + ".java:" + ste.getLineNumber();
        }
        return "";
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public void finish() {
        try {
            throw new Exception("get File");
        }
        catch (Exception e) {
            this.getLineFromThrowable(e);
            this.readFile();
            return;
        }
    }

    private CharacterBuffer analyseLine(CharacterBuffer line) {
        int pos = (line = line.trim()).indexOf("//");
        if (pos >= 0) {
            line.withPosition(pos + 1);
            char character = line.getChar();
            if (character == '<') {
                line.skip();
                pos = line.position();
                while (character != '>' && character != '\u0000') {
                    character = line.getChar();
                }
                String variable = line.substring(pos, line.position());
                this.variables.add(variable, null);
                line.replace(pos - 3, line.position() + 1, TEMPLATESTART + variable + TEMPLATEEND);
            }
        }
        return line;
    }

    public void readFile() {
        int linePos;
        this.fullPath = "src/test/java/" + this.packageName.replace('.', '/') + "/" + this.contentFile;
        FileBuffer fileBuffer = new FileBuffer();
        fileBuffer.withFile(this.fullPath);
        CharacterBuffer indexText = new CharacterBuffer();
        CharacterBuffer line = new CharacterBuffer();
        if (this.endLine == 0) {
            String search = this.methodName + "(";
            int start = this.startLine;
            for (linePos = 1; line != null && linePos <= start; ++linePos) {
                line = fileBuffer.readLine();
                if (line.indexOf(search) <= 0) continue;
                this.startLine = linePos;
                break;
            }
            this.endLine = start;
            line = this.analyseLine(line);
            while (line != null) {
                indexText.with(line);
                line = this.analyseLine(fileBuffer.readLine());
                if (++linePos >= this.endLine && line.trim().equals("}")) {
                    indexText.with("\r\n").with(line);
                    break;
                }
                indexText.with("\r\n");
            }
            this.body = indexText;
            fileBuffer.close();
            return;
        }
        while (line != null && linePos <= this.startLine) {
            line = fileBuffer.readLine();
            ++linePos;
        }
        line = this.analyseLine(line);
        if (this.format == null) {
            char firstChar = line.getCurrentChar();
            this.format = firstChar == '<' ? FORMAT_XML : (firstChar == '{' || firstChar == '[' ? FORMAT_JSON : FORMAT_JAVA);
        }
        while (line != null && linePos < this.endLine) {
            indexText.with(line);
            line = this.analyseLine(fileBuffer.readLine());
            if (++linePos >= this.endLine) continue;
            indexText.with("\r\n");
        }
        fileBuffer.close();
        this.body = indexText;
    }

    @Override
    public boolean dump(Story story, HTMLEntity element) {
        XMLEntity pre = element.createBodyTag("pre");
        XMLEntity code = element.createBodyTag("code", pre);
        if (this.endLine < 1 && this.startLine > 0) {
            this.readFile();
        }
        code.withValue(this.body);
        code.withKeyValue("class", this.format);
        code.withKeyValue("data-lang", this.format);
        XMLEntity undertitle = element.createBodyTag("div", pre);
        String name = this.methodName.startsWith("test") ? this.methodName.substring(4) : this.methodName;
        String value = this.fullPath != null ? "Code: <a href=\"../" + this.fullPath + "\">" + name + "</a>" : "Code: " + name;
        undertitle.with(value);
        undertitle.with("class", "title");
        XMLEntity table = element.createBodyTag("table");
        for (int i = 0; i < this.variables.size(); ++i) {
            String key = this.variables.getKeyByIndex(i);
            value = this.variables.getValueByIndex(i);
            if (value == null) {
                System.err.println("Key: " + key + " has no value");
                continue;
            }
            XMLEntity row = element.createBodyTag("tr", table);
            code = element.createBodyTag("td", row);
            code.withValueItem(TEMPLATESTART + key + TEMPLATEEND);
            char charAt = value.charAt(0);
            if (charAt == '{' || charAt == '[') {
                code = element.createBodyTag("td.pre.code", row);
                code.withKeyValue("class", FORMAT_JSON);
                code.withKeyValue("data-lang", FORMAT_JSON);
            } else if (charAt == '<') {
                code = element.createBodyTag("td.pre.code", row);
                code.withKeyValue("class", FORMAT_XML);
                code.withKeyValue("data-lang", FORMAT_XML);
            } else {
                code = element.createBodyTag("td", row);
            }
            code.withValue(value);
        }
        return true;
    }

    public StoryStepSourceCode withCode(String path) {
        this.startStory(path);
        return this;
    }

    public StoryStepSourceCode withCode(Class<?> packageName) {
        String fileName = packageName.getName();
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            fileName = fileName.substring(0, pos);
        }
        this.startStory(fileName);
        return this;
    }

    public boolean addDescription(String key, String value) {
        int pos = this.variables.indexOf(key);
        if (pos >= 0) {
            this.variables.setValue(pos, value);
            return true;
        }
        return false;
    }
}

