/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.sql;

import de.uniks.networkparser.ext.sql.SQLCommand;
import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleIteratorSet;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import java.util.Iterator;
import java.util.Map;

public class SQLStatement {
    public static final String ID = "_ID";
    public static final String VALUE = "VALUE";
    public static final String PROP = "PROP";
    protected SQLCommand command;
    protected String table;
    private boolean autoStatement;
    private boolean enable = true;
    private AbstractArray<?> values;
    private SimpleKeyValueList<String, Object> conditions;
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String QUOTE = "'";
    private static final String DRIVER = "DRIVER";
    private static final String DATABASE = "DATABASE";

    public SQLStatement(SQLCommand command) {
        this.command = command;
    }

    public SQLStatement(SQLCommand command, String table) {
        this.command = command;
        this.table = table;
    }

    public SQLStatement(SQLCommand command, String table, String id) {
        this.command = command;
        this.table = table;
        this.with(ID, id);
    }

    public SQLCommand getCommand() {
        return this.command;
    }

    public SQLStatement withCommand(SQLCommand command) {
        this.command = command;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public SQLStatement withTable(String value) {
        this.table = value;
        return this;
    }

    public boolean isAutoStatement() {
        return this.autoStatement;
    }

    public SQLStatement withAutoStatement(boolean autoStatement) {
        this.autoStatement = autoStatement;
        return this;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public SQLStatement withEnable(boolean enable) {
        this.enable = enable;
        return this;
    }

    public boolean autoDisable() {
        if (this.isAutoStatement()) {
            this.withEnable(false);
            return true;
        }
        return false;
    }

    public static SQLStatement connect(String driver, String database, String url) {
        SQLStatement connectStatement = new SQLStatement(SQLCommand.CONNECTION, url);
        connectStatement.with(DRIVER, driver);
        connectStatement.with(DATABASE, database);
        return connectStatement;
    }

    public SQLStatement with(String key, Object value) {
        if (this.values == null) {
            this.values = new SimpleKeyValueList();
        }
        if (this.values instanceof SimpleKeyValueList) {
            ((SimpleKeyValueList)this.values).withKeyValue(key, value);
        }
        return this;
    }

    public SQLStatement without(String key) {
        if (this.values != null && this.values instanceof SimpleKeyValueList) {
            ((SimpleKeyValueList)this.values).without(key);
        }
        return this;
    }

    public SQLStatement withValues(Object ... values) {
        if (values == null) {
            return this;
        }
        if (this.values == null) {
            this.values = new SimpleList();
        }
        if (!(this.values instanceof SimpleList)) {
            return this;
        }
        SimpleList list = (SimpleList)this.values;
        for (Object item : values) {
            list.with(item);
        }
        return this;
    }

    public SQLStatement withCondition(String key, Object value) {
        if (this.conditions == null) {
            this.conditions = new SimpleKeyValueList();
        }
        this.conditions.add(key, value);
        return this;
    }

    public String toString() {
        if (this.command == SQLCommand.CONNECTION) {
            String driver = EMPTY;
            String database = EMPTY;
            if (this.values instanceof SimpleKeyValueList) {
                SimpleKeyValueList items = (SimpleKeyValueList)this.values;
                driver = (String)items.getValue(DRIVER);
                database = (String)items.getValue(DATABASE);
            }
            return driver + ":" + database + ":" + this.table;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append(this.command.getValue()).append(SPACE);
        if (this.command == SQLCommand.SELECT) {
            if (this.values instanceof SimpleList) {
                SimpleIterator i = new SimpleIterator(this.values);
                String item = null;
                while (i.hasNext()) {
                    item = (String)i.next();
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append("\"" + item + "\"");
                }
                sb.append(" FROM ");
                sb.append(this.table);
            }
            this.addCondition(sb);
            return sb.toString();
        }
        sb.append(this.table).append(SPACE);
        if (this.command == SQLCommand.DROPTABLE) {
            return sb.toString();
        }
        if (this.command == SQLCommand.DELETE) {
            this.addCondition(sb);
            return sb.toString();
        }
        if (this.command == SQLCommand.CREATETABLE) {
            if (this.values instanceof SimpleKeyValueList) {
                sb.append("(");
                SimpleIteratorSet i = new SimpleIteratorSet(this.values);
                Object item = null;
                while (i.hasNext()) {
                    item = i.next();
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append(QUOTE + (String)item.getKey() + QUOTE).append(SPACE).append(item.getValue());
                }
                sb.append(")");
            }
            return sb.toString();
        }
        if (this.command == SQLCommand.INSERT) {
            if (this.values.size() > 0 && this.values instanceof SimpleKeyValueList) {
                SimpleIteratorSet i = new SimpleIteratorSet(this.values);
                Object item = i.next();
                StringBuilder values = new StringBuilder();
                values.append(QUOTE).append(item.getValue()).append(QUOTE);
                if (EMPTY.equals(item.getKey())) {
                    while (i.hasNext()) {
                        item = i.next();
                        values.append(", '").append(i.next().getValue()).append(QUOTE);
                    }
                } else {
                    StringBuilder keys = new StringBuilder();
                    keys.append((String)item.getKey());
                    while (i.hasNext()) {
                        item = i.next();
                        keys.append(", ").append((String)item.getKey());
                        values.append(", '");
                        this.convertValue(values, item.getValue());
                        values.append(QUOTE);
                    }
                    sb.append("(").append(keys.toString()).append(") ");
                }
                sb.append("values(").append(values.toString()).append(")");
            }
            return sb.toString();
        }
        if (this.command == SQLCommand.UPDATE && this.values instanceof SimpleKeyValueList) {
            sb.append("SET ");
            SimpleIteratorSet i = new SimpleIteratorSet(this.values);
            Object item = null;
            while (i.hasNext()) {
                item = i.next();
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append((String)item.getKey()).append("=").append(QUOTE);
                this.convertValue(sb, item.getValue());
                sb.append(QUOTE);
            }
            this.addCondition(sb);
        }
        return sb.toString();
    }

    private void convertValue(StringBuilder sb, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof SimpleSet) {
            SimpleSet collection = (SimpleSet)value;
            sb.append('{');
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
            return;
        }
        sb.append(value.toString());
    }

    private void addCondition(StringBuilder sb) {
        if (this.conditions != null) {
            boolean first = true;
            sb.append(" WHERE ");
            for (Map.Entry<String, Object> item : this.conditions.entrySet()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                if (item.getValue() instanceof SimpleList) {
                    SimpleList values = (SimpleList)item.getValue();
                    sb.append(item.getKey()).append(SPACE).append("IN").append(SPACE).append("(");
                    boolean newFirst = true;
                    for (Object object : values) {
                        if (!newFirst) {
                            sb.append(", ");
                        } else {
                            newFirst = false;
                        }
                        sb.append(QUOTE + object + QUOTE);
                    }
                    sb.append(")");
                    continue;
                }
                sb.append(item.getKey()).append("=").append(QUOTE + item.getValue() + QUOTE);
            }
        }
    }

    public AbstractArray<?> getValues() {
        return this.values;
    }

    public String getPrimaryId() {
        SimpleIteratorSet<String, Object> i = this.command == SQLCommand.SELECT ? new SimpleIteratorSet<String, Object>(this.conditions) : new SimpleIteratorSet(this.values);
        Object item = null;
        while (i.hasNext()) {
            item = i.next();
            if (!ID.equals(item.getKey())) continue;
            return (String)item.getValue();
        }
        if (this.command == SQLCommand.UPDATE) {
            i = new SimpleIteratorSet<String, Object>(this.conditions);
            while (i.hasNext()) {
                item = i.next();
                if (!ID.equals(item.getKey())) continue;
                return (String)item.getValue();
            }
        }
        return null;
    }

    public SQLStatement withoutCondition(String key) {
        if (this.conditions != null) {
            this.conditions.remove(key);
        }
        return this;
    }
}

