/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.ext.javafx.FXStageController;
import de.uniks.networkparser.ext.javafx.SimpleShell;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.gui.Editor;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;

public class DiagramEditor
extends SimpleShell
implements Editor {
    private static final String CRLF = "\r\n";
    private WebView browser;
    private WebEngine webEngine;
    private Editor logic;

    @Override
    protected Parent createContents(FXStageController controller, Application.Parameters args) {
        controller.withTitle("ClassdiagrammEditor");
        controller.withSize(900, 600);
        this.enableError("errors");
        String value = (String)args.getNamed().get("logic");
        if (value != null) {
            try {
                Class<?> clazz = Class.forName(value);
                Object editor = clazz.newInstance();
                if (editor instanceof Editor) {
                    this.logic = (Editor)editor;
                }
            }
            catch (RuntimeException clazz) {
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (InstantiationException clazz) {
            }
            catch (IllegalAccessException clazz) {
                // empty catch block
            }
        }
        if (this.logic != null) {
            controller.withIcon(this.getIcon());
        }
        this.browser = new WebView();
        this.webEngine = this.browser.getEngine();
        SimpleKeyValueList<String, String> map = this.getParameterMap();
        StringBuilder content = new StringBuilder("<html><head>\r\n");
        String body = "</head><body>\r\n<script language=\"Javascript\">classEditor = new ClassEditor(\"board\");</script></body></html>";
        if (map.containsKey("export")) {
            content.append("<script src=\"drawer.js\"></script>\r\n");
            content.append("<script src=\"graph.js\"></script>\r\n");
            content.append("<link href=\"diagramstyle.css\" rel=\"stylesheet\" type=\"text/css\">\r\n");
            content.append(body);
            this.copyFile("drawer.js");
            this.copyFile("graph.js");
            this.copyFile("diagramstyle.css");
            this.writeFile("Editor.html", content.toString());
            try {
                this.webEngine.load(new File("Editor.html").toURI().toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (map.containsKey("exportall")) {
            content.append((CharSequence)this.readFile("drawer.js"));
            content.append((CharSequence)this.readFile("graph.js"));
            content.append((CharSequence)this.readFile("diagramstyle.css"));
            content.append(body);
            this.writeFile("Editor.html", content.toString());
            try {
                this.webEngine.load(new File("Editor.html").toURI().toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            content.append((CharSequence)this.readFile("drawer.js"));
            content.append((CharSequence)this.readFile("graph.js"));
            content.append((CharSequence)this.readFile("diagramstyle.css"));
            content.append(body);
            this.webEngine.loadContent(content.toString());
        }
        this.webEngine.setOnError((EventHandler)new EventHandler<WebErrorEvent>(){

            public void handle(WebErrorEvent event) {
                System.err.println(event.getMessage());
            }
        });
        this.browser.setOnDragExited((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                DiagramEditor.this.webEngine.executeScript("classEditor.setBoardStyle(\"dragleave\");");
            }
        });
        this.browser.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    boolean error = true;
                    for (File file : db.getFiles()) {
                        String name = file.getName().toLowerCase();
                        if (name.indexOf("json", name.length() - 4) < 0) continue;
                        error = false;
                    }
                    if (!error) {
                        event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                        DiagramEditor.this.webEngine.executeScript("classEditor.setBoardStyle(\"Ok\");");
                    } else {
                        event.acceptTransferModes(TransferMode.NONE);
                        DiagramEditor.this.webEngine.executeScript("classEditor.setBoardStyle(\"Error\");");
                    }
                }
                event.consume();
            }
        });
        this.browser.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(DragEvent event) {
                block14: {
                    Iterator iterator;
                    Dragboard db = event.getDragboard();
                    if (!db.hasFiles() || !(iterator = db.getFiles().iterator()).hasNext()) break block14;
                    File file = (File)iterator.next();
                    StringBuilder sb = new StringBuilder();
                    byte[] buf = new byte[1024];
                    FileInputStream is = null;
                    try {
                        int read;
                        is = new FileInputStream(file);
                        do {
                            if ((read = is.read(buf, 0, buf.length)) <= 0) continue;
                            sb.append(new String(buf, 0, read, "UTF-8"));
                        } while (read >= 0);
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    DiagramEditor.this.webEngine.executeScript("classEditor.dropFile('" + sb.toString() + "', \"" + file.getAbsolutePath() + "\");");
                }
            }
        });
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                if (newValue == Worker.State.SUCCEEDED) {
                    System.out.println("called: " + DiagramEditor.this.webEngine.getLocation());
                    JSObject win = (JSObject)DiagramEditor.this.webEngine.executeScript("window");
                    win.setMember("java", new JavaApp(DiagramEditor.this));
                }
            }
        });
        return this.browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String file, String content) {
        File target = new File(file);
        if (!target.exists()) {
            try {
                target.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target);
            byte[] bytes = content.getBytes("UTF-8");
            out.write(bytes, 0, bytes.length);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder readFile(String file) {
        InputStream is = GraphList.class.getResourceAsStream(file);
        StringBuilder sb = new StringBuilder();
        if (file.endsWith(".js")) {
            sb.append("<script language=\"Javascript\">\r\n");
        } else if (file.endsWith(".css")) {
            sb.append("<style>\r\n");
        }
        if (is != null) {
            int BUFF_SIZE = 5120;
            byte[] buffer = new byte[5120];
            try {
                int count;
                while ((count = is.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, count, "UTF-8"));
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (file.endsWith(".js")) {
            sb.append("</script>\r\n");
        } else if (file.endsWith(".css")) {
            sb.append("</style>\r\n");
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String file) {
        File target = new File(file);
        InputStream is = GraphList.class.getResourceAsStream(file);
        FileOutputStream out = null;
        if (is != null) {
            int BUFF_SIZE = 5120;
            byte[] buffer = new byte[5120];
            try {
                int count;
                if (!target.exists() && !target.createNewFile()) {
                    return;
                }
                out = new FileOutputStream(target);
                while ((count = is.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void main(String[] args) {
        DiagramEditor.launch((String[])args);
    }

    @Override
    public boolean generate(JsonObject model) {
        if (this.logic != null) {
            return this.logic.generate(model);
        }
        return false;
    }

    public void save(JsonObject model) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String name = model.getString("package");
        if (name == null || name.length() < 1) {
            name = "model";
        }
        name = name + "_" + formatter.format(new Date().getTime()) + ".json";
        this.writeFile(name, model.toString());
    }

    @Override
    public void open(Object logic, String ... args) {
        SimpleList<String> values = new SimpleList<String>();
        if (logic != null) {
            values.add("--logic=" + logic.getClass().getName());
        }
        if (args != null) {
            for (String item : args) {
                values.with(item);
            }
        }
        DiagramEditor.launch((String[])values.toArray(new String[values.size()]));
    }

    @Override
    public String getIcon() {
        if (this.logic != null) {
            return this.logic.getIcon();
        }
        return null;
    }

    public static final class JavaApp {
        private DiagramEditor owner;

        public JavaApp(DiagramEditor owner) {
            this.owner = owner;
        }

        public void exit() {
            System.out.println("Exit");
            Platform.exit();
        }

        public void save(Object value) {
            this.owner.save(new JsonObject().withValue((String)value));
        }

        public String generate(String value) {
            try {
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        owner.saveException(e, new Object[0]);
                    }
                });
                this.owner.generate(new JsonObject().withValue(value));
            }
            catch (RuntimeException e) {
                this.owner.saveException(e, new Object[0]);
            }
            catch (Exception e) {
                this.owner.saveException(e, new Object[0]);
            }
            catch (Throwable e) {
                this.owner.saveException(e, new Object[0]);
            }
            return "";
        }
    }
}

