/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.TextItems;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.Feature;
import de.uniks.networkparser.graph.FeatureProperty;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.util.FeatureSet;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.And;
import de.uniks.networkparser.logic.FeatureCondition;
import de.uniks.networkparser.logic.ForeachCondition;
import de.uniks.networkparser.logic.IfCondition;
import de.uniks.networkparser.logic.ImportCondition;
import de.uniks.networkparser.logic.Not;
import de.uniks.networkparser.logic.TemplateFragmentCondition;
import de.uniks.networkparser.parser.Template;
import de.uniks.networkparser.parser.TemplateResultFile;
import de.uniks.networkparser.parser.TemplateResultFragment;
import de.uniks.networkparser.parser.TemplateResultModel;
import de.uniks.networkparser.parser.generator.BasicGenerator;
import de.uniks.networkparser.parser.generator.condition.JavaListCondition;
import de.uniks.networkparser.parser.generator.condition.JavaMethodBodyCondition;
import de.uniks.networkparser.parser.generator.java.JavaClazz;
import de.uniks.networkparser.parser.generator.java.JavaCreator;
import de.uniks.networkparser.parser.generator.java.JavaSet;

public class ModelGenerator
extends BasicGenerator {
    private FeatureSet features = Feature.getAll();
    private GraphModel defaultModel;
    public SimpleKeyValueList<String, ParserCondition> customTemplate;
    private SimpleList<BasicGenerator> javaGeneratorTemplates = (SimpleList)new SimpleList().with(new JavaClazz(), new JavaSet(), new JavaCreator());

    public SimpleKeyValueList<String, ParserCondition> getTemplates() {
        if (this.customTemplate == null) {
            this.customTemplate = new SimpleKeyValueList();
            this.addParserCondition(new FeatureCondition());
            this.addParserCondition(new ImportCondition());
            this.addParserCondition(new ForeachCondition());
            this.addParserCondition(new TemplateFragmentCondition());
            this.addParserCondition(new IfCondition());
            this.addParserCondition(new IfCondition().withKey("ifnot"));
            this.addParserCondition(new JavaMethodBodyCondition());
            this.addParserCondition(new JavaListCondition());
            this.addParserCondition(new And());
            this.addParserCondition(new Not());
        }
        return this.customTemplate;
    }

    protected void addParserCondition(ParserCondition condition) {
        String key = condition.getKey();
        if (key != null) {
            this.customTemplate.add(key.toLowerCase(), condition);
        }
    }

    public SendableEntityCreator generate(GraphMember item) {
        if (!(item instanceof GraphModel)) {
            return null;
        }
        return this.generate("src", (GraphModel)item);
    }

    public SendableEntityCreator generate(GraphMember item, TextItems parameters) {
        if (!(item instanceof GraphModel)) {
            return null;
        }
        return this.generateJava("src", (GraphModel)item, parameters);
    }

    public SendableEntityCreator generate(String rootDir, GraphModel model) {
        return this.generateJava(rootDir, model, null);
    }

    public SendableEntityCreator generateJava(String rootDir, GraphModel model, TextItems parameters) {
        return this.generating(rootDir, model, parameters, this.javaGeneratorTemplates, true);
    }

    public SendableEntityCreator generateTypescript(String rootDir, GraphModel model) {
        return this.generateTypescript(rootDir, model, null);
    }

    public SendableEntityCreator generateTypescript(String rootDir, GraphModel model, TextItems parameters) {
        SimpleList<BasicGenerator> templates = new SimpleList<BasicGenerator>();
        return this.generating(rootDir, model, parameters, templates, true);
    }

    public SendableEntityCreator generating(String rootDir, GraphModel model, TextItems parameters, SimpleList<BasicGenerator> templates, boolean writeFiles) {
        if (rootDir == null) {
            rootDir = "";
        } else if (!rootDir.endsWith("/")) {
            rootDir = rootDir + "/";
        }
        String name = model.getName();
        if (name == null) {
            name = "i.love.sdmlib";
        }
        rootDir = rootDir + name.replaceAll("\\.", "/") + "/";
        TemplateResultModel result = new TemplateResultModel();
        result.withTemplate(this.getTemplates());
        result.withFeatures(this.features);
        if (parameters == null) {
            parameters = new TextItems();
            parameters.withDefaultLabel(false);
        }
        result.withLanguage(parameters);
        for (BasicGenerator template : templates) {
            template.withOwner(this);
        }
        FeatureProperty codeStyle = this.getFeature(Feature.CODESTYLE, new Clazz[0]);
        for (Clazz clazz : model.getClazzes(new Condition[0])) {
            for (BasicGenerator template : templates) {
                boolean isStandard = codeStyle.match(clazz);
                TemplateResultFile resultFile = template.executeClazz(clazz, result, isStandard);
                template.executeTemplate(resultFile, result, clazz);
                result.add(resultFile);
            }
        }
        if (writeFiles) {
            for (TemplateResultFile file : result) {
                FileBuffer.writeFile(rootDir + file.getFileName(), file.toString());
            }
        }
        return result;
    }

    @Override
    public FeatureProperty getFeature(Feature value, Clazz ... clazzes) {
        if (this.features != null) {
            for (FeatureProperty item : this.features) {
                if (!item.equals((Object)value)) continue;
                if (clazzes == null) {
                    return item;
                }
                if (!item.match(clazzes)) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public Class<?> getTyp() {
        return GraphModel.class;
    }

    public ModelGenerator withoutFeature(Feature feature) {
        this.features.without(new Object[]{feature});
        return this;
    }

    public ModelGenerator withDefaultModel(GraphModel model) {
        this.defaultModel = model;
        return this;
    }

    public void testGeneratedCode() {
        if (this.defaultModel != null) {
            String rootDir = "build/gen/java";
            this.removeAllGeneratedCode(this.defaultModel, rootDir);
            this.generateJava(rootDir, this.defaultModel, null);
        }
    }

    public void removeAllGeneratedCode(GraphModel model, String rootDir) {
        FeatureProperty codeStyle = this.getFeature(Feature.CODESTYLE, new Clazz[0]);
        if (!rootDir.endsWith("/")) {
            rootDir = rootDir + "/";
        }
        for (Clazz clazz : model.getClazzes(new Condition[0])) {
            boolean isStandard = codeStyle.match(clazz);
            for (BasicGenerator generator : this.javaGeneratorTemplates) {
                TemplateResultFile templateResult = generator.createResultFile(clazz, isStandard);
                FileBuffer.deleteFile(rootDir + templateResult.getFileName());
            }
        }
        String path = rootDir + (model.getName() + "/util").replaceAll("\\.", "/") + "/";
        String fileName = path + "CreatorCreator.java";
        FileBuffer.deleteFile(fileName);
    }

    public TemplateResultFragment parseTemplate(String templateString, GraphMember member) {
        Template template = new Template().withTemplate(templateString);
        return this.parseTemplate(template, member);
    }

    public TemplateResultFragment parseTemplate(Template template, GraphMember member) {
        TemplateResultModel model = new TemplateResultModel();
        model.withTemplate(this.getTemplates());
        model.withFeatures(this.features);
        TextItems parameters = new TextItems();
        parameters.withDefaultLabel(false);
        model.withLanguage(parameters);
        TemplateResultFragment generate = template.generate(model, parameters, member);
        return generate;
    }
}

