/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.converter;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphDiff;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphImage;
import de.uniks.networkparser.graph.GraphLabel;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphOptions;
import de.uniks.networkparser.graph.GraphPattern;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Value;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleSet;
import java.util.ArrayList;
import java.util.Collection;

public class GraphConverter
implements Converter {
    public static final String TYPE = "type";
    public static final String ID = "id";
    public static final String NODE = "node";
    public static final String CLAZZ = "clazz";
    public static final String PATTERN = "pattern";
    public static final String SUBGRAPH = "subgraph";
    public static final String ATTRIBUTES = "attributes";
    public static final String METHODS = "methods";
    public static final String NODES = "nodes";
    public static final String EDGES = "edges";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String CARDINALITY = "cardinality";
    public static final String PROPERTY = "property";
    public static final String HEAD = "head";
    public static final String SRC = "src";
    public static final String OPTIONS = "options";
    private static final String STYLE = "style";
    private static final String INFO = "info";
    private static final String COUNTER = "counter";

    public GraphList convertGraphList(String type, JsonArray list) {
        GraphList root = new GraphList().withType(type);
        for (Object item : list) {
            if (!(item instanceof JsonObject)) continue;
            this.parseJsonObject(root, (JsonObject)item);
        }
        return root;
    }

    public JsonObject convertToJson(String type, JsonArray list, boolean removePackage) {
        GraphList root = this.convertGraphList(type, list);
        return this.convertToJson(root, removePackage, false);
    }

    public Clazz parseJsonObject(GraphList root, JsonObject node) {
        Clazz graphNode;
        String id;
        String typeId = id = node.getString(ID);
        boolean isClassDiagram = "classdiagram".equalsIgnoreCase(root.getType());
        if (isClassDiagram) {
            typeId = node.getString("class");
            id = null;
        }
        if ((graphNode = GraphUtil.getByObject(root, typeId, true)) == null) {
            graphNode = new Clazz(node.getString("class"));
            if (id != null) {
                graphNode.withId(id);
            }
            root.with(graphNode);
        }
        if (node.containsKey(HEAD)) {
            graphNode.with(new GraphImage().with(node.getString(HEAD)));
        }
        if (node.containsKey("prop")) {
            JsonObject props = node.getJsonObject("prop");
            block0: for (int i = 0; i < props.size(); ++i) {
                Value attribute;
                Association assoc;
                Association assocOther;
                Object value = props.getValueByIndex(i);
                if (value instanceof JsonObject) {
                    assocOther = new Association(graphNode).with(Cardinality.ONE).with(AssociationTypes.EDGE);
                    Clazz newNode = this.parseJsonObject(root, (JsonObject)value);
                    assoc = new Association(newNode).with(Cardinality.ONE).with((String)props.getKeyByIndex(i)).with(AssociationTypes.ASSOCIATION);
                    assoc.with(assocOther);
                    newNode.with(assoc);
                    graphNode.with(assocOther);
                    continue;
                }
                if (value instanceof JsonArray) {
                    JsonArray array = (JsonArray)value;
                    attribute = null;
                    for (Object entity : array) {
                        if (entity instanceof JsonObject) {
                            assocOther = new Association(graphNode).with(Cardinality.ONE).with(AssociationTypes.EDGE);
                            Clazz newNode = this.parseJsonObject(root, (JsonObject)entity);
                            assoc = new Association(newNode).with(Cardinality.MANY).with((String)props.getKeyByIndex(i)).with(AssociationTypes.ASSOCIATION);
                            assoc.with(assocOther);
                            newNode.with(assoc);
                            graphNode.with(assocOther);
                            if (!isClassDiagram) continue;
                            continue block0;
                        }
                        if (attribute == null) {
                            String name = (String)props.getKeyByIndex(i);
                            DataType type = DataType.create(value.getClass().getName());
                            attribute = new Attribute(name, type);
                            ((Attribute)attribute).withValue(entity.toString());
                            continue;
                        }
                        ((Attribute)attribute).withValue(attribute.getValue() + "," + entity.toString());
                    }
                    continue;
                }
                String name = (String)props.getKeyByIndex(i);
                AssociationSet associations = graphNode.getAssociations(new Condition[0]);
                for (Association childAssoc : associations) {
                    if (!name.equals(childAssoc.getName()) && !name.equals(childAssoc.getOther().getName())) continue;
                    name = null;
                    break;
                }
                if (name == null) continue;
                if (value != null) {
                    attribute = new Attribute(name, DataType.create(value.getClass()));
                    if (!isClassDiagram) {
                        ((Attribute)attribute).withValue(value.toString());
                    }
                } else {
                    attribute = new Attribute(name, null);
                }
                graphNode.with(new Attribute[]{attribute});
            }
        }
        return graphNode;
    }

    public JsonObject convertToJson(JsonArray list, boolean removePackage) {
        return this.convertToJson("objectdiagram", list, removePackage);
    }

    public JsonObject convertToJson(GraphModel root, boolean removePackage, boolean removeParameterNames) {
        String type = "classdiagram";
        String style = null;
        GraphOptions options = null;
        if (root instanceof GraphList) {
            GraphList graphList = (GraphList)root;
            type = graphList.getType();
            style = graphList.getStyle();
            options = graphList.getOptions();
        }
        JsonObject jsonRoot = new JsonObject().withValue(TYPE, type).withValue(ID, root.getName());
        if (options != null) {
            jsonRoot.add(OPTIONS, options.getJson());
        }
        if (style != null) {
            jsonRoot.put(STYLE, style);
        }
        jsonRoot.put(NODES, this.parseEntities(type, root, removePackage, removeParameterNames));
        jsonRoot.withKeyValue(EDGES, this.parseEdges(type, root.getAssociations(new Condition[0]), removePackage));
        return jsonRoot;
    }

    private Collection<?> parseEdges(String type, SimpleSet<Association> edges, boolean shortName) {
        JsonArray result = new JsonArray();
        ArrayList<String> ids = new ArrayList<String>();
        for (Association edge : edges) {
            SimpleSet<GraphEntity> edgeNodes = GraphUtil.getNodes(edge);
            for (GraphEntity source : edgeNodes) {
                SimpleSet<GraphEntity> edgeOtherNodes = GraphUtil.getNodes(edge.getOther());
                for (GraphEntity target : edgeOtherNodes) {
                    JsonObject child = this.parseEdge(type, source, target, edge, shortName, ids);
                    if (child == null) continue;
                    result.add(child);
                }
            }
        }
        if (result.size() < 1) {
            return null;
        }
        return result;
    }

    private JsonObject parseEdge(String type, GraphEntity source, GraphEntity target, Association edge, boolean shortName, ArrayList<String> ids) {
        if (source instanceof Clazz && target instanceof Clazz) {
            return this.parseEdge(type, (Clazz)source, (Clazz)target, edge, shortName, ids);
        }
        if (source instanceof GraphPattern && target instanceof GraphPattern) {
            return this.parseEdge(type, (GraphPattern)source, (GraphPattern)target, edge, shortName, ids);
        }
        return null;
    }

    private JsonObject parseEdge(String type, Clazz source, Clazz target, Association edge, boolean shortName, ArrayList<String> ids) {
        JsonObject child = new JsonObject().withKeyValue(TYPE, (Object)edge.getOther().getType());
        if (type.equals("objectdiagram")) {
            child.put(SOURCE, this.addInfo(edge, true).withValue(ID, source.getId() + " : " + source.getName(shortName)));
            child.put(TARGET, this.addInfo(edge.getOther(), true).withValue(ID, target.getId() + " : " + target.getName(shortName)));
            return child;
        }
        String id = new CharacterBuffer().with(source.getName(false), ":", edge.getName(), "-", target.getName(false), ":", edge.getOther().getName()).toString();
        if (!ids.contains(id)) {
            GraphDiff diff = GraphUtil.getDifference(edge);
            if (diff != null && diff.getCount() > 0) {
                child.put(COUNTER, diff.getCount());
            }
            child.put(SOURCE, this.addInfo(edge, true).withValue(ID, source.getName(shortName)));
            child.put(TARGET, this.addInfo(edge.getOther(), true).withValue(ID, target.getName(shortName)));
            ids.add(id);
            return child;
        }
        return null;
    }

    private JsonObject parseEdge(String type, GraphPattern source, GraphPattern target, Association edge, boolean shortName, ArrayList<String> ids) {
        JsonObject child = new JsonObject().withKeyValue(TYPE, (Object)edge.getType());
        child.put(SOURCE, this.addInfo(edge, false).withValue(ID, source.getId()));
        child.put(TARGET, this.addInfo(edge.getOther(), false).withValue(ID, target.getId()));
        GraphLabel info = edge.getInfo();
        if (info != null) {
            child.put(INFO, info.getName());
            child.put(STYLE, info.getStyle());
        }
        return child;
    }

    private JsonObject addInfo(Association edge, boolean cardinality) {
        if (cardinality) {
            return new JsonObject().withKeyValue(CARDINALITY, (Object)edge.getCardinality()).withValue(PROPERTY, edge.getName());
        }
        return new JsonObject().withValue(PROPERTY, edge.getName());
    }

    public JsonArray parseEntities(String type, GraphEntity nodes, boolean shortName, boolean removeParameterNames) {
        JsonArray result = new JsonArray();
        ArrayList<String> ids = new ArrayList<String>();
        GraphSimpleSet children = GraphUtil.getChildren(nodes);
        for (GraphMember entity : children) {
            JsonObject item = this.parseEntity(type, entity, shortName, removeParameterNames);
            if (item == null) continue;
            if ("classdiagram".equals(type) && item.has(ID)) {
                String key = item.getString(ID);
                if (ids.contains(key)) continue;
                ids.add(key);
            }
            result.add(item);
        }
        if (result.size() < 1) {
            return null;
        }
        return result;
    }

    public JsonObject parseEntity(String type, GraphMember entity, boolean shortName, boolean removeParameterNames) {
        GraphDiff diff;
        JsonArray items;
        GraphEntity element;
        if (type == null) {
            type = "objectdiagram";
            if (entity.getName() == null) {
                type = "classdiagram";
            }
        }
        JsonObject item = new JsonObject();
        if (entity instanceof Clazz) {
            item.put(TYPE, CLAZZ);
            element = (Clazz)entity;
            if (type == "objectdiagram") {
                item.put(ID, element.getId() + " : " + element.getName(shortName));
            } else {
                item.put(ID, element.getName(shortName));
            }
        } else if (entity instanceof GraphPattern) {
            item.put(TYPE, PATTERN);
            String bounds = ((GraphPattern)entity).getBounds();
            if (bounds != null) {
                item.put(STYLE, bounds);
            }
            item.put(ID, entity.getName());
        } else {
            if (entity instanceof GraphList) {
                return this.convertToJson((GraphList)entity, shortName, false);
            }
            item.put(TYPE, NODE);
        }
        if (!(entity instanceof GraphEntity)) {
            return null;
        }
        element = (GraphEntity)entity;
        GraphImage nodeHeader = this.getNodeHeader(element);
        if (nodeHeader != null) {
            item.put(HEAD, new JsonObject().withKeyValue(SRC, (Object)nodeHeader));
        }
        if ((items = this.parseAttributes(type, element, shortName)).size() > 0) {
            item.put(ATTRIBUTES, items);
        }
        if ((items = this.parseMethods(element, shortName, removeParameterNames)).size() > 0) {
            item.put(METHODS, items);
        }
        if ((diff = GraphUtil.getDifference(element)) != null && diff.getCount() > 0) {
            item.put(COUNTER, diff.getCount());
        }
        return item;
    }

    public GraphImage getNodeHeader(GraphEntity entity) {
        GraphSimpleSet children = GraphUtil.getChildren(entity);
        for (GraphMember member : children) {
            if (!(member instanceof GraphImage)) continue;
            return (GraphImage)member;
        }
        return null;
    }

    private JsonArray parseAttributes(String type, GraphEntity list, boolean shortName) {
        JsonArray result = new JsonArray();
        String splitter = "";
        if (type.equals("objectdiagram")) {
            splitter = "=";
        } else if (type.equals("classdiagram")) {
            splitter = ":";
        }
        GraphSimpleSet children = GraphUtil.getChildren(list);
        for (GraphMember item : children) {
            if (!(item instanceof Attribute)) continue;
            Attribute attribute = (Attribute)item;
            result.add(attribute.getName() + splitter + attribute.getValue(type, shortName));
        }
        return result;
    }

    private JsonArray parseMethods(GraphEntity list, boolean shortName, boolean removeParameterNames) {
        JsonArray result = new JsonArray();
        GraphSimpleSet children = GraphUtil.getChildren(list);
        for (GraphMember item : children) {
            if (!(item instanceof Method)) continue;
            Method method = (Method)item;
            result.add(method.getName(false, removeParameterNames));
        }
        return result;
    }

    @Override
    public String encode(BaseItem entity) {
        if (entity instanceof GraphList) {
            return this.convertToJson((GraphModel)((Object)entity), false, false).toString();
        }
        return null;
    }

    public static JsonObject convertModel(GraphModel model) {
        GraphConverter converter = new GraphConverter();
        return converter.convertToJson(model, false, true);
    }
}

