/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.SimpleGrammar;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.list.SimpleIteratorSet;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.HTMLEntity;

public class HTMLGrammar
extends SimpleGrammar {
    public static final String CLASSNAME = "%CLASSNAME";
    public static final String PROPERTY = "%PROPERTY";
    public static final String DEEP = "%DEEP";
    private SimpleKeyValueList<String, String> transformValue = new SimpleKeyValueList();
    private SimpleIteratorSet<String, String> iterator = new SimpleIteratorSet<String, String>(this.transformValue);

    @Override
    public BaseItem encode(Object entity, MapEntity map, Tokener tokener) {
        HTMLEntity rootItem = new HTMLEntity();
        rootItem.withEncoding("utf-8");
        Entity child = map.encode(entity, tokener);
        rootItem.add(child);
        return rootItem;
    }

    private boolean transformValue(CharacterBuffer value, int deep, boolean isClassName) {
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            Object item = this.iterator.next();
            if (isClassName && CLASSNAME.equals(item.getKey()) && value.indexOf(46) > 0) {
                value.set((CharSequence)item.getValue());
                return true;
            }
            if (!value.equals((CharSequence)item.getKey())) continue;
            String property = value.toString();
            value.set((CharSequence)item.getValue());
            value.replace(DEEP, "" + deep);
            value.replace(PROPERTY, property);
            return true;
        }
        return false;
    }

    @Override
    public Entity writeBasicValue(Entity entity, String className, String id, IdMap map) {
        CharacterBuffer value = new CharacterBuffer().with(className);
        if (this.transformValue(value, 0, true)) {
            String prop = value.toString();
            Entity item = (Entity)entity.getNewList(false);
            String session = map.getSession();
            if (session != null) {
                entity.put("session", session);
            }
            if (id != null) {
                entity.put("id", id);
                entity.put("timestamp", id.substring(1));
            }
            entity.add(item);
            entity = item;
            super.writeBasicValue(item, prop, id, map);
        } else {
            super.writeBasicValue(entity, className, id, map);
        }
        return entity;
    }

    @Override
    public boolean writeValue(BaseItem parent, String property, Object value, MapEntity map, Tokener tokener) {
        if (parent instanceof EntityList && tokener.isChild(value)) {
            ((EntityList)parent).add(value);
        } else if (parent instanceof Entity) {
            CharacterBuffer prop = new CharacterBuffer().with(property);
            this.transformValue(prop, map.getDeep(), false);
            parent = map.convertProperty(prop, parent);
            property = prop.toString();
            if (property.length() == 1 && property.charAt(0) == '.') {
                Object element = tokener.transformValue(value, parent);
                CharacterBuffer buffer = new CharacterBuffer().with("" + element);
                ((Entity)parent).withValue(buffer);
            } else {
                ((Entity)parent).put(property, tokener.transformValue(value, parent));
            }
        }
        return true;
    }

    public void with(String key, String value) {
        this.transformValue.add(key, value);
    }
}

