/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.ClazzType;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.Literal;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorIndexId;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.xml.XMLContainer;
import de.uniks.networkparser.xml.XMLEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class EMFTokener
extends Tokener {
    public static final String ECORE = "ecore";
    public static final String EPACKAGE = "ecore:EPackage";
    public static final String EAttribute = "eAttributes";
    public static final String ECLASS = "eClassifiers";
    public static final String EREFERENCE = "eReferences";
    public static final String ETYPE = "eType";
    public static final String EDATATYPE = "ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//";
    public static final String TYPE_ECLASS = "ecore:EClass";
    public static final String TYPE_EAttribute = "ecore:EAttribute";
    public static final String TYPE_EReferences = "ecore:EReference";
    public static final String TYPE_ESUPERTYPE = "eSuperTypes";
    public static final String TYPE_EEnum = "ecore:EEnum";
    public static final String EOpposite = "eOpposite";
    public static final String ATTRIBUTE_URL = "http://www.eclipse.org/emf/2002/Ecore#//";
    public static final String UPPERBOUND = "upperBound";
    public static final String XSI_TYPE = "xsi:type";
    public static final String XMI_ID = "xmi:id";
    public static final String NAME = "name";
    SimpleKeyValueList<String, Integer> runningNumbers = new SimpleKeyValueList();
    SimpleKeyValueList<XMLEntity, SimpleKeyValueList<String, String>> notKey = new SimpleKeyValueList();

    protected void skipEntity() {
        this.skipTo('>', false);
        this.nextClean(false);
    }

    public String skipHeader() {
        CharacterBuffer tag;
        boolean skip = false;
        while ((tag = this.getString(2)) != null) {
            if (tag.equals("<?")) {
                this.skipEntity();
                skip = true;
            } else if (tag.equals("<!")) {
                this.skipEntity();
                skip = true;
            } else {
                skip = false;
            }
            if (skip) continue;
        }
        if (tag != null) {
            String item = tag.toString();
            this.buffer.withLookAHead(item);
            return item;
        }
        return "";
    }

    @Override
    public XMLEntity encode(Object entity, MapEntity map) {
        if (entity instanceof GraphList) {
            return this.encodeClassModel((GraphList)entity, map);
        }
        XMLEntity result = new XMLEntity();
        String typetag = entity.getClass().getName().replaceAll("\\.", ":");
        result.setType(typetag);
        this.encodeChildren(entity, result, map);
        return result;
    }

    public XMLEntity encodeClassModel(GraphList entity, MapEntity map) {
        String id;
        XMLContainer container = new XMLContainer();
        container.withStandardPrefix();
        XMLEntity root = container.createChild();
        root.setType(EPACKAGE);
        root.withKeyValue("xmi:version", "2.0");
        root.withKeyValue("xmlns:xmi", "http://www.omg.org/XMI");
        root.withKeyValue("xmlns:ecore", "http://www.eclipse.org/emf/2002/Ecore");
        String name = "model";
        if (entity.getName() != null) {
            id = EntityUtil.shortClassName(entity.getName());
            name = entity.getName();
        } else {
            id = name;
        }
        root.withKeyValue(NAME, id);
        root.withKeyValue("nsURI", "http:///" + name.replace(".", "/") + ".ecore");
        root.withKeyValue("nsPrefix", name);
        for (Clazz child : entity.getClazzes(new Condition[0])) {
            XMLEntity ecoreClass = root.createChild();
            ecoreClass.setType(ECLASS);
            ecoreClass.withKeyValue(XSI_TYPE, TYPE_ECLASS);
            ecoreClass.withKeyValue(NAME, child.getName());
            for (Attribute attribute : child.getAttributes(new Condition[0])) {
                DataType type = attribute.getType();
                if (!EntityUtil.isPrimitiveType(type.getName(false))) continue;
                XMLEntity ecoreAttribute = ecoreClass.createChild();
                ecoreAttribute.setType(EAttribute);
                ecoreAttribute.withKeyValue(NAME, attribute.getName());
                ecoreAttribute.withKeyValue(ETYPE, "ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//E" + EntityUtil.upFirstChar(type.getName(true)));
            }
            for (Association assoc : child.getAssociations(new Condition[0])) {
                XMLEntity ecoreAssociation = ecoreClass.createChild();
                ecoreAssociation.setType(EREFERENCE);
                ecoreAssociation.withKeyValue(NAME, assoc.getOther().getName());
                ecoreAssociation.withKeyValue(ETYPE, "#//" + assoc.getOtherClazz().getName());
                ecoreAssociation.withKeyValue(EOpposite, "#//" + assoc.getOtherClazz().getName() + "/" + assoc.getName());
                if (Cardinality.MANY.equals((Object)assoc.getCardinality())) {
                    ecoreAssociation.withKeyValue(UPPERBOUND, "-1");
                    continue;
                }
                ecoreAssociation.withKeyValue(UPPERBOUND, "1");
            }
        }
        return container;
    }

    private void encodeChildren(Object entity, XMLEntity parent, MapEntity map) {
        SendableEntityCreator creatorClass = this.getCreatorClass(entity);
        if (creatorClass == null) {
            return;
        }
        for (String propertyName : creatorClass.getProperties()) {
            Object propertyValue = creatorClass.getValue(entity, propertyName);
            if (EntityUtil.isPrimitiveType(EntityUtil.shortClassName(propertyValue.getClass().getName()))) {
                parent.put(propertyName, propertyValue);
                continue;
            }
            if (propertyValue instanceof Collection) {
                for (Object childValue : (Collection)propertyValue) {
                    XMLEntity child = new XMLEntity();
                    parent.withChild(child);
                    child.setType(propertyName);
                    String typetag = childValue.getClass().getName().replaceAll("\\.", ":");
                    child.put(XSI_TYPE, typetag);
                    this.encodeChildren(childValue, child, map);
                }
                continue;
            }
            XMLEntity child = new XMLEntity();
            parent.withChild(child);
            child.setType(propertyName);
            String typetag = propertyValue.getClass().getName().replaceAll("\\.", ":");
            child.put(XSI_TYPE, typetag);
            this.encodeChildren(propertyValue, child, map);
        }
    }

    public Object decode(MapEntity map, Object root) {
        SendableEntityCreator rootFactory;
        this.skipHeader();
        XMLEntity xmlEntity = new XMLEntity();
        xmlEntity.withValue(this.buffer);
        if (EPACKAGE.equals(xmlEntity.getTag())) {
            if (root instanceof GraphList) {
                return this.decoding(xmlEntity, (GraphList)((Object)root));
            }
            return this.decoding(xmlEntity, null);
        }
        String tag = xmlEntity.getTag();
        String[] splitTag = tag.split("\\:");
        if (splitTag.length < 2) {
            return null;
        }
        if (ECORE.equalsIgnoreCase(splitTag[0]) || root instanceof GraphModel) {
            GraphModel model = root == null || !(root instanceof GraphModel) ? new GraphList() : (GraphModel)((Object)root);
            return this.decodingClassModel(xmlEntity, model);
        }
        Object rootObject = null;
        if (root == null) {
            String className = splitTag[1];
            rootFactory = this.getCreator(className, false, null);
            rootObject = rootFactory != null ? rootFactory.getSendableInstance(false) : new ArrayList();
        } else {
            rootObject = root;
            rootFactory = this.getCreatorClass(root);
        }
        this.parsing(xmlEntity, rootFactory, rootObject, null);
        for (int i = 0; i < this.notKey.size(); ++i) {
            XMLEntity itemXmlEntity = (XMLEntity)this.notKey.get(i);
            SimpleKeyValueList<String, String> myRefs = this.notKey.getValueByIndex(i);
            String id = itemXmlEntity.getString(XMI_ID);
            Object item = this.getObject(id);
            SendableEntityCreator creator = this.getCreator(item.getClass().getName(), false, null);
            for (int r = 0; r < myRefs.size(); ++r) {
                String prop = (String)myRefs.get(r);
                String value = myRefs.getValueByIndex(r);
                SimpleList<String> refs = this.getRef(value, itemXmlEntity, creator);
                for (String ref : refs) {
                    Object object = this.getObject(ref);
                    if (object == null) continue;
                    creator.setValue(item, prop, object, "");
                }
            }
        }
        return rootObject;
    }

    private Object decodingClassModel(XMLEntity values, GraphModel model) {
        SimpleKeyValueList<String, Clazz> items = new SimpleKeyValueList<String, Clazz>();
        for (int c = 0; c < values.sizeChildren(); ++c) {
            EntityList item = values.getChild(c);
            if (!(item instanceof XMLEntity)) continue;
            XMLEntity child = (XMLEntity)item;
            String[] splitTag = child.getTag().split("\\:");
            String className = splitTag[1];
            Clazz clazz = (Clazz)items.get(className);
            if (clazz == null) {
                clazz = new Clazz(className);
                items.add(className, clazz);
                model.with(clazz);
            }
            for (int i = 0; i < child.size(); ++i) {
                String key = (String)child.get(i);
                String value = (String)child.getValueByIndex(i);
                if (value == null) {
                    value = "";
                }
                if (!value.startsWith("/")) continue;
                AssociationSet associations = clazz.getAssociations(new Condition[0]);
                Association found = null;
                for (Association assoc : associations) {
                    if (!key.equals(assoc.getName())) continue;
                    found = assoc;
                    break;
                }
                if (found == null) {
                    found = new Association(clazz);
                    found.with(key);
                    SimpleList<String> refs = this.getRef(key, child, null);
                    for (String ref : refs) {
                        Association back = new Association((GraphEntity)items.get(ref));
                        found.with(back);
                    }
                }
                if (value.indexOf("/", 1) <= 0) continue;
                found.with(Cardinality.MANY);
            }
        }
        return model;
    }

    private SimpleList<String> getRef(String value, XMLEntity xmlEntity, SendableEntityCreator rootFactory) {
        SimpleList<String> result;
        block5: {
            block7: {
                block6: {
                    block4: {
                        result = new SimpleList<String>();
                        if (!value.startsWith("//@")) break block4;
                        for (String ref : value.split(" ")) {
                            String myRef = "_" + ref.substring(3);
                            myRef = myRef.indexOf(46) > 0 ? myRef.replaceAll("\\.|/@", "") : "_" + myRef.subSequence(0, 1) + "0";
                            result.add(myRef);
                        }
                        break block5;
                    }
                    if (!value.startsWith("/")) break block6;
                    String tagChar = xmlEntity.getTag().substring(0, 1);
                    for (String ref : value.split(" ")) {
                        ref = "_" + tagChar + ref.substring(1);
                        if (this.getObject(ref) == null) continue;
                        result.add(ref);
                    }
                    break block5;
                }
                if (value.indexOf(95) <= 0) break block7;
                for (String ref : value.split(" ")) {
                    if (this.getObject(ref) == null) continue;
                    result.add(ref);
                }
                break block5;
            }
            if (!value.startsWith("$")) break block5;
            for (String ref : value.split(" ")) {
                String myRef = "_" + ref.substring(1);
                if (rootFactory == null || this.getObject(myRef) == null) continue;
                result.add(myRef);
            }
        }
        return result;
    }

    private void parsing(XMLEntity xmlEntity, SendableEntityCreator entityFactory, Object entityObject, String rootId) {
        String tag;
        String id = (String)xmlEntity.getValue(XMI_ID);
        Collection rootCollection = null;
        if (id == null) {
            String temp;
            tag = xmlEntity.getTag();
            if (rootId != null) {
                Integer num = this.runningNumbers.get(rootId = rootId + tag);
                if (num == null) {
                    num = 0;
                } else {
                    Integer n = num;
                    Integer n2 = num = Integer.valueOf(num + 1);
                }
                this.runningNumbers.put(rootId, num);
                rootId = rootId + num;
            } else {
                rootId = "$";
            }
            if (xmlEntity.has("href")) {
                String objectId;
                String refString = xmlEntity.getString("href");
                String[] split = refString.split("#//");
                if (split.length == 2) {
                    objectId = split[1];
                    objectId = objectId.replace('@', '_');
                    Iterator object = this.getObject(objectId = objectId.replace(".", ""));
                    if (object != null) {
                        if (entityObject instanceof Collection) {
                            rootCollection = (Collection)entityObject;
                        }
                        if (rootCollection != null) {
                            rootCollection.add(object);
                        } else {
                            entityFactory.setValue(entityObject, tag, object, "");
                        }
                        return;
                    }
                }
                if (split.length == 2) {
                    objectId = split[1];
                    objectId = objectId.replace('@', '$');
                    objectId = objectId.replace(".", "");
                    xmlEntity.put(XMI_ID, objectId);
                }
            }
            if (entityFactory instanceof SendableEntityCreatorIndexId && (temp = xmlEntity.getString("id")) != null) {
                rootId = temp;
            }
        }
        if (rootId.startsWith("$")) {
            rootId = "_" + rootId.substring(1);
        }
        this.map.put(rootId, entityObject, true);
        if (!xmlEntity.has(XMI_ID)) {
            xmlEntity.put(XMI_ID, rootId);
        }
        if (entityFactory != null) {
            block0: for (int i = 0; i < xmlEntity.size(); ++i) {
                String key = (String)xmlEntity.getKeyByIndex(i);
                String value = xmlEntity.getString(key);
                if (value == null || "".equals(value = value.trim()) || XMI_ID.equals(key)) continue;
                SimpleList<String> myRefs = this.getRef(value, xmlEntity, entityFactory);
                if (myRefs.size() == 0) {
                    entityFactory.setValue(entityObject, key, value, "");
                }
                for (String myRef : myRefs) {
                    Object object = this.getObject(myRef);
                    if (object != null) {
                        entityFactory.setValue(entityObject, key, object, "");
                        continue;
                    }
                    SimpleKeyValueList<String, String> list = this.notKey.get(xmlEntity);
                    if (list == null) {
                        list = new SimpleKeyValueList();
                        this.notKey.put(xmlEntity, list);
                    }
                    list.put(key, value);
                    continue block0;
                }
            }
        }
        for (int i = 0; i < xmlEntity.sizeChildren(); ++i) {
            String typeName = null;
            XMLEntity kid = (XMLEntity)xmlEntity.getChild(i);
            tag = kid.getTag();
            if (entityObject instanceof Collection) {
                rootCollection = (Collection)entityObject;
                int pos = tag.indexOf(":");
                typeName = pos > 0 ? tag.substring(pos + 1) : tag;
            }
            if (kid.has(XSI_TYPE)) {
                typeName = kid.getString(XSI_TYPE);
                typeName = typeName.replaceAll(":", ".");
            }
            if (typeName == null) {
                Object value = entityFactory.getValue(entityObject, tag);
                if (value != null) {
                    if (value instanceof SimpleSet) {
                        SimpleSet set = (SimpleSet)value;
                        typeName = set.getTypClass().getName();
                    } else {
                        typeName = value.getClass().getName();
                    }
                } else {
                    typeName = tag;
                }
            }
            if (typeName == null) continue;
            SendableEntityCreator kidFactory = this.getCreator(typeName, false, null);
            if (kidFactory == null && typeName.endsWith("s")) {
                kidFactory = this.getCreator(typeName.substring(0, typeName.length() - 1), false, null);
            }
            if (kidFactory == null) continue;
            Object kidObject = kidFactory.getSendableInstance(false);
            this.parsing(kid, kidFactory, kidObject, rootId);
            if (rootCollection != null) {
                rootCollection.add(kidObject);
                continue;
            }
            entityFactory.setValue(entityObject, tag, kidObject, "");
        }
    }

    public GraphList decoding(String content) {
        return this.decoding(new XMLEntity().withValue(content), null);
    }

    public GraphList decoding(Tokener content) {
        return this.decoding(new XMLEntity().withValue(this), null);
    }

    /*
     * WARNING - void declaration
     */
    private GraphList decoding(XMLEntity ecore, GraphList model) {
        void var6_11;
        if (model == null) {
            model = new GraphList();
        }
        SimpleList<XMLEntity> superClazzes = new SimpleList<XMLEntity>();
        SimpleKeyValueList<Entity, EntityList> parentList = new SimpleKeyValueList<Entity, EntityList>();
        for (int i = 0; i < ecore.sizeChildren(); ++i) {
            Entity childItem;
            EntityList child;
            int c;
            XMLEntity xml;
            EntityList entityList = ecore.getChild(i);
            if (!(entityList instanceof XMLEntity) || !(xml = (XMLEntity)entityList).has(XSI_TYPE)) continue;
            if (xml.getString(XSI_TYPE).equalsIgnoreCase(TYPE_ECLASS)) {
                Clazz clazz = new Clazz(xml.getString(NAME));
                model.with(clazz);
                for (c = 0; c < xml.sizeChildren(); ++c) {
                    child = xml.getChild(c);
                    if (!(child instanceof Entity)) continue;
                    childItem = (Entity)((Object)child);
                    String typ = childItem.getString(XSI_TYPE);
                    if (typ.equals(TYPE_EAttribute)) {
                        String etyp = EntityUtil.getId(childItem.getString(ETYPE));
                        if (EntityUtil.isEMFType(etyp)) {
                            etyp = etyp.substring(1);
                        }
                        if (EntityUtil.isPrimitiveType(etyp.toLowerCase())) {
                            etyp = etyp.toLowerCase();
                        }
                        clazz.with(new Attribute(EntityUtil.toValidJavaId(childItem.getString(NAME)), DataType.create(etyp)));
                        continue;
                    }
                    if (!typ.equals(TYPE_EReferences)) continue;
                    parentList.add(childItem, entityList);
                }
                if (!xml.has(TYPE_ESUPERTYPE)) continue;
                superClazzes.add(xml);
                continue;
            }
            if (!xml.getString(XSI_TYPE).equals(TYPE_EEnum)) continue;
            Clazz graphEnum = new Clazz(xml.getString(NAME));
            graphEnum.with(ClazzType.ENUMERATION);
            for (c = 0; c < xml.sizeChildren(); ++c) {
                child = ecore.getChild(i);
                if (!(child instanceof Entity)) continue;
                childItem = (Entity)((Object)child);
                Literal literal = new Literal(childItem.getString(NAME));
                for (int z = 0; z < childItem.size(); ++z) {
                    String key = childItem.getKeyByIndex(z);
                    if (key.equals(NAME)) continue;
                    literal.withValue(childItem.getValue(key));
                    graphEnum.with(literal);
                }
            }
        }
        for (Entity entity : superClazzes) {
            String id = EntityUtil.getId(entity.getString(TYPE_ESUPERTYPE));
            Clazz kidClazz = model.getNode(entity.getString(NAME));
            if (kidClazz == null) continue;
            Clazz superClazz = model.getNode(id);
            kidClazz.withSuperClazz(superClazz);
        }
        SimpleKeyValueList<String, Association> items = new SimpleKeyValueList<String, Association>();
        boolean bl = false;
        while (var6_11 < parentList.size()) {
            Object upperValue;
            Entity eref = (Entity)parentList.get((int)var6_11);
            String tgtClassName = eref.getString(ETYPE);
            if (tgtClassName.indexOf("#") >= 0) {
                tgtClassName = tgtClassName.substring(tgtClassName.indexOf("#") + 3);
            }
            String tgtRoleName = eref.getString(NAME);
            Association tgtAssoc = this.getOrCreate(items, model, tgtClassName, tgtRoleName);
            if (eref.has(UPPERBOUND) && (upperValue = eref.getValue(UPPERBOUND)) instanceof Number && ((Number)upperValue).intValue() != 1) {
                tgtAssoc.with(Cardinality.MANY);
            }
            String srcRoleName = null;
            XMLEntity parent = (XMLEntity)parentList.getValueByIndex((int)var6_11);
            String srcClassName = parent.getString(NAME);
            if (eref.has(EOpposite)) {
                srcRoleName = EntityUtil.getId(eref.getString(EOpposite));
            }
            Association srcAssoc = this.getOrCreate(items, model, srcClassName, srcRoleName);
            tgtAssoc.with(srcAssoc);
            srcAssoc.with(AssociationTypes.EDGE);
            tgtAssoc.getClazz().with(tgtAssoc);
            srcAssoc.getClazz().with(srcAssoc);
            model.with(tgtAssoc);
            ++var6_11;
        }
        return model;
    }

    private Association getOrCreate(SimpleKeyValueList<String, Association> items, GraphList model, String className, String roleName) {
        int pos;
        if (className != null && (pos = className.indexOf("/")) > 0) {
            className = className.substring(pos + 1);
        }
        roleName = EntityUtil.toValidJavaId(roleName);
        String assocName = className + ":" + roleName;
        Association edge = (Association)items.getValue(assocName);
        if (edge == null) {
            Clazz clazz = model.getNode(className);
            if (clazz == null) {
                clazz = model.createClazz(className);
            }
            if (clazz != null) {
                edge = new Association(clazz).with(Cardinality.ONE).with(roleName);
                clazz.with(edge);
                if (roleName != null) {
                    items.add(assocName, edge);
                }
            }
        }
        return edge;
    }
}

