/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.converter.YUMLConverter;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphOptions;
import de.uniks.networkparser.graph.GraphPattern;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.list.SimpleMapEntry;
import de.uniks.networkparser.list.SimpleSet;

public class GraphList
extends GraphModel
implements BaseItem {
    private String typ = "classdiagram";
    private String style;
    private GraphOptions options;

    @Override
    public String toString() {
        return this.toString(new YUMLConverter());
    }

    public String toString(boolean removePackage) {
        YUMLConverter converter = new YUMLConverter();
        converter.defaultShowPackage = removePackage;
        return this.toString(converter);
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        return converter.encode(this);
    }

    public String getType() {
        return this.typ;
    }

    public GraphList withType(String typ) {
        this.typ = typ;
        return this;
    }

    public GraphList withEdge(String sourceName, String targetName) {
        Association edge = new Association().with(sourceName).with(new Association().with(targetName));
        super.with(edge);
        return this;
    }

    public void initSubLinks() {
        for (GraphEntity node : this.getNodes()) {
            if (!(node instanceof Clazz)) continue;
            Clazz graphClazz = (Clazz)node;
            AssociationSet childEdges = graphClazz.getAssociations(new Condition[0]);
            for (Association edge : childEdges) {
                AssociationSet associations = this.getAssociations(new Condition[0]);
                if (associations.contains(edge) || associations.contains(edge.getOther())) continue;
                super.with(edge);
            }
        }
    }

    public Clazz with(Clazz value) {
        if (value != null) {
            if (value.getName() == null) {
                value.with(value.getName(false));
            }
            super.with(value);
        }
        return value;
    }

    public GraphList with(GraphList ... values) {
        super.withChildren(values);
        return this;
    }

    public GraphPattern with(GraphPattern value) {
        super.withChildren(value);
        return value;
    }

    public GraphList withNode(GraphEntity ... value) {
        super.withChildren(value);
        return this;
    }

    public GraphOptions getOptions() {
        return this.options;
    }

    public GraphList withOptions(GraphOptions options) {
        this.options = options;
        return this;
    }

    public String getStyle() {
        return this.style;
    }

    public GraphList withStyle(String style) {
        this.style = style;
        return this;
    }

    public Clazz getNode(String id) {
        if (id == null) {
            return null;
        }
        for (GraphMember item : this.getChildren()) {
            if (!(item instanceof Clazz) || !id.equalsIgnoreCase(item.getFullId())) continue;
            return (Clazz)item;
        }
        return null;
    }

    @Override
    public SimpleSet<GraphEntity> getNodes() {
        return super.getNodes();
    }

    public Association getEdge(GraphEntity node, String property) {
        for (Association edge : this.getAssociations(new Condition[0])) {
            Association oEdge = edge.getOther();
            if (edge.getClazz() == node && property.equals(oEdge.getName())) {
                return edge;
            }
            if (oEdge.getClazz() != node || !property.equals(edge.getName())) continue;
            return oEdge;
        }
        return null;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return false;
        }
        for (Object item : values) {
            if (!(item instanceof GraphMember)) continue;
            super.withChildren((GraphMember)item);
        }
        return true;
    }

    public Object getValue(Object key) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof GraphMember) {
            if (this.children == key) {
                return this.children;
            }
            return null;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet collection = (GraphSimpleSet)this.children;
            return collection.getValue(key);
        }
        return null;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        if (keyValue) {
            return new SimpleMapEntry();
        }
        return new GraphList();
    }

    @Override
    public GraphList with(String name) {
        super.with(name);
        return this;
    }
}

