/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.Feature;
import de.uniks.networkparser.list.SimpleList;

public class FeatureProperty
implements Comparable<FeatureProperty> {
    public static final Clazz ALL = new Clazz("*");
    private SimpleList<Clazz> includeClazz = new SimpleList();
    private SimpleList<Clazz> excludeClazz = new SimpleList();
    private SimpleList<String> path = new SimpleList();
    private Class<?> classValue;
    private String value;
    private Feature name;

    FeatureProperty(Feature name) {
        this.name = name;
        this.includeClazz.add(ALL);
    }

    public FeatureProperty withIncludeClazz(String ... value) {
        if (value == null) {
            return this;
        }
        for (String item : value) {
            if (item == null) continue;
            this.includeClazz.add(new Clazz(item));
        }
        return this;
    }

    public FeatureProperty withExcludeClazz(String ... value) {
        if (value == null) {
            return this;
        }
        if (value.length > 0) {
            this.includeClazz.remove(ALL);
        }
        for (String item : value) {
            if (item == null) continue;
            this.excludeClazz.add(new Clazz(item));
        }
        return this;
    }

    public FeatureProperty withExcludeClazz(Clazz ... value) {
        if (value == null) {
            return this;
        }
        if (value.length > 0) {
            this.includeClazz.remove(ALL);
        }
        for (Clazz item : value) {
            if (item == null) continue;
            this.excludeClazz.add(item);
        }
        return this;
    }

    public boolean match(Clazz ... clazzes) {
        if (clazzes == null) {
            return true;
        }
        for (Clazz clazz : clazzes) {
            if (clazz == null) {
                return true;
            }
            if (this.match(clazz.getName(false))) continue;
            return false;
        }
        return true;
    }

    public boolean match(String clazzName) {
        boolean result = false;
        if (this.classValue != null) {
            return this.classValue.getName().equals(clazzName);
        }
        for (Clazz item : this.includeClazz) {
            if (item == null) continue;
            if (ALL.getName(false).equals(item.getName(false))) {
                result = true;
                break;
            }
            if (!item.getName(false).equals(clazzName)) continue;
            result = true;
            break;
        }
        for (Clazz item : this.excludeClazz) {
            if (item == null) continue;
            if (ALL.getName(false).equals(item.getName(false))) {
                result = false;
                break;
            }
            if (!item.getName(false).equals(clazzName)) continue;
            result = false;
            break;
        }
        return result;
    }

    public Feature getName() {
        return this.name;
    }

    public FeatureProperty withClazzValue(Class<?> value) {
        this.classValue = value;
        return this;
    }

    public FeatureProperty withPath(String ... value) {
        if (value == null) {
            return this;
        }
        for (String item : value) {
            if (item == null) continue;
            this.path.add(item);
        }
        return this;
    }

    public SimpleList<String> getPath() {
        return this.path;
    }

    public Class<?> getClassValue() {
        return this.classValue;
    }

    @Override
    public int compareTo(FeatureProperty o) {
        if (this.name == null) {
            return 1;
        }
        return this.name.compareTo(o.getName());
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Feature) {
            return obj.equals((Object)this.name);
        }
        if (!(obj instanceof FeatureProperty)) {
            return false;
        }
        return this.compareTo((FeatureProperty)obj) == 0;
    }

    public String toString() {
        if (this.name != null) {
            return this.name.toString();
        }
        return super.toString();
    }

    public String getStringValue() {
        return this.value;
    }

    public FeatureProperty withStringValue(String value) {
        this.value = value;
        return this;
    }
}

