/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.TemplateParser;

public class TemplateFragmentCondition
implements ParserCondition {
    public static final String PROPERTY_CLONE = "clone";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_TEMPLATE = "template";
    public static final String TAG = "template";
    private String id;
    private ObjectCondition condition;
    private ObjectCondition child;

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public String getKey() {
        return "template";
    }

    private int getIdKey() {
        if ("PACKAGE".equalsIgnoreCase(this.id)) {
            return 1;
        }
        if ("IMPORT".equalsIgnoreCase(this.id)) {
            return 2;
        }
        if ("TEMPLATE".equalsIgnoreCase(this.id)) {
            return 3;
        }
        if ("FIELD".equalsIgnoreCase(this.id)) {
            return 4;
        }
        if ("VALUE".equalsIgnoreCase(this.id)) {
            return 5;
        }
        if ("METHOD".equalsIgnoreCase(this.id)) {
            return 6;
        }
        if ("TEMPLATEEND".equalsIgnoreCase(this.id)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    @Override
    public boolean update(Object value) {
        if (value instanceof SendableEntityCreator) {
            if (this.condition != null && !this.condition.update(value)) {
                return false;
            }
            SendableEntityCreator creator = (SendableEntityCreator)value;
            SendableEntityCreator newInstance = (SendableEntityCreator)creator.getValue(creator, PROPERTY_CLONE);
            newInstance.setValue(newInstance, PROPERTY_KEY, this.getIdKey(), "new");
            newInstance.setValue(newInstance, "template", this.child, "new");
            newInstance.setValue(newInstance, PROPERTY_FILE, creator.getValue(creator, PROPERTY_FILE), "new");
            this.child.update(newInstance);
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(LocalisationInterface variables) {
        return null;
    }

    @Override
    public void create(CharacterBuffer buffer, TemplateParser parser, LocalisationInterface customTemplate) {
        CharacterBuffer id = buffer.nextToken(false, '}', ' ');
        this.id = id.toString();
        buffer.nextClean(true);
        if (buffer.getCurrentChar() != '}') {
            this.condition = parser.parsing(buffer, customTemplate, true, new String[0]);
        }
        buffer.skipChar('}');
        buffer.skipChar('}');
        this.child = parser.parsing(buffer, customTemplate, false, "endtemplate");
        buffer.skip();
        buffer.skipTo('}', true);
        buffer.skipChar('}');
        buffer.skipChar('}');
    }

    public String getId() {
        return this.id;
    }

    @Override
    public TemplateFragmentCondition getSendableInstance(boolean prototyp) {
        return new TemplateFragmentCondition();
    }
}

