/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.ConditionSet;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.logic.ChainCondition;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;

public abstract class ListCondition
implements ParserCondition,
SendableEntityCreator {
    public static final String CHILD = "childs";
    protected Object list;
    protected boolean chain = true;

    @Override
    public boolean update(Object evt) {
        if (evt instanceof PropertyChangeEvent) {
            return this.updatePCE((PropertyChangeEvent)evt);
        }
        ConditionSet list = this.getList();
        boolean result = true;
        for (ObjectCondition item : list) {
            if (item.update(evt)) continue;
            result = false;
        }
        return result;
    }

    public boolean updatePCE(PropertyChangeEvent evt) {
        if (this.list instanceof PropertyChangeListener) {
            ((PropertyChangeListener)this.list).propertyChange(evt);
            return true;
        }
        if (this.list instanceof ObjectCondition) {
            return ((ObjectCondition)this.list).update(evt);
        }
        SimpleSet collection = (SimpleSet)this.list;
        for (Object listener : collection) {
            if (listener instanceof ObjectCondition) {
                if (((ObjectCondition)listener).update(evt) || !this.chain) continue;
                return false;
            }
            if (!(listener instanceof PropertyChangeListener)) continue;
            ((PropertyChangeListener)listener).propertyChange(evt);
        }
        return true;
    }

    public ListCondition with(ObjectCondition ... values) {
        this.add(values);
        return this;
    }

    public ListCondition with(PropertyChangeListener ... values) {
        this.add(values);
        return this;
    }

    public boolean add(Object ... values) {
        ConditionSet list;
        if (values == null || values.length < 1) {
            return false;
        }
        if (values.length == 1 && this.list == null && !(values[0] instanceof ChainCondition)) {
            if (values[0] instanceof PropertyChangeListener || values[0] instanceof ObjectCondition) {
                this.list = values[0];
            }
            return true;
        }
        if (this.list instanceof SimpleSet) {
            list = (ConditionSet)this.list;
        } else {
            list = values[0] instanceof PropertyChangeListener ? new SimpleSet() : new ConditionSet();
            list.with(this.list);
            this.list = list;
        }
        if (list instanceof ConditionSet) {
            for (Object condition : values) {
                if (!(condition instanceof ObjectCondition) || ((SimpleSet)list).add(new Object[]{(ObjectCondition)condition})) continue;
                return false;
            }
            return true;
        }
        return ((SimpleSet)list).add(values);
    }

    public ConditionSet getList() {
        if (this.list instanceof ConditionSet) {
            return (ConditionSet)this.list;
        }
        ConditionSet result = new ConditionSet();
        result.with(this.list);
        return result;
    }

    public ObjectCondition first() {
        Object first;
        if (this.list instanceof ObjectCondition) {
            return (ObjectCondition)this.list;
        }
        if (this.list instanceof SimpleSet && (first = ((SimpleSet)this.list).first()) instanceof ObjectCondition) {
            return (ObjectCondition)first;
        }
        return null;
    }

    public int size() {
        if (this.list == null) {
            return 0;
        }
        if (this.list instanceof Collection) {
            return ((Collection)this.list).size();
        }
        return 1;
    }

    public String toString() {
        ConditionSet templates = this.getList();
        if (templates.size() > 0) {
            CharacterBuffer buffer = new CharacterBuffer();
            for (ObjectCondition item : templates) {
                buffer.with(item.toString());
            }
            return buffer.toString();
        }
        return super.toString();
    }

    @Override
    public String[] getProperties() {
        return new String[]{CHILD};
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (!(entity instanceof ChainCondition)) {
            return false;
        }
        ChainCondition cc = (ChainCondition)entity;
        if (CHILD.equalsIgnoreCase(attribute)) {
            return cc.getList();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (!(entity instanceof ChainCondition)) {
            return false;
        }
        ChainCondition cc = (ChainCondition)entity;
        if (CHILD.equalsIgnoreCase(attribute)) {
            cc.add(value);
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(LocalisationInterface variables) {
        return this.getList().getAllValue(variables);
    }
}

