/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.TemplateParser;
import de.uniks.networkparser.list.ConditionSet;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.ChainCondition;
import de.uniks.networkparser.logic.VariableCondition;

public class ImportCondition
implements ParserCondition {
    public static final String TAG = "import";
    private ObjectCondition importExpression;

    @Override
    public String getKey() {
        return TAG;
    }

    public void parseImport(String className, SimpleList<String> imports) {
        String[] strings;
        int genericType = className.indexOf("<");
        if (genericType > 0) {
            this.parseImport(className.substring(genericType + 1, className.lastIndexOf(">")), imports);
            className = className.substring(0, genericType);
        }
        for (String importName : strings = className.split(",")) {
            imports.with(importName);
        }
    }

    @Override
    public CharSequence getValue(LocalisationInterface variables) {
        if (variables instanceof SendableEntityCreator) {
            SendableEntityCreator creator = (SendableEntityCreator)((Object)variables);
            SimpleList<String> imports = new SimpleList<String>();
            if (this.importExpression != null) {
                if (this.importExpression instanceof ChainCondition) {
                    ChainCondition cc = (ChainCondition)this.importExpression;
                    ConditionSet templates = cc.getList();
                    CharacterBuffer buffer = templates.getAllValue(variables);
                    this.parseImport(buffer.toString(), imports);
                } else if (this.importExpression instanceof VariableCondition) {
                    VariableCondition vc = (VariableCondition)this.importExpression;
                    Object buffer = vc.getValue(variables);
                    if (buffer != null) {
                        this.parseImport(buffer.toString(), imports);
                    }
                } else {
                    this.parseImport(this.importExpression.toString(), imports);
                }
            } else {
                this.parseImport(this.importExpression.toString(), imports);
            }
            if (imports.size() > 0) {
                creator.setValue(variables, "headers", imports, "new");
            }
        }
        return null;
    }

    @Override
    public boolean update(Object value) {
        if (value instanceof LocalisationInterface) {
            this.getValue((LocalisationInterface)value);
        }
        return this.importExpression != null;
    }

    @Override
    public void create(CharacterBuffer buffer, TemplateParser parser, LocalisationInterface customTemplate) {
        buffer.skip();
        ObjectCondition result = null;
        while (buffer.getCurrentChar() != '}') {
            ObjectCondition expression = parser.parsing(buffer, customTemplate, true, "}");
            if (result == null) {
                result = expression;
                continue;
            }
            if (result instanceof ChainCondition) {
                ((ChainCondition)result).with(expression);
                continue;
            }
            ChainCondition chainCondition = new ChainCondition();
            chainCondition.with(result);
            if (expression instanceof ChainCondition) {
                ChainCondition cc = (ChainCondition)expression;
                chainCondition.with(cc.getList());
            } else {
                chainCondition.with(expression);
            }
            result = chainCondition;
        }
        this.setExpression(result);
        buffer.skipChar('}');
        buffer.skipChar('}');
    }

    private boolean setExpression(ObjectCondition value) {
        if (value != this.importExpression) {
            this.importExpression = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public ImportCondition getSendableInstance(boolean prototyp) {
        return new ImportCondition();
    }

    public String toString() {
        if (this.importExpression != null) {
            return "{{#import " + this.importExpression.toString() + "}}";
        }
        return "{{#import}}";
    }
}

