/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.gui.controls;

import de.uniks.networkparser.gui.controls.Input;

public class ChoiceField
extends Input<String> {
    protected static final String CHECKBOX = "checkbox";
    protected static final String RADIO = "radio";
    protected static final String CHECKED = "checked";
    protected static final String VALUE = "value";
    public static final String ON = "on";
    public static final String OFF = "on";
    private boolean checked = false;

    public ChoiceField(boolean multi) {
        this.addBaseElements(CHECKED);
        this.type = multi ? RADIO : CHECKBOX;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean setChecked(boolean checked) {
        boolean oldValue = this.checked;
        this.checked = checked;
        boolean changed = this.firePropertyChange(CHECKED, oldValue, checked);
        if (changed) {
            this.setValue(checked ? "on" : "off");
        }
        return changed;
    }

    @Override
    public boolean setValue(String value) {
        String oldValue = (String)this.value;
        this.value = value;
        boolean changed = this.firePropertyChange(VALUE, oldValue, value);
        if (changed) {
            this.setChecked("on".equals(value));
        }
        return changed;
    }

    @Override
    public boolean setValue(String key, Object value) {
        if (CHECKED.equals(key)) {
            return this.setChecked(Boolean.valueOf("" + value));
        }
        return super.setValue(key, value);
    }

    @Override
    public Object getValue(String key) {
        if (CHECKED.equals(key)) {
            return this.checked ? CHECKED : null;
        }
        return super.getValue(key);
    }
}

