/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.list.AbstractList;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.Collection;
import java.util.Comparator;

public abstract class AbstractArray<V>
implements BaseItem {
    public static final byte ALLOWDUPLICATE = 1;
    public static final byte ALLOWEMPTYVALUE = 2;
    public static final byte VISIBLE = 4;
    public static final byte CASESENSITIVE = 8;
    public static final byte READONLY = 16;
    public static final byte MAP = 32;
    public static final byte BIDI = 64;
    public static final Integer REMOVED = -1;
    static final byte MINSIZE = 4;
    static final int MAXDELETED = 42;
    static final int MINHASHINGSIZE = 420;
    static final float MINUSEDLIST = 0.2f;
    static final float MAXUSEDLIST = 0.7f;
    static final int SMALL_KEY = 0;
    static final int BIG_KEY = 1;
    static final int DELETED = 2;
    static final int SMALL_VALUE = 3;
    static final int BIG_VALUE = 4;
    static final int SIZE_BIG = 6;
    private Class<?> type;
    int index;
    public byte flag = (byte)12;
    Object[] elements;
    int size;
    static final Object[] emptyArray = new Object[0];

    public <ST extends AbstractArray<V>> ST init(Collection<?> list) {
        if (list instanceof AbstractArray) {
            this.setFlag(((AbstractArray)((Object)list)).flag());
        }
        this.withList(list);
        return (ST)this;
    }

    public <ST extends AbstractArray<V>> ST init(int initSize) {
        if (initSize < 1) {
            return (ST)this;
        }
        this.grow(initSize);
        return (ST)this;
    }

    public <ST extends AbstractArray<V>> ST init(Object[] items, int size, int offset) {
        this.elements = items;
        this.size = size;
        this.index = offset;
        if (this.isComplex(size)) {
            this.grow(size);
        }
        return (ST)this;
    }

    public <ST extends AbstractArray<V>> ST withFlag(byte value) {
        this.setFlag((byte)(this.flag | value));
        if (value == 64) {
            this.setFlag((byte)(this.flag | 0x20));
        }
        return (ST)this;
    }

    final boolean isComplex(int size) {
        return (this.flag & 0x20) == 32 || size >= 420 || size > 6 && this.elements.length < 6;
    }

    final int getArrayFlag(int size) {
        if (size == 0) {
            return 0;
        }
        if ((this.flag & 0x40) > 0) {
            return 5;
        }
        if ((this.flag & 0x20) > 0) {
            return 4;
        }
        if (size >= 420 || size > 6 && this.elements != null && this.elements.length < 6) {
            return 3;
        }
        return 1;
    }

    public byte flag() {
        return this.flag;
    }

    @Override
    public int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isAllowEmptyValue() {
        return (this.flag & 2) != 0;
    }

    public <ST extends AbstractArray<V>> ST withAllowEmptyValue(boolean value) {
        this.setFlag((byte)(this.flag | 2));
        if (!value) {
            this.setFlag((byte)(this.flag - 2));
        }
        return (ST)this;
    }

    public void setAllowEmptyValue(boolean value) {
        this.setFlag((byte)(this.flag | 2));
        if (!value) {
            this.setFlag((byte)(this.flag - 2));
        }
    }

    public final boolean isVisible() {
        return (this.flag & 4) != 0;
    }

    public AbstractArray<V> withVisible(boolean value) {
        this.setFlag((byte)(this.flag | 4));
        if (!value) {
            this.setFlag((byte)(this.flag - 4));
        }
        return this;
    }

    public final boolean isCaseSensitive() {
        return (this.flag & 8) != 0;
    }

    public <ST extends AbstractArray<V>> ST withCaseSensitive(boolean value) {
        if (value) {
            this.setFlag((byte)(this.flag | 8));
        } else {
            this.setFlag((byte)(this.flag & 0xF7));
        }
        return (ST)this;
    }

    public final boolean isAllowDuplicate() {
        return (this.flag & 1) != 0;
    }

    public <ST extends AbstractArray<V>> ST withAllowDuplicate(boolean value) {
        if (value) {
            this.setFlag((byte)(this.flag | 1));
        } else {
            this.setFlag((byte)(this.flag & 0xFE));
        }
        return (ST)this;
    }

    public final boolean isReadOnly() {
        return (this.flag & 0x10) != 0;
    }

    public void reset() {
        this.elements = null;
        this.size = 0;
        this.index = 0;
    }

    public void clear() {
        int arrayFlag = this.getArrayFlag(this.size);
        if (arrayFlag < 1) {
            this.elements = null;
            return;
        }
        this.size = 0;
        this.index = 0;
        if (arrayFlag == 1) {
            for (int i = this.elements.length - 1; i > 0; --i) {
                this.fireProperty("rem", this.elements[i], null, this.elements[i - 1], i, null);
            }
            this.fireProperty("rem", this.elements[0], null, null, 0, null);
            this.elements = null;
            return;
        }
        Object[] items = (Object[])this.elements[0];
        if (arrayFlag > 3) {
            for (int i = items.length - 1; i > 0; --i) {
                this.fireProperty("rem", items[i], null, items[i - 1], i, ((Object[])this.elements[3])[i]);
            }
            this.fireProperty("rem", items[0], null, null, 0, ((Object[])this.elements[3])[0]);
            this.elements = null;
            return;
        }
        for (int i = items.length - 1; i > 0; --i) {
            this.fireProperty("rem", items[i], null, items[i - 1], i, null);
        }
        this.fireProperty("rem", items[0], null, null, 0, null);
        this.elements = null;
    }

    protected int hashKey(int hashKey, int len) {
        int tmp = hashKey % len;
        return tmp < 0 ? -tmp : tmp;
    }

    public Comparator<Object> comparator() {
        return null;
    }

    public boolean isComparator() {
        return false;
    }

    protected int addHashItem(int pos, Object newValue, Object[] items) {
        int hashKey = 0;
        if (newValue != null) {
            hashKey = this.hashKey(newValue.hashCode(), items.length);
        }
        while (true) {
            if (items[hashKey] == null || REMOVED.equals(items[hashKey])) {
                items[hashKey] = pos;
                return hashKey;
            }
            hashKey = (hashKey + 1) % items.length;
        }
    }

    boolean shrink(int minCapacity) {
        if (minCapacity == 0) {
            this.elements = null;
            this.index = 0;
            return true;
        }
        int arrayFlag = this.getArrayFlag(this.size);
        int newSize = minCapacity + minCapacity / 2 + 5;
        if (arrayFlag > 1) {
            if ((this.flag & 0x20) != 0) {
                boolean change = false;
                if ((float)minCapacity < (float)((Object[])this.elements[0]).length * 0.2f) {
                    this.resizeSmall(newSize, 0);
                    this.resizeSmall(newSize, 3);
                    this.index = 0;
                    change = true;
                }
                if (this.elements[1] != null) {
                    change = true;
                    this.resizeBig(newSize, 1);
                    if (this.elements.length > 4 && this.elements[4] != null) {
                        this.resizeBig(newSize, 4);
                    }
                }
                return change;
            }
            if ((float)minCapacity < (float)((Object[])this.elements[0]).length * 0.2f) {
                this.elements = (Object[])this.elements[0];
                return true;
            }
        } else if ((float)minCapacity < (float)this.elements.length * 0.2f) {
            this.resizeSmall(newSize);
            this.index = 0;
            return true;
        }
        return false;
    }

    void grow(int minCapacity) {
        int arrayFlag = this.getArrayFlag(minCapacity);
        if (this.elements == null) {
            int newSize = minCapacity + minCapacity / 2 + 5;
            if (arrayFlag == 1) {
                this.elements = new Object[newSize];
                return;
            }
            this.elements = new Object[arrayFlag];
            this.elements[0] = new Object[newSize];
            if ((this.flag & 0x20) != 0) {
                this.elements[3] = new Object[newSize];
            }
            return;
        }
        if (arrayFlag > 1 && arrayFlag != this.elements.length) {
            Object[] old = this.elements;
            this.elements = new Object[arrayFlag];
            this.elements[0] = old;
            if ((this.flag & 0x20) != 0) {
                this.elements[3] = new Object[old.length];
            }
            return;
        }
        if (this.isComplex(minCapacity)) {
            int newSize = minCapacity + minCapacity / 2 + 5;
            if (minCapacity >= ((Object[])this.elements[0]).length) {
                this.resizeSmall(newSize, 0);
                if ((this.flag & 0x20) != 0) {
                    this.resizeSmall(newSize, 3);
                }
            }
            if (minCapacity >= 420) {
                boolean size = false;
                if (this.elements[1] != null && (float)minCapacity >= (float)((Object[])this.elements[1]).length * 0.7f) {
                    this.resizeBig(newSize * 2, 1);
                    size = true;
                }
                if ((this.flag & 0x40) != 0 && this.elements[4] != null && (float)minCapacity >= (float)((Object[])this.elements[4]).length * 0.7f) {
                    this.resizeBig(newSize * 2, 4);
                    size = true;
                }
                if (size) {
                    this.elements[2] = null;
                }
            }
        } else if (this.size < 420 && minCapacity > this.elements.length) {
            int newSize = minCapacity + minCapacity / 2 + 5;
            this.resizeSmall(newSize);
        }
    }

    void resizeBig(int minCapacity, int index) {
        Object[] newItems;
        Object[] items = (Object[])this.elements[index - 1];
        this.elements[index] = newItems = new Object[minCapacity];
        int i = this.index;
        for (int pos = 0; pos < this.size; ++pos) {
            if (i == items.length) {
                i = 0;
            }
            this.addHashItem(i, items[i], newItems);
            ++i;
        }
    }

    void resizeSmall(int newCapacity, int index) {
        Object[] dest = new Object[newCapacity];
        if (this.index == 0) {
            System.arraycopy(this.elements[index], 0, dest, 0, this.size);
        } else {
            int len = ((Object[])this.elements[index]).length;
            if (this.size > len - this.index) {
                System.arraycopy(this.elements[index], this.index, dest, 0, len - this.index);
                System.arraycopy(this.elements[index], 0, dest, len - this.index, len - this.size);
            } else {
                System.arraycopy(this.elements[index], this.index, dest, 0, this.size);
            }
        }
        this.elements[index] = dest;
    }

    void resizeSmall(int newCapacity) {
        this.elements = this.arrayCopy(this.elements, newCapacity);
        this.index = 0;
    }

    Object[] arrayCopy(Object[] source, int newCapacity) {
        Object[] dest = new Object[newCapacity];
        if (source == null) {
            return null;
        }
        int end = source.length - this.index;
        if (this.size > end) {
            System.arraycopy(source, this.index, dest, 0, end);
            int len = this.size - end;
            System.arraycopy(source, 0, dest, end, len);
        } else {
            System.arraycopy(source, this.index, dest, 0, this.size);
        }
        return dest;
    }

    final int hasKey(Object element) {
        return this.hashKeyPos(element, this.size);
    }

    final int hashKeyPos(Object element, int size) {
        if (element == null || this.isReadOnly()) {
            return REMOVED;
        }
        if (this.isComparator()) {
            boolean allowDuplicate = this.isAllowDuplicate();
            for (int i = 0; i < this.size; ++i) {
                Object value = this.getKeyByIndex(i);
                int r = this.comparator().compare(value, element);
                if (r == 0) {
                    if (allowDuplicate || !value.equals(element)) continue;
                    return REMOVED;
                }
                if (r <= 0) continue;
                return i;
            }
            return this.size;
        }
        if (!this.isAllowDuplicate() && this.indexOf(element, size) >= 0) {
            return REMOVED;
        }
        return this.size;
    }

    protected int hasKeyAndPos(Object element) {
        int pos;
        if (element == null || this.isReadOnly()) {
            return REMOVED;
        }
        if (this.isComparator()) {
            for (int i = 0; i < this.size; ++i) {
                if (this.comparator().compare(this.getKeyByIndex(i), element) < 0) continue;
                return i;
            }
            return this.size;
        }
        if (!this.isAllowDuplicate() && (pos = this.indexOf(element, this.size)) >= 0) {
            return pos;
        }
        return this.size;
    }

    public Object getKeyByIndex(int index) {
        return this.getByIndex(0, index + this.index, this.size);
    }

    protected Object getByIndex(int offset, int index, int size) {
        if (size == 0) {
            return null;
        }
        if (index < 0 && (index = size + 1 + index) < 0) {
            return null;
        }
        Object[] items = (this.flag & 0x20) == 32 ? (Object[])this.elements[offset] : (this.isComplex(size) && offset != 3 ? (Object[])this.elements[offset] : this.elements);
        if (items == null) {
            return null;
        }
        if (index >= items.length) {
            index %= items.length;
        }
        return items[index];
    }

    protected int addKeyValue(int pos, Object key, Object value) {
        Object[] keys = (Object[])this.elements[0];
        Object[] values = (Object[])this.elements[3];
        if (pos == 0 && this.size > 0) {
            this.index = this.index == 0 ? keys.length - 1 : --this.index;
            pos = this.index;
        } else {
            pos = (this.index + pos) % keys.length;
            int i = (this.size() + this.index) % keys.length;
            while (i > pos) {
                keys[i] = keys[i - 1];
                values[i--] = values[i];
            }
        }
        keys[pos] = key;
        values[pos] = value;
        Object beforeKey = this.getByIndex(0, this.size, this.size);
        ++this.size;
        if (this.isComplex(this.size)) {
            if (this.elements[1] != null) {
                this.addHashItem(pos, key, (Object[])this.elements[1]);
            }
            if ((this.flag & 0x40) == 64 && this.elements[4] != null) {
                this.addHashItem(pos, value, (Object[])this.elements[4]);
            }
        }
        this.fireProperty("new", null, key, beforeKey, pos, value);
        return pos;
    }

    public Class<?> getTypClass() {
        return this.type;
    }

    public <ST extends AbstractArray<V>> ST withType(Class<?> type) {
        this.type = type;
        return (ST)this;
    }

    final int addKey(int pos, Object element, int size) {
        Object[] keys;
        if (this.type != null) {
            if (!this.type.isAssignableFrom(element.getClass())) {
                return -1;
            }
        } else if (this.getTypClass() != null) {
            this.type = this.getTypClass();
            if (!this.type.isAssignableFrom(element.getClass())) {
                return -1;
            }
        }
        if (this.isComplex(size)) {
            keys = (Object[])this.elements[0];
            if (this.elements[1] != null) {
                int newPos = this.retransformIndex(pos, size);
                this.addHashItem(newPos, element, (Object[])this.elements[1]);
            }
        } else {
            keys = this.elements;
        }
        if (pos == 0 && this.size > 0) {
            this.index = this.index == 0 ? keys.length - 1 : --this.index;
            pos = this.index;
        } else if (this.size != pos || this.index != 0) {
            pos = (this.index + pos) % keys.length;
            int sizePos = (this.index + this.size) % keys.length;
            while (sizePos != pos) {
                if (sizePos == 0) {
                    keys[sizePos] = keys[keys.length - 1];
                    sizePos = keys.length - 1;
                    continue;
                }
                keys[sizePos--] = keys[sizePos];
            }
        }
        keys[pos] = element;
        Object beforeElement = null;
        ++this.size;
        if (pos > 0) {
            beforeElement = this.getByIndex(0, pos - 1, size);
        }
        this.fireProperty("new", null, element, beforeElement, pos, null);
        return pos;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if ((this.flag & 0x40) > 0) {
            sb.append("BIDI-Map ");
        } else if ((this.flag & 0x20) > 0) {
            sb.append("Map ");
        } else {
            sb.append("LIST ");
        }
        if (this.isAllowDuplicate()) {
            sb.append("AllowDuplicate ");
        }
        if (this.isVisible()) {
            sb.append("Visible ");
        }
        if (this.isReadOnly()) {
            sb.append("ReadOnly ");
        }
        if (this.isCaseSensitive()) {
            sb.append("CaseSensitive ");
        }
        sb.append('(').append(this.size).append(')');
        if (this.size == 1) {
            sb.append(' ').append('[');
            sb.append(this.get(0).toString());
            sb.append(']');
        }
        return sb.toString();
    }

    public <ST extends AbstractArray<V>> ST with(Object ... values) {
        this.add(values);
        return (ST)this;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return false;
        }
        int newSize = this.size + values.length;
        this.grow(newSize);
        boolean changed = false;
        for (Object value : values) {
            int pos;
            if (value == null || (pos = this.hashKeyPos(value, newSize)) < 0) continue;
            this.addKey(pos, value, newSize);
            changed = true;
        }
        return changed;
    }

    public <ST extends AbstractArray<V>> ST without(Object ... values) {
        if (values == null) {
            return (ST)this;
        }
        for (Object value : values) {
            this.removeByObject(value);
        }
        return (ST)this;
    }

    protected Object setValue(int pos, Object value, int offset) {
        if (pos >= this.size) {
            this.grow(pos + 1);
        }
        Object[] items = this.getArrayFlag(this.size) > 1 ? (Object[])this.elements[offset] : this.elements;
        Object oldValue = items[pos];
        items[pos] = value;
        Object beforeElement = null;
        if (pos > 0) {
            beforeElement = items[pos - 1];
        }
        this.fireProperty("upd", oldValue, value, beforeElement, pos, null);
        return oldValue;
    }

    public AbstractArray<V> withList(Collection<?> list) {
        if (list == null || this.size + list.size() == 0) {
            return this;
        }
        int newSize = this.size + list.size();
        this.grow(newSize);
        if (!this.isAllowDuplicate()) {
            for (Object item : list) {
                if (this.indexOf(item, newSize) >= 0) continue;
                this.addKey(this.size, item, newSize);
            }
        } else {
            for (Object item : list) {
                int pos = this.hashKeyPos(item, newSize);
                if (pos < 0) continue;
                this.addKey(pos, item, newSize);
            }
        }
        return this;
    }

    public int indexOf(Object o) {
        return this.indexOf(o, this.size);
    }

    int indexOf(Object o, int size) {
        if (o == null || this.elements == null) {
            return REMOVED;
        }
        if ((this.flag & 0x20) == 32) {
            return this.search((Object[])this.elements[0], o);
        }
        if (this.isComplex(size)) {
            return this.getPosition(o, 0, false);
        }
        return this.search(this.elements, o);
    }

    int search(Object[] items, Object o) {
        int pos = this.index;
        if (pos == 0) {
            while (pos < this.size) {
                if (this.checkValue(o, items[pos])) {
                    return pos;
                }
                ++pos;
            }
            return REMOVED;
        }
        for (int i = 0; i < this.size; ++i) {
            if (pos == items.length) {
                pos = 0;
            }
            if (this.checkValue(o, items[pos])) {
                return i;
            }
            ++pos;
        }
        return REMOVED;
    }

    public int lastIndexOf(Object o) {
        if (o == null) {
            return REMOVED;
        }
        if (this.size > 420) {
            return this.getPosition(o, 0, true);
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!o.equals(this.get(i))) continue;
            return i;
        }
        return REMOVED;
    }

    public int getPositionKey(Object o, boolean last) {
        if (!this.isComplex(this.size)) {
            if (last) {
                return this.lastIndexOf(o);
            }
            return this.indexOf(o);
        }
        return this.getPosition(o, 0, last);
    }

    private int transformIndex(int index, int size) {
        if (this.elements[2] != null) {
            Object[] items = (Object[])this.elements[2];
            for (int i = 0; i < items.length && (Integer)items[i] <= index; --index, ++i) {
            }
        }
        if (index < 0) {
            index += size;
        }
        return index;
    }

    private int retransformIndex(int index, int size) {
        if (this.elements[2] != null) {
            Object[] items = (Object[])this.elements[2];
            for (int i = 0; i < items.length && (Integer)items[i] <= index; ++index, ++i) {
            }
        }
        return index;
    }

    int getPosition(Object o, int offset, boolean last) {
        Object[] hashCodes;
        if (o == null || this.elements == null) {
            return REMOVED;
        }
        if (this.elements[offset + 1] != null) {
            hashCodes = (Object[])this.elements[offset + 1];
        } else {
            int len = ((Object[])this.elements[offset]).length;
            this.resizeBig(len * 2, offset + 1);
            hashCodes = (Object[])this.elements[offset + 1];
        }
        int index = this.hashKey(o.hashCode(), hashCodes.length);
        if (hashCodes[index] == null) {
            return REMOVED;
        }
        int len = ((Object[])this.elements[offset]).length;
        int indexItem = -1;
        int lastIndex = -1;
        while (hashCodes[index] != null) {
            if (REMOVED.equals(hashCodes[index])) {
                index = (index + 1) % hashCodes.length;
                continue;
            }
            indexItem = this.transformIndex((Integer)hashCodes[index], len);
            if (this.checkValue(o, this.getByIndex(offset, indexItem, this.size))) {
                if (!last) break;
                lastIndex = indexItem;
            } else if (lastIndex > 0) break;
            index = (index + 1) % hashCodes.length;
        }
        if (last) {
            return lastIndex;
        }
        if (hashCodes[index] == null) {
            return REMOVED;
        }
        return indexItem;
    }

    protected boolean checkValue(Object a, Object b) {
        if (!this.isCaseSensitive() && a instanceof String && b instanceof String) {
            return ((String)a).equalsIgnoreCase((String)b);
        }
        return a.equals(b);
    }

    public boolean contains(Object o) {
        return this.indexOf(o, this.size) >= 0;
    }

    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            return true;
        }
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Object ... keys) {
        if (keys == null) {
            return true;
        }
        for (Object e : keys) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        for (Object i : c) {
            if (!this.contains(i)) continue;
            this.removeByObject(i);
            modified = true;
        }
        return modified;
    }

    public int removeByObject(Object key) {
        int index = this.indexOf(key, this.size);
        if (index < 0) {
            return REMOVED;
        }
        this.removeByIndex(index, 0, this.index);
        return index;
    }

    protected Object removeByIndex(int index, int offset, int offsetIndex) {
        Object item = this.removeItem(index, offset, offsetIndex);
        if (item != null) {
            --this.size;
            if (!this.shrink(this.size)) {
                if (offsetIndex == index) {
                    return item;
                }
                if (this.size >= 420) {
                    if (this.elements[2] == null) {
                        this.elements[2] = new Integer[]{index};
                    } else {
                        int i;
                        Integer[] oldPos = (Integer[])this.elements[2];
                        for (i = 0; i < oldPos.length && oldPos[i] <= index; ++i) {
                        }
                        Integer[] positions = new Integer[((Object[])this.elements[2]).length + 1];
                        System.arraycopy(oldPos, 0, positions, 0, i);
                        positions[i] = index;
                        System.arraycopy(oldPos, i, positions, i + 1, positions.length - i - 1);
                        this.elements[2] = positions;
                    }
                }
            }
        }
        return item;
    }

    protected Object removeItem(int index, int offset, int oldIndex) {
        int len;
        int indexPos;
        Object[] hashCodes;
        if (this.elements == null) {
            return null;
        }
        int complex = this.getArrayFlag(this.size);
        Object[] items = complex > 1 ? (Object[])this.elements[offset] : this.elements;
        Object oldValue = items[index = (index + oldIndex) % items.length];
        if (oldValue == null) {
            return null;
        }
        if (complex > 1 && complex > offset + 1 && this.elements[offset + 1] != null && (hashCodes = (Object[])this.elements[offset + 1])[indexPos = this.hashKey(oldValue.hashCode(), hashCodes.length)] != null) {
            int indexHash = (Integer)hashCodes[indexPos];
            int pos = this.transformIndex(indexHash, items.length);
            while (pos != index && hashCodes[indexPos = (indexPos + 1) % hashCodes.length] != null) {
                indexHash = (Integer)hashCodes[indexPos];
                if (indexHash == REMOVED) continue;
                pos = this.transformIndex(indexHash, items.length);
            }
            if (pos == index) {
                hashCodes[indexPos] = -1;
            }
        }
        if (index == oldIndex) {
            items[index] = null;
            if (offset == 0) {
                ++this.index;
                if (this.index == items.length) {
                    this.index = 0;
                }
            }
            return oldValue;
        }
        if ((this.index + this.size - 1) % items.length == index) {
            items[index] = null;
        } else if (index > this.index) {
            int end = this.index + this.size - 1;
            if (end >= items.length) {
                len = items.length - index - 1;
                System.arraycopy(items, index + 1, items, index, len);
                items[items.length - 1] = items[0];
                System.arraycopy(items, 1, items, 0, end %= items.length);
                items[end] = null;
            } else {
                System.arraycopy(items, index + 1, items, index, end - index);
                items[end] = null;
            }
        } else {
            int end = (this.index + this.size - 1) % items.length;
            len = end - index;
            System.arraycopy(items, index + 1, items, index, len);
            items[index + len] = null;
        }
        return oldValue;
    }

    public Object[] toArray() {
        if (this.elements == null) {
            return emptyArray;
        }
        if (this.isComplex(this.size)) {
            return this.arrayCopy((Object[])this.elements[0], this.size);
        }
        return this.arrayCopy(this.elements, this.size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(Object key) {
        Object child;
        int len;
        int pos = this.indexOf(key);
        if (pos >= 0) {
            if ((this.flag & 0x20) != 32) return this.getByIndex(0, pos, this.size);
            return this.getByIndex(3, pos + this.index, this.size);
        }
        if (!(key instanceof String)) {
            return null;
        }
        String keyString = "" + key;
        int end = 0;
        int id = 0;
        for (len = 0; len < keyString.length(); ++len) {
            char temp = keyString.charAt(len);
            if (temp == '[') {
                for (end = len + 1; end < keyString.length(); ++end) {
                    temp = keyString.charAt(end);
                    if (keyString.charAt(end) == ']') {
                        ++end;
                        break;
                    }
                    if (temp > '/' && temp < ':' && id >= 0) {
                        id = id * 10 + temp - 48;
                        continue;
                    }
                    if (temp != 'L') continue;
                    id = -2;
                }
                if (end != keyString.length()) break;
                end = 0;
                break;
            }
            if (temp != '.') continue;
            end = len;
            id = -1;
            break;
        }
        if (end == 0 && len == keyString.length()) {
            id = -1;
        }
        if ((child = (this.flag & 0x20) == 0 ? this.getByIndex(0, id + this.index, this.size) : this.getByIndex(3, this.indexOf(keyString.substring(0, len)) + this.index, this.size)) == null) return null;
        if (end == 0) {
            if (id < 0 && id != -2) return child;
            if (!(child instanceof AbstractList)) return null;
            AbstractList list = (AbstractList)child;
            if (id == -2) {
                id = list.size() - 1;
            }
            if (list.size() < id) return null;
            return list.get(id);
        }
        if ((id >= 0 || id == -2) && child instanceof AbstractList) {
            if (end == len + 2) {
                BaseItem result = this.getNewList(true);
                AbstractList items = (AbstractList)child;
                for (int z = 0; z < items.size(); ++z) {
                    result.add(((AbstractList)items.get(z)).getValue(keyString.substring(end + 1)));
                }
                return result;
            }
            AbstractList list = (AbstractList)child;
            if (id == -2) {
                id = list.size() - 1;
            }
            if (list.size() >= id) {
                return ((SimpleKeyValueList)list.get(id)).getValue(keyString.substring(end + 1));
            }
        }
        if (!(child instanceof AbstractArray)) return null;
        return ((AbstractArray)child).getValue(keyString.substring(end + 1));
    }

    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        boolean modified = false;
        SimpleIterator it = new SimpleIterator(this);
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public <T> T[] toArray(T[] a) {
        if (a == null) {
            return null;
        }
        Object[] elementData = this.isComplex(this.size) ? (Object[])this.elements[0] : this.elements;
        if (elementData == null) {
            return a;
        }
        if (a.length < this.size) {
            return null;
        }
        System.arraycopy(elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public V get(int index) {
        return (V)this.getByIndex(0, index + this.index, this.size);
    }

    public V first() {
        if (this.size() > 0) {
            return this.get(0);
        }
        return null;
    }

    public V last() {
        if (this.size() > 0) {
            return this.get(this.size() - 1);
        }
        return null;
    }

    @Override
    public abstract BaseItem getNewList(boolean var1);

    public BaseItem subList(int fromIndex, int toIndex) {
        BaseItem newInstance = this.getNewList(false);
        if (fromIndex < 0) {
            fromIndex += this.size;
        }
        if (toIndex > this.size() || toIndex == 0) {
            toIndex = this.size();
        }
        if (fromIndex < 0 || fromIndex > toIndex) {
            return newInstance;
        }
        while (fromIndex < toIndex) {
            newInstance.add(this.get(fromIndex++));
        }
        return newInstance;
    }

    public <ST extends AbstractArray<V>> ST withSize(int size) {
        if (size < this.size) {
            this.shrink(size);
        } else {
            this.grow(size);
        }
        return (ST)this;
    }

    public void pack() {
        if (this.elements == null) {
            return;
        }
        boolean complex = this.isComplex(this.size);
        if ((this.flag & 0x20) == 0) {
            this.elements = complex ? this.arrayCopy((Object[])this.elements[0], this.size) : this.arrayCopy(this.elements, this.size);
            this.index = 0;
            return;
        }
        this.elements[0] = this.arrayCopy((Object[])this.elements[0], this.size);
        this.elements[1] = null;
        this.elements[2] = null;
        this.elements[3] = this.arrayCopy((Object[])this.elements[3], this.size);
        if (this.elements.length > 4) {
            this.elements[4] = null;
        }
        this.index = 0;
    }

    protected boolean fireProperty(String type, Object oldElement, Object newElement, Object beforeElement, int index, Object value) {
        return true;
    }

    public boolean move(int from, int to) {
        if (from == to) {
            return true;
        }
        if (from < 0 || to < 0 || from > this.size() || to > this.size()) {
            return false;
        }
        if ((this.flag & 0x20) != 0) {
            Object[] keys = (Object[])this.elements[0];
            Object[] values = (Object[])this.elements[3];
            Object temp = keys[from];
            keys[from] = keys[to];
            keys[to] = temp;
            temp = values[from];
            values[from] = values[to];
            values[to] = temp;
            this.elements[1] = null;
            this.elements[2] = null;
            if (this.elements.length > 4) {
                this.elements[4] = null;
            }
        } else if (this.isComplex(this.size())) {
            Object[] keys = (Object[])this.elements[0];
            Object temp = keys[from];
            keys[from] = keys[to];
            keys[to] = temp;
            this.elements[1] = null;
            this.elements[2] = null;
        } else {
            Object temp = this.elements[from];
            this.elements[from] = this.elements[to];
            this.elements[to] = temp;
        }
        return true;
    }

    protected String parseItem(EntityStringConverter converter) {
        return "";
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        if (converter instanceof EntityStringConverter) {
            return this.parseItem((EntityStringConverter)converter);
        }
        return converter.encode(this);
    }

    public boolean setFlag(byte value) {
        if (value != this.flag) {
            this.flag = value;
            return true;
        }
        return false;
    }

    public void replaceAllValues(Object key, String search, String replace) {
        for (int i = 0; i < this.size(); ++i) {
            V item = this.get(i);
            if (!(item instanceof AbstractArray)) continue;
            ((AbstractArray)item).replaceAllValues(key, search, replace);
        }
    }
}

