/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.list.SimpleKeyValueList;

public class DataTypeMap
extends DataType {
    private DataType genericKey;
    private DataType genericValue;

    DataTypeMap() {
        super(SimpleKeyValueList.class.getName());
        this.value.withExternal(true);
    }

    public static DataTypeMap create(Clazz key, Clazz value) {
        DataTypeMap result = new DataTypeMap().withGenericKey(DataType.create(key)).withGenericValue(DataType.create(value));
        return result;
    }

    public static DataTypeMap create(String key, String value) {
        DataTypeMap result = new DataTypeMap().withGenericKey(DataType.create(key)).withGenericValue(DataType.create(value));
        return result;
    }

    public static DataTypeMap create(DataType key, DataType value) {
        DataTypeMap result = new DataTypeMap().withGenericKey(key).withGenericValue(value);
        return result;
    }

    private DataTypeMap withGenericKey(DataType key) {
        this.genericKey = key;
        return this;
    }

    private DataTypeMap withGenericValue(DataType value) {
        this.genericValue = value;
        return this;
    }

    public DataType getGenericKey() {
        return this.genericKey;
    }

    public DataType getGenericValue() {
        return this.genericValue;
    }

    @Override
    public String getName(boolean shortName) {
        if (this.value == null) {
            return null;
        }
        return this.value.getName(shortName) + "<" + this.genericKey.getInternName(shortName, false) + "," + this.genericValue.getInternName(shortName, false) + ">";
    }

    @Override
    protected String getInternName(boolean shortName, boolean primitivAllow) {
        if (this.value == null) {
            return null;
        }
        return this.value.getName(shortName) + "<" + this.genericKey.getInternName(shortName, primitivAllow) + "," + this.genericValue.getInternName(shortName, primitivAllow) + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataTypeMap)) {
            return false;
        }
        if (obj.hashCode() == this.hashCode()) {
            return true;
        }
        DataTypeMap otherDTM = (DataTypeMap)obj;
        if (this.genericKey == null ? otherDTM.getGenericKey() != null : !otherDTM.getGenericKey().equals(this.genericKey)) {
            return false;
        }
        if (this.genericValue == null) {
            return otherDTM.getGenericValue() == null;
        }
        return otherDTM.getGenericValue().equals(this.genericValue);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

