/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.BufferItem;
import de.uniks.networkparser.list.SimpleList;

public abstract class Buffer
implements BufferItem {
    public static final String STOPCHARSJSON = ",:]}/\\\"[{;=# ";
    public static final String STOPCHARSXML = ",]}/\\\"[{;=# ";
    public static final char[] STOPCHARSXMLEND = new char[]{'\"', ',', ']', '}', '/', '\\', '\"', '[', '{', ';', '=', '#', '>', '\r', '\n', ' '};
    protected int position;

    public short getShort() {
        byte[] bytes = this.array(2, false);
        short result = bytes[0];
        result = (short)(result << 8 + bytes[1]);
        return result;
    }

    public int getInt() {
        byte[] bytes = this.array(4, false);
        return (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + bytes[3];
    }

    public long getLong() {
        byte[] bytes = this.array(8, false);
        long result = bytes[0];
        result <<= 8 + bytes[1];
        result <<= 8 + bytes[2];
        result <<= 8 + bytes[3];
        result <<= 8 + bytes[4];
        result <<= 8 + bytes[5];
        result <<= 8 + bytes[6];
        return result <<= 8 + bytes[7];
    }

    public float getFloat() {
        int asInt = this.getInt();
        return Float.intBitsToFloat(asInt);
    }

    public double getDouble() {
        long asLong = this.getLong();
        return Double.longBitsToDouble(asLong);
    }

    @Override
    public byte[] array(int len, boolean current) {
        if (len == -1) {
            len = this.remaining();
        } else if (len == -2) {
            len = this.length();
        }
        if (len < 0) {
            return null;
        }
        byte[] result = new byte[len];
        int start = 0;
        if (current) {
            if (len > 0 && this.position < 0) {
                this.position = 0;
            }
            result[0] = (byte)this.getCurrentChar();
            start = 1;
        }
        for (int i = start; i < len; ++i) {
            result[i] = this.getByte();
        }
        return result;
    }

    @Override
    public byte getByte() {
        return (byte)this.getChar();
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int remaining() {
        return this.length() - this.position() - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public boolean isEnd() {
        return this.position() >= this.length();
    }

    @Override
    public CharacterBuffer getString(int len) {
        CharacterBuffer result = new CharacterBuffer();
        if (len < 1) {
            return result;
        }
        result.withBufferLength(len);
        result.with(this.getCurrentChar());
        for (int i = 1; i < len; ++i) {
            result.with(this.getChar());
            if (this.isEnd()) break;
        }
        return result;
    }

    public CharacterBuffer readLine() {
        CharacterBuffer line = new CharacterBuffer();
        char character = this.getCurrentChar();
        while (character != '\r' && character != '\n' && character != '\u0000') {
            line.with(character);
            character = this.getChar();
        }
        if (character == '\r') {
            character = this.getChar();
        }
        if (character == '\n') {
            this.skip();
        }
        return line;
    }

    @Override
    public char nextClean(boolean currentValid) {
        if (this.position < 0) {
            this.position = 0;
        }
        char c = this.getCurrentChar();
        if (currentValid && c > ' ') {
            return c;
        }
        while ((c = this.getChar()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    @Override
    public CharacterBuffer nextString(char ... quotes) {
        if (quotes == null) {
            quotes = new char[]{'\"'};
        }
        return this.nextString(new CharacterBuffer(), false, false, quotes);
    }

    @Override
    public CharacterBuffer nextString(CharacterBuffer sc, boolean allowQuote, boolean nextStep, char ... quotes) {
        if (this.getCurrentChar() == '\u0000' || quotes == null) {
            return sc;
        }
        char c = this.getCurrentChar();
        int i = 0;
        for (i = 0; i < quotes.length && c != quotes[i]; ++i) {
        }
        if (i < quotes.length) {
            if (nextStep) {
                this.skip();
            }
            return sc;
        }
        this.parseString(sc, allowQuote, nextStep, quotes);
        return sc;
    }

    protected CharacterBuffer parseString(CharacterBuffer sc, boolean allowQuote, boolean nextStep, char ... quotes) {
        char c;
        sc.with(this.getCurrentChar());
        if (quotes == null) {
            return sc;
        }
        int b = 0;
        boolean isQuote = false;
        int quoteLen = quotes.length;
        do {
            c = this.getChar();
            int i = quoteLen;
            switch (c) {
                case '\u0000': {
                    return sc;
                }
            }
            if (b == 92) {
                if (allowQuote) {
                    sc.with(c);
                    if (c == '\\') {
                        c = '\u0001';
                    }
                    b = c;
                    c = '\u0001';
                    continue;
                }
                if (c == '\\') {
                    c = '\u0001';
                }
                isQuote = true;
            }
            for (i = 0; i < quoteLen && c != quotes[i]; ++i) {
            }
            if (i == quoteLen) {
                sc.with(c);
            }
            b = c;
            if (i >= quoteLen) continue;
            c = '\u0000';
        } while (c != '\u0000');
        if (nextStep) {
            this.skip();
        }
        if (isQuote) {
            sc.remove(sc.length() - 1);
        }
        return sc;
    }

    protected CharacterBuffer nextValue(char c, boolean allowDuppleMark) {
        CharacterBuffer sb = new CharacterBuffer();
        if (allowDuppleMark) {
            while (c >= ' ' && STOPCHARSXML.indexOf(c) < 0) {
                sb.with(c);
                c = this.getChar();
            }
        } else {
            while (c >= ' ' && STOPCHARSJSON.indexOf(c) < 0) {
                sb.with(c);
                c = this.getChar();
            }
        }
        return sb.trim();
    }

    @Override
    public Object nextValue(BaseItem creator, boolean allowQuote, boolean allowDuppleMark, char c) {
        CharacterBuffer value;
        block11: {
            value = this.nextValue(c, allowDuppleMark);
            if (value.length() < 1) {
                return null;
            }
            if (value.equals("")) {
                return value;
            }
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            if (value.equalsIgnoreCase("null")) {
                return null;
            }
            char b = value.charAt(0);
            if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
                try {
                    if (value.indexOf(46) > -1 || value.indexOf(101) > -1 || value.indexOf(69) > -1) {
                        Double d = Double.valueOf(value.toString());
                        if (!d.isInfinite() && !d.isNaN()) {
                            return d;
                        }
                        break block11;
                    }
                    Long myLong = Long.valueOf(value.toString());
                    if (myLong == (long)myLong.intValue()) {
                        return myLong.intValue();
                    }
                    return myLong;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return value;
    }

    @Override
    public boolean skipTo(char search, boolean notEscape) {
        int len = this.length();
        char lastChar = '\u0000';
        if (this.position() > 0 && this.position() < len) {
            lastChar = this.getCurrentChar();
        }
        while (this.position() < len) {
            char currentChar = this.getCurrentChar();
            if (!(currentChar != search || notEscape && lastChar == '\\')) {
                return true;
            }
            lastChar = currentChar;
            this.skip();
        }
        return false;
    }

    @Override
    public boolean skipTo(String search, boolean order, boolean notEscape) {
        char[] character = search.toCharArray();
        int z = 0;
        int strLen = character.length;
        int len = this.length();
        char lastChar = '\u0000';
        if (this.position() > 0 && this.position() < len) {
            lastChar = this.getCurrentChar();
        }
        while (this.position() < len) {
            char currentChar = this.getCurrentChar();
            if (order) {
                if (currentChar == character[z]) {
                    if (++z >= strLen) {
                        return true;
                    }
                } else {
                    z = 0;
                }
            } else {
                for (char zeichen : character) {
                    if (currentChar != zeichen || notEscape && lastChar == '\\') continue;
                    return true;
                }
            }
            lastChar = currentChar;
            this.skip();
        }
        return false;
    }

    @Override
    public boolean skip(int pos) {
        while (pos > 0) {
            if (this.getChar() == '\u0000') {
                return false;
            }
            --pos;
        }
        return true;
    }

    @Override
    public boolean skip() {
        return this.getChar() != '\u0000';
    }

    @Override
    public CharacterBuffer nextToken(boolean current, char ... stopWords) {
        this.nextClean(current);
        CharacterBuffer characterBuffer = new CharacterBuffer();
        char c = this.getCurrentChar();
        for (int i = 0; i < stopWords.length; ++i) {
            if (stopWords[i] != c) continue;
            return characterBuffer;
        }
        this.parseString(characterBuffer, true, false, stopWords);
        return characterBuffer;
    }

    @Override
    public boolean checkValues(char ... items) {
        char current = this.getCurrentChar();
        for (char item : items) {
            if (current != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public SimpleList<String> getStringList() {
        SimpleList<String> list = new SimpleList<String>();
        CharacterBuffer sc = new CharacterBuffer();
        do {
            sc.reset();
            this.nextString(sc, true, true, '\"');
            if (sc.length() <= 0) continue;
            if (sc.indexOf(34) >= 0) {
                list.add("\"" + sc + "\"");
                continue;
            }
            list.add(sc.toString());
        } while (sc.length() > 0);
        return list;
    }

    @Override
    public SimpleList<String> splitStrings(String value, boolean split) {
        String[] values;
        SimpleList<String> result = new SimpleList<String>();
        if (value.startsWith("\"") && value.endsWith("\"")) {
            result.add(value.substring(1, value.length() - 1));
            return result;
        }
        for (String item : values = value.split(" ")) {
            result.add(item);
        }
        return result;
    }

    @Override
    public char skipChar(char ... quotes) {
        boolean found;
        char c = this.getCurrentChar();
        if (quotes == null) {
            return c;
        }
        do {
            found = false;
            for (int i = 0; i < quotes.length; ++i) {
                if (quotes[i] != c) continue;
                found = true;
                break;
            }
            c = this.getChar();
        } while (!found && c != '\u0000');
        return c;
    }
}

