/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.list.SortedSet;
import de.uniks.networkparser.parser.TemplateResultFragment;
import java.util.Collection;

public class TemplateResultFile
extends SortedSet<TemplateResultFragment>
implements SendableEntityCreator,
LocalisationInterface {
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_CHILD = "child";
    public static final String PROPERTY_MEMBER = "member";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_HEADERS = "headers";
    private String name;
    private String postfix;
    private String extension;
    private String path;
    private SendableEntityCreator parent;
    private GraphEntity member;

    TemplateResultFile() {
        super(true);
    }

    public TemplateResultFile(Clazz clazz, boolean comparator) {
        super(comparator);
        this.withName(clazz);
        this.withMember(clazz);
    }

    public TemplateResultFile(Clazz clazz, String name, boolean comparator) {
        super(comparator);
        this.withName(name);
        this.withMember(clazz);
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        CharacterBuffer buffer = new CharacterBuffer();
        if (this.path != null) {
            buffer.with(this.path);
            buffer.with('/');
        }
        buffer.with(this.name);
        buffer.with(this.postfix);
        buffer.with('.');
        buffer.with(this.extension);
        return buffer.toString();
    }

    public TemplateResultFile withName(String name) {
        this.name = name;
        return this;
    }

    public TemplateResultFile withName(Clazz clazz) {
        this.name = clazz.getName().replace(".", "/");
        return this;
    }

    public TemplateResultFile withPostfix(String value) {
        this.postfix = value;
        return this;
    }

    public TemplateResultFile withExtension(String value) {
        this.extension = value;
        return this;
    }

    public TemplateResultFile withPath(String value) {
        this.path = value;
        return this;
    }

    public boolean addChild(SendableEntityCreator child) {
        TemplateResultFragment fragment;
        if (!this.isComparator() && child instanceof TemplateResultFragment && (fragment = (TemplateResultFragment)child).getKey() == 3) {
            super.add(0, fragment);
            return true;
        }
        if (!super.add(new Object[]{child})) {
            return false;
        }
        child.setValue(child, PROPERTY_PARENT, this, "new");
        return true;
    }

    @Override
    public String getText(CharSequence label, Object model, Object gui) {
        return null;
    }

    @Override
    public String put(String label, Object object) {
        return null;
    }

    public boolean setParent(SendableEntityCreator value) {
        if (value != this.parent) {
            this.parent = value;
            return true;
        }
        return false;
    }

    public SendableEntityCreator getParent() {
        return this.parent;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new TemplateResultFile();
    }

    @Override
    public String[] getProperties() {
        return new String[]{PROPERTY_NAME, PROPERTY_PARENT};
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (!(entity instanceof TemplateResultFile)) {
            return null;
        }
        TemplateResultFile element = (TemplateResultFile)entity;
        int pos = attribute.indexOf(46);
        String attrName = pos > 0 ? attribute.substring(0, pos) : attribute;
        if (PROPERTY_PARENT.equalsIgnoreCase(attrName)) {
            if (pos > 0) {
                return element.getParent().getValue(element, attribute.substring(pos + 1));
            }
            return element.getParent();
        }
        if (PROPERTY_MEMBER.equalsIgnoreCase(attrName)) {
            GraphEntity member = element.getMember();
            if (pos > 0) {
                return member.getValue(attribute.substring(pos + 1));
            }
            return member;
        }
        if (PROPERTY_HEADERS.equalsIgnoreCase(attrName)) {
            SimpleSet<String> headers = new SimpleSet<String>();
            for (TemplateResultFragment child : this) {
                headers.addAll((Collection<String>)child.getHeaders());
            }
            return headers;
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (PROPERTY_PARENT.equalsIgnoreCase(attribute)) {
            return this.setParent((SendableEntityCreator)value);
        }
        if (PROPERTY_CHILD.equalsIgnoreCase(attribute)) {
            return this.addChild((SendableEntityCreator)value);
        }
        return false;
    }

    @Override
    public String toString() {
        CharacterBuffer buffer = new CharacterBuffer();
        for (TemplateResultFragment fragment : this) {
            if (fragment.getKey() == 0) continue;
            if (fragment.getKey() == 2) {
                fragment.update();
            }
            buffer.with(fragment.getValue());
        }
        return buffer.toString();
    }

    public GraphEntity getMember() {
        return this.member;
    }

    public TemplateResultFile withMember(GraphEntity member) {
        this.member = member;
        return this;
    }
}

