/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import de.uniks.networkparser.interfaces.UpdateListener;

public class Filter {
    public static final String MERGE = "merge";
    public static final String COLLISION = "collision";
    public static final String PRIO = "prio";
    protected UpdateListener idFilter;
    protected UpdateListener convertable;
    protected UpdateListener property;
    protected boolean full;
    private String strategy = "new";

    public Filter withIdFilter(UpdateListener idFilter) {
        this.idFilter = idFilter;
        return this;
    }

    public boolean isId(Object entity, String className, IdMap map) {
        if (this.idFilter != null) {
            return this.idFilter.update(new SimpleEvent("new", null, map, className, null, entity));
        }
        SendableEntityCreator creator = map.getCreator(className, true);
        if (creator != null) {
            return !(creator instanceof SendableEntityCreatorNoIndex);
        }
        return true;
    }

    public boolean isFullSeriation() {
        return this.full;
    }

    public Filter withFull(boolean value) {
        this.full = value;
        return this;
    }

    public Filter withPropertyRegard(UpdateListener property) {
        this.property = property;
        return this;
    }

    public Filter withConvertable(UpdateListener convertable) {
        this.convertable = convertable;
        return this;
    }

    boolean isPropertyRegard(Object entity, String property, Object value, IdMap map, int deep) {
        if (this.property != null) {
            return this.property.update(new SimpleEvent(this.strategy, (BaseItem)map, property, (Object)null, value, deep, entity));
        }
        return true;
    }

    boolean isConvertable(Object entity, String property, Object value, IdMap map, int deep) {
        if (this.convertable != null) {
            return this.convertable.update(new SimpleEvent(this.strategy, (BaseItem)map, property, (Object)null, value, deep, entity));
        }
        return true;
    }

    public static Filter regard(UpdateListener convertable) {
        return new Filter().withPropertyRegard(convertable);
    }

    public static Filter convertable(UpdateListener convertable) {
        return new Filter().withConvertable(convertable);
    }

    public String[] getProperties(SendableEntityCreator creator) {
        return creator.getProperties();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public Filter withStrategy(String strategy) {
        this.strategy = strategy;
        return this;
    }
}

