/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.json;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SortedList;
import java.util.Iterator;

public class JsonArray
extends SortedList<Object>
implements EntityList {
    public JsonArray getJSONArray(int index) {
        Object object = this.get(index);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        JsonArray returnValue = new JsonArray();
        if (object != null) {
            returnValue.add(object);
        }
        return returnValue;
    }

    public JsonObject getJSONObject(int index) {
        Object object = this.get(index);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        if (object instanceof String) {
            return new JsonObject().withValue("" + object);
        }
        throw new RuntimeException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public String getString(int index) {
        Object object = this.get(index);
        if (object instanceof String) {
            return (String)object;
        }
        throw new RuntimeException("JSONArray[" + index + "] is not a String.");
    }

    public JsonObject toJSONObject(JsonArray names) {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JsonObject jo = new JsonObject();
        for (int i = 0; i < names.size(); ++i) {
            jo.put("" + names.getKeyByIndex(i), this.get(i));
        }
        return jo;
    }

    @Override
    public String toString() {
        return this.parseItem(new EntityStringConverter());
    }

    @Override
    public String toString(int indentFactor) {
        return this.parseItem(new EntityStringConverter(indentFactor));
    }

    @Override
    protected String parseItem(EntityStringConverter converter) {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        if (!this.isVisible()) {
            return "[" + this.size() + " Items]";
        }
        converter.add();
        StringBuilder sb = new StringBuilder("[").append(converter.getPrefix());
        Object element = iterator.next();
        sb.append(EntityUtil.valueToString(element, false, this, converter));
        while (iterator.hasNext()) {
            element = iterator.next();
            sb.append(",");
            sb.append(converter.getPrefix());
            sb.append(EntityUtil.valueToString(element, false, this, converter));
        }
        converter.minus();
        sb.append(converter.getPrefix());
        sb.append(']');
        return sb.toString();
    }

    public JsonArray withValue(String value) {
        this.clear();
        JsonTokener tokener = new JsonTokener();
        tokener.withBuffer(value);
        tokener.parseToEntity(this);
        return this;
    }

    public JsonArray withValue(Tokener x) {
        x.parseToEntity(this);
        return this;
    }

    @Override
    public JsonArray withValue(Buffer values) {
        new JsonTokener().withBuffer(values).parseToEntity(this);
        return this;
    }

    public JsonArray withValue(BaseItem ... values) {
        for (int i = 0; i < values.length; ++i) {
            this.add(EntityUtil.wrap(values[i], this));
        }
        return this;
    }

    public JsonObject get(String id) {
        for (Object item : this) {
            JsonObject json;
            if (!(item instanceof JsonObject) || !(json = (JsonObject)item).has("id") || !json.getString("id").equals(id)) continue;
            return json;
        }
        return null;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        if (keyValue) {
            return new JsonObject();
        }
        return new JsonArray();
    }

    @Override
    public boolean remove(Object value) {
        return this.removeByObject(value) >= 0;
    }

    @Override
    public JsonArray subList(int fromIndex, int toIndex) {
        return (JsonArray)super.subList(fromIndex, toIndex);
    }

    @Override
    public SimpleList<EntityList> getChildren() {
        SimpleList<EntityList> items = new SimpleList<EntityList>();
        for (Object item : this) {
            if (!(item instanceof EntityList)) continue;
            items.add((EntityList)item);
        }
        return items;
    }
}

