/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.DERBuffer;
import de.uniks.networkparser.interfaces.Entity;
import java.math.BigInteger;
import java.util.Random;

public class RSAKey {
    public static final String BEGINPUBLICKEY = "-----BEGIN PUBLIC RSA KEY-----\n";
    public static final String ENDPUBLICKEY = "-----END PUBLIC RSA KEY-----";
    public static final String BEGINPRIVATEKEY = "-----BEGIN PRIVATE RSA KEY-----\n";
    public static final String ENDPRIVATEKEY = "-----END PRIVATE RSA KEY-----";
    public static final Byte RSABYTE = 48;
    public static final int SAFESIZE = 1024;
    public static final String TAG = "RSA";
    private BigInteger e;
    private BigInteger d;
    private BigInteger N;

    public RSAKey(BigInteger N) {
        this.N = N;
    }

    public RSAKey withPublicKey(BigInteger value) {
        this.e = value;
        return this;
    }

    public BigInteger getPublicKey() {
        return this.e;
    }

    public RSAKey withPrivateKey(BigInteger value) {
        this.d = value;
        return this;
    }

    public BigInteger getPrivateKey() {
        return this.d;
    }

    public BigInteger getModulus() {
        return this.N;
    }

    public RSAKey withPubExp(BigInteger value) {
        this.e = this.weedOut(value);
        return this;
    }

    public RSAKey withPubExp(int value) {
        BigInteger newValue = BigInteger.valueOf(value);
        this.e = this.weedOut(newValue);
        return this;
    }

    public BigInteger encrypt(BigInteger message) {
        if (message.divide(this.getModulus()).intValue() > 0) {
            System.out.println("WARNUNG MODULUS MUST BIGGER (HASH-VALUE)");
        }
        return message.modPow(this.getPublicKey(), this.getModulus());
    }

    public StringBuilder encrypt(String value) {
        return this.encrypt(value, value.length());
    }

    public StringBuilder decrypt(String message) {
        return this.decrypt(new BigInteger(message));
    }

    public StringBuilder decrypt(BigInteger message) {
        int bitCount;
        BigInteger text = message.modPow(this.getPrivateKey(), this.getModulus());
        BigInteger divider = BigInteger.valueOf(1000L);
        StringBuilder sb = new StringBuilder(bitCount);
        for (bitCount = text.bitCount(); bitCount >= 0; --bitCount) {
            BigInteger character = text.remainder(divider);
            sb.setCharAt(bitCount, (char)character.intValue());
            text = text.divide(divider);
        }
        return sb;
    }

    public Entity sign(Entity value) {
        String string = value.toString();
        StringBuilder hashCode = this.encrypt(string, string.length());
        value.put(TAG, hashCode);
        return null;
    }

    public StringBuilder encrypt(String value, int group) {
        StringBuilder sb = new StringBuilder();
        StringBuilder item = new StringBuilder();
        int c = 0;
        for (int i = 0; i < value.length(); ++i) {
            char character;
            if (c == 0) {
                item = new StringBuilder();
            }
            if ((character = value.charAt(i)) < '\n') {
                item.append("00" + character);
            } else if (character < 'd') {
                item.append("0" + character);
            } else {
                item.append((int)character);
            }
            if (++c != group) continue;
            sb.append(this.encoding(item.toString()));
            item = new StringBuilder();
            c = 0;
        }
        if (c > 0) {
            sb.append(this.encoding(item.toString()));
        }
        return sb;
    }

    private String encoding(String value) {
        BigInteger encrypt = this.encrypt(new BigInteger(value));
        String string = encrypt.toString();
        int rest = string.length() % 3;
        if (rest == 1) {
            return "0" + string;
        }
        if (rest == 2) {
            return "00" + string;
        }
        return string;
    }

    private final BigInteger weedOut(BigInteger value) {
        if (!this.isNull(value) && this.isPositive(value)) {
            return value;
        }
        return null;
    }

    private final boolean isPositive(BigInteger number) {
        return number.compareTo(BigInteger.ZERO) > 0;
    }

    private final boolean isNull(Object value) {
        return value == null;
    }

    public static RSAKey generateKey(int p, int q, int max) {
        return RSAKey.generateKey(BigInteger.valueOf(p), BigInteger.valueOf(q), max);
    }

    public static RSAKey generateKey() {
        return RSAKey.generateKey(1024);
    }

    public static RSAKey generateKey(int max) {
        return RSAKey.generateKey(BigInteger.ZERO, BigInteger.ZERO, max);
    }

    public static RSAKey generateKey(BigInteger p, BigInteger q, int max) {
        Random rand = new Random();
        if (p.longValue() < 1L) {
            p = BigInteger.probablePrime(75 * max / 100, rand);
            q = BigInteger.probablePrime(25 * max / 100, rand);
        }
        RSAKey key = new RSAKey(p.multiply(q));
        BigInteger phi = RSAKey.computePhi(p, q);
        BigInteger i = BigInteger.probablePrime(max / 10, rand);
        while (i.compareTo(key.getModulus()) < 0 && !i.gcd(phi).equals(BigInteger.ONE)) {
            i = i.nextProbablePrime();
        }
        key.withPubExp(i);
        return key;
    }

    private static BigInteger computePhi(BigInteger p, BigInteger q) {
        return RSAKey.lcm(p.subtract(BigInteger.ONE), q.subtract(BigInteger.ONE));
    }

    private static BigInteger lcm(BigInteger a, BigInteger b) {
        return a.multiply(b).divide(a.gcd(b));
    }

    public static RSAKey getDecryptKey(BigInteger n, BigInteger privateKey) {
        RSAKey key = new RSAKey(n);
        key.withPrivateKey(privateKey);
        return key;
    }

    public String toString() {
        CharacterBuffer sb = new CharacterBuffer();
        if (this.e != null) {
            sb.with("-----BEGIN PUBLIC RSA KEY-----\n\r\n");
            sb.with(this.getPublicStream().toString() + "\r\n");
            sb.with("-----END PUBLIC RSA KEY-----\r\n");
        }
        if (this.d != null) {
            sb.with("-----BEGIN PRIVATE RSA KEY-----\n\r\n");
            sb.with(this.getPrivateStream().toString() + "\r\n");
            sb.with("-----END PRIVATE RSA KEY-----\r\n");
        }
        return sb.toString();
    }

    public DERBuffer getPublicStream() {
        return this.getStream(this.e);
    }

    public DERBuffer getPrivateStream() {
        return this.getStream(this.d);
    }

    public DERBuffer getStream(BigInteger key) {
        DERBuffer bitString = new DERBuffer();
        bitString.addGroup(RSABYTE, new Object[]{this.N, key});
        DERBuffer derBuffer = new DERBuffer();
        derBuffer = new DERBuffer();
        derBuffer.addGroup(RSABYTE, new Object[]{RSABYTE, new Object[]{(byte)6, new Byte[]{(byte)42, (byte)-122, (byte)72, (byte)-122, (byte)-9, (byte)13, (byte)1, (byte)1, (byte)1}, (byte)5}, (byte)3, bitString.getBytes()});
        return derBuffer;
    }
}

