/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.json;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import de.uniks.networkparser.interfaces.SendableEntityCreatorWrapper;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.json.util.JsonObjectCreator;
import de.uniks.networkparser.list.ObjectMapEntry;
import de.uniks.networkparser.list.SimpleIteratorSet;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.XMLEntity;
import java.util.Map;

public class JsonTokener
extends Tokener {
    public static final String PROPS = "prop";
    public static final String STOPCHARS = ",]}/\\\"[{;=# ";
    public static final char STARTARRAY = '[';
    public static final char ENDARRAY = ']';
    public static final char STARTENTITY = '{';
    public static final char ENDENTITY = '}';

    @Override
    public void parseToEntity(EntityList entityList) {
        char c = this.nextClean(true);
        if (c != '[') {
            if (this.isError(this, "parseToEntity", "PARSING", entityList)) {
                throw new RuntimeException("A JSONArray text must start with '['");
            }
            return;
        }
        if (this.nextClean(false) != ']') {
            block4: while (true) {
                if ((c = this.getCurrentChar()) != ',') {
                    entityList.with(this.nextValue(entityList, false, false, '\u0000'));
                }
                c = this.nextClean(true);
                switch (c) {
                    case ',': 
                    case ';': {
                        if (this.nextClean(false) != ']') continue block4;
                        return;
                    }
                    case ']': {
                        this.skip();
                        return;
                    }
                }
                break;
            }
            if (this.isError(this, "parseToEntity", "PARSING", entityList)) {
                throw new RuntimeException("Expected a ',' or ']' not '" + this.getCurrentChar() + "'");
            }
            return;
        }
        this.skip();
    }

    @Override
    public Object nextValue(BaseItem creator, boolean allowQuote, boolean allowDuppleMarks, char stopChar) {
        stopChar = this.nextClean(true);
        switch (stopChar) {
            case '\"': {
                this.skip();
                return EntityUtil.unQuote(this.nextString(new CharacterBuffer(), allowQuote, true, stopChar));
            }
            case '\\': {
                this.skip();
                this.skip();
                return this.nextString(new CharacterBuffer(), allowQuote, true, '\"');
            }
            case '{': {
                BaseItem element = creator.getNewList(true);
                if (element instanceof Entity) {
                    this.parseToEntity((Entity)element);
                }
                return element;
            }
            case '[': {
                BaseItem item = creator.getNewList(false);
                if (item instanceof EntityList) {
                    this.parseToEntity((EntityList)item);
                }
                return item;
            }
        }
        return super.nextValue(creator, allowQuote, allowDuppleMarks, stopChar);
    }

    @Override
    public void parseToEntity(Entity entity) {
        if (this.nextClean(true) != '{' && this.isError(this, "parseToEntity", "PARSING", entity)) {
            throw new RuntimeException("A JsonObject text must begin with '{' \n" + this.buffer);
        }
        this.skip();
        boolean isQuote = true;
        char stop = '\u0000';
        block6: while (true) {
            String key;
            char c = this.nextClean(true);
            switch (c) {
                case '\u0000': {
                    if (this.isError(this, "parseToEntity", "PARSING", entity)) {
                        throw new RuntimeException("A JsonObject text must end with '}'");
                    }
                    return;
                }
                case '\\': {
                    this.skip();
                    isQuote = false;
                    continue block6;
                }
                case '}': {
                    this.skip();
                    return;
                }
                case ',': {
                    this.skip();
                    Object keyValue = this.nextValue(entity, isQuote, false, stop);
                    if (keyValue == null) {
                        return;
                    }
                    key = keyValue.toString();
                    break;
                }
                default: {
                    key = this.nextValue(entity, isQuote, false, stop).toString();
                }
            }
            c = this.nextClean(true);
            if (c != ':' && c != '=') {
                if (this.isError(this, "parseToEntity", "PARSING", entity)) {
                    throw new RuntimeException("Expected a ':' after a key [" + this.getString(30).toString() + "]");
                }
                return;
            }
            this.getChar();
            entity.put(key, this.nextValue(entity, isQuote, false, stop));
        }
    }

    public JsonObject parseEntity(JsonObject parent, SimpleKeyValueList<?, ?> newValue) {
        if (newValue instanceof XMLEntity) {
            XMLEntity xmlEntity = (XMLEntity)newValue;
            parent.put("class", xmlEntity.getTag());
            JsonObject props = new JsonObject();
            if (xmlEntity.getValue() != null && xmlEntity.getValue().length() > 0) {
                parent.put("value", xmlEntity.getValue());
            }
            for (int i = 0; i < xmlEntity.size(); ++i) {
                this.parseEntityProp(props, xmlEntity.getValueByIndex(i), (String)xmlEntity.getKeyByIndex(i));
            }
            for (EntityList child : xmlEntity.getChildren()) {
                if (!(child instanceof XMLEntity)) continue;
                XMLEntity xml = (XMLEntity)child;
                this.parseEntityProp(props, xml, xml.getTag());
            }
            parent.put(PROPS, props);
        }
        return parent;
    }

    public JsonObject parseToEntity(JsonObject parent, SimpleKeyValueList<?, ?> newValue) {
        if (newValue instanceof XMLEntity) {
            XMLEntity xmlEntity = (XMLEntity)newValue;
            parent.put("class", xmlEntity.getTag());
            JsonObject props = new JsonObject();
            if (xmlEntity.getValue() != null && xmlEntity.getValue().length() > 0) {
                parent.put("value", xmlEntity.getValue());
            }
            for (int i = 0; i < xmlEntity.size(); ++i) {
                this.parseEntityProp(props, xmlEntity.getValueByIndex(i), (String)xmlEntity.getKeyByIndex(i));
            }
            for (EntityList child : xmlEntity.getChildren()) {
                if (!(child instanceof XMLEntity)) continue;
                XMLEntity xml = (XMLEntity)child;
                this.parseEntityProp(props, xml, xml.getTag());
            }
            parent.put(PROPS, props);
        }
        return parent;
    }

    private void parseEntityProp(JsonObject props, Object propValue, String prop) {
        if (propValue != null) {
            if (propValue instanceof XMLEntity) {
                if (props.containsKey(prop)) {
                    Object child = props.get(prop);
                    JsonArray propList = null;
                    if (child instanceof JsonObject) {
                        propList = new JsonArray();
                        propList.add(child);
                    } else if (child instanceof JsonArray) {
                        propList = (JsonArray)child;
                    }
                    if (propList != null) {
                        propList.add(this.parseEntity(new JsonObject(), (XMLEntity)propValue));
                        props.put(prop, propList);
                    }
                } else {
                    props.put(prop, this.parseEntity(new JsonObject(), (XMLEntity)propValue));
                }
            } else {
                props.put(prop, propValue);
            }
        }
    }

    public Object decoding(JsonObject jsonObject, MapEntity map) {
        if (jsonObject == null) {
            return map.getTarget();
        }
        SendableEntityCreator typeInfo = map.getCreator("read", this.map, jsonObject, null);
        if (typeInfo != null) {
            String[] properties;
            String jsonId;
            Object result = map.getTarget();
            if (map.hasValue(jsonObject, "id") && result == null && (jsonId = map.getValue(jsonObject, "id")) != null) {
                result = this.map.getObject(jsonId);
            }
            if (result == null) {
                result = map.getNewEntity(typeInfo, map.getValue(jsonObject, "class"), false);
                this.map.notify(new SimpleEvent("new", jsonObject, this.map, null, null, result));
            } else {
                this.map.notify(new SimpleEvent("upd", jsonObject, this.map, null, null, result));
            }
            if (typeInfo instanceof SendableEntityCreatorWrapper) {
                properties = typeInfo.getProperties();
                if (properties != null) {
                    JsonObjectCreator jsonCreator = new JsonObjectCreator();
                    JsonObject valueMap = new JsonObject();
                    for (String property : properties) {
                        Object value = jsonObject.get(property);
                        this.parseValue(valueMap, property, value, jsonCreator, map);
                    }
                    result = ((SendableEntityCreatorWrapper)typeInfo).newInstance(valueMap);
                }
            } else if (typeInfo instanceof SendableEntityCreatorNoIndex) {
                properties = typeInfo.getProperties();
                if (properties != null) {
                    for (String property : properties) {
                        Object obj = jsonObject.get(property);
                        this.parseValue(result, property, obj, typeInfo, map);
                    }
                }
            } else {
                this.decoding(result, jsonObject, map);
            }
            return result;
        }
        if (jsonObject.get("value") != null) {
            return jsonObject.get("value");
        }
        if (jsonObject.get("id") != null) {
            return this.map.getObject((String)jsonObject.get("id"));
        }
        return null;
    }

    private Object decoding(Object target, JsonObject jsonObject, MapEntity map) {
        SendableEntityCreator prototyp;
        String[] properties;
        JsonObject jsonProp;
        boolean isId = map.isId(target, this.map, target.getClass().getName());
        if (isId) {
            String jsonId = map.getValue(jsonObject, "id");
            IdMap idMap = this.map;
            if (jsonId == null) {
                return target;
            }
            idMap.put(jsonId, target);
            idMap.getCounter().readId(jsonId);
        }
        if ((jsonProp = (JsonObject)map.getProperties(jsonObject, this.map, isId, "read")) != null && (properties = (prototyp = map.getCreator("write", this.map, target, target.getClass().getName())).getProperties()) != null) {
            for (String property : properties) {
                Object obj = jsonProp.get(property);
                this.parseValue(target, property, obj, prototyp, map);
            }
        }
        return target;
    }

    private void parseValue(Object target, String property, Object value, SendableEntityCreator creator, MapEntity map) {
        if (value != null) {
            if (value instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)value;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Object kid = jsonArray.get(i);
                    if (kid instanceof JsonObject) {
                        creator.setValue(target, property, this.decoding((JsonObject)kid, map), "new");
                        continue;
                    }
                    creator.setValue(target, property, kid, "new");
                }
            } else if (value instanceof JsonObject) {
                Object refValue;
                JsonObject child = (JsonObject)value;
                String className = target.getClass().getName();
                Object ref_Obj = map.getNewEntity(creator, className, true);
                if (ref_Obj instanceof Class) {
                    ref_Obj = map.getNewEntity(creator, className, false);
                }
                if ((refValue = creator.getValue(ref_Obj, property)) instanceof Map) {
                    JsonObject json = (JsonObject)value;
                    SimpleIteratorSet<String, Object> i = new SimpleIteratorSet<String, Object>(json);
                    while (i.hasNext()) {
                        Object item = i.next();
                        String key = (String)item.getKey();
                        Object entryValue = item.getValue();
                        if (entryValue instanceof JsonObject) {
                            creator.setValue(target, property, new ObjectMapEntry().with(key, this.decoding((JsonObject)entryValue, map)), "new");
                            continue;
                        }
                        if (entryValue instanceof JsonArray) {
                            throw new RuntimeException();
                        }
                        creator.setValue(target, property, new ObjectMapEntry().with(key, entryValue), "new");
                    }
                } else {
                    creator.setValue(target, property, this.decoding(child, map), map.getStrategy());
                }
            } else {
                creator.setValue(target, property, value, map.getStrategy());
            }
        }
    }

    @Override
    public JsonTokener withMap(IdMap map) {
        super.withMap(map);
        return this;
    }

    @Override
    public Entity newInstance() {
        return new JsonObject();
    }

    @Override
    public EntityList newInstanceList() {
        return new JsonArray();
    }

    @Override
    public Entity createLink(Entity parent, String property, String className, String id) {
        Entity child = this.newInstance();
        child.put("class", className);
        child.put("id", id);
        return child;
    }
}

