/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.bytes.Checksum;

public class SHA1
extends Checksum {
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int[] w = new int[80];
    private int currentPos;
    private long currentLen;
    private static final int round1_kt = 1518500249;
    private static final int round2_kt = 1859775393;
    private static final int round3_kt = -1894007588;
    private static final int round4_kt = -899497514;

    public SHA1() {
        this.reset();
    }

    @Override
    public int getOrder() {
        return 20;
    }

    @Override
    public void reset() {
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = -1009589776;
        this.currentPos = 0;
        this.currentLen = 0L;
    }

    @Override
    public void update(byte[] bytes, int offset, int length) {
        int idx;
        if (length >= 4) {
            idx = this.currentPos >> 2;
            switch (this.currentPos & 3) {
                case 0: {
                    this.w[idx] = (bytes[offset++] & 0xFF) << 24 | (bytes[offset++] & 0xFF) << 16 | (bytes[offset++] & 0xFF) << 8 | bytes[offset++] & 0xFF;
                    length -= 4;
                    this.currentPos += 4;
                    this.currentLen += 32L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                    break;
                }
                case 1: {
                    this.w[idx] = this.w[idx] << 24 | ((bytes[offset++] & 0xFF) << 16 | (bytes[offset++] & 0xFF) << 8 | bytes[offset++] & 0xFF);
                    length -= 3;
                    this.currentPos += 3;
                    this.currentLen += 24L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                    break;
                }
                case 2: {
                    this.w[idx] = this.w[idx] << 16 | ((bytes[offset++] & 0xFF) << 8 | bytes[offset++] & 0xFF);
                    length -= 2;
                    this.currentPos += 2;
                    this.currentLen += 16L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                    break;
                }
                case 3: {
                    this.w[idx] = this.w[idx] << 8 | bytes[offset++] & 0xFF;
                    --length;
                    ++this.currentPos;
                    this.currentLen += 8L;
                    if (this.currentPos != 64) break;
                    this.perform();
                    this.currentPos = 0;
                }
            }
            while (length >= 8) {
                this.w[this.currentPos >> 2] = (bytes[offset++] & 0xFF) << 24 | (bytes[offset++] & 0xFF) << 16 | (bytes[offset++] & 0xFF) << 8 | bytes[offset++] & 0xFF;
                this.currentPos += 4;
                if (this.currentPos == 64) {
                    this.perform();
                    this.currentPos = 0;
                }
                this.w[this.currentPos >> 2] = (bytes[offset++] & 0xFF) << 24 | (bytes[offset++] & 0xFF) << 16 | (bytes[offset++] & 0xFF) << 8 | bytes[offset++] & 0xFF;
                this.currentPos += 4;
                if (this.currentPos == 64) {
                    this.perform();
                    this.currentPos = 0;
                }
                this.currentLen += 64L;
                length -= 8;
            }
        }
        while (length > 0) {
            idx = this.currentPos >> 2;
            this.w[idx] = this.w[idx] << 8 | bytes[offset++] & 0xFF;
            this.currentLen += 8L;
            ++this.currentPos;
            if (this.currentPos == 64) {
                this.perform();
                this.currentPos = 0;
            }
            --length;
        }
    }

    @Override
    public boolean update(byte b) {
        int idx = this.currentPos >> 2;
        this.w[idx] = this.w[idx] << 8 | b & 0xFF;
        this.currentLen += 8L;
        ++this.currentPos;
        if (this.currentPos == 64) {
            this.perform();
            this.currentPos = 0;
        }
        return true;
    }

    private void putInt(byte[] b, int pos, int val) {
        b[pos] = (byte)(val >> 24);
        b[pos + 1] = (byte)(val >> 16);
        b[pos + 2] = (byte)(val >> 8);
        b[pos + 3] = (byte)val;
    }

    @Override
    public byte[] getByteArray() {
        byte[] out = new byte[this.getOrder()];
        int off = 0;
        int idx = this.currentPos >> 2;
        this.w[idx] = (this.w[idx] << 8 | 0x80) << (3 - (this.currentPos & 3) << 3);
        this.currentPos = (this.currentPos & 0xFFFFFFFC) + 4;
        if (this.currentPos == 64) {
            this.currentPos = 0;
            this.perform();
        } else if (this.currentPos == 60) {
            this.currentPos = 0;
            this.w[15] = 0;
            this.perform();
        }
        for (int i = this.currentPos >> 2; i < 14; ++i) {
            this.w[i] = 0;
        }
        this.w[14] = (int)(this.currentLen >> 32);
        this.w[15] = (int)this.currentLen;
        this.perform();
        this.putInt(out, off, this.H0);
        this.putInt(out, off + 4, this.H1);
        this.putInt(out, off + 8, this.H2);
        this.putInt(out, off + 12, this.H3);
        this.putInt(out, off + 16, this.H4);
        this.reset();
        return out;
    }

    private void perform() {
        int temp;
        int i;
        int t;
        for (t = 16; t < 80; ++t) {
            int x = this.w[t - 3] ^ this.w[t - 8] ^ this.w[t - 14] ^ this.w[t - 16];
            this.w[t] = x << 1 | x >>> 31;
        }
        for (t = 16; t <= 79; ++t) {
            int temp2 = this.w[t - 3] ^ this.w[t - 8] ^ this.w[t - 14] ^ this.w[t - 16];
            this.w[t] = temp2 << 1 | temp2 >>> 31;
        }
        int a = this.H0;
        int b = this.H1;
        int c = this.H2;
        int d = this.H3;
        int e = this.H4;
        for (i = 0; i < 20; ++i) {
            temp = (a << 5 | a >>> 27) + (b & c | ~b & d) + e + this.w[i] + 1518500249;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (i = 20; i < 40; ++i) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + e + this.w[i] + 1859775393;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (i = 40; i < 60; ++i) {
            temp = (a << 5 | a >>> 27) + (b & c | b & d | c & d) + e + this.w[i] + -1894007588;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        for (i = 60; i < 80; ++i) {
            temp = (a << 5 | a >>> 27) + (b ^ c ^ d) + e + this.w[i] + -899497514;
            e = d;
            d = c;
            c = b << 30 | b >>> 2;
            b = a;
            a = temp;
        }
        this.H0 += a;
        this.H1 += b;
        this.H2 += c;
        this.H3 += d;
        this.H4 += e;
    }

    public static CharacterBuffer value(CharSequence value) {
        SHA1 sha1 = new SHA1();
        sha1.update(SHA1.toByteArray(value));
        return SHA1.convertToHex(sha1.getByteArray());
    }

    public static CharacterBuffer convertToHex(byte[] data) {
        CharacterBuffer buf = new CharacterBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.with((char)(48 + halfbyte));
                } else {
                    buf.with((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf;
    }

    public static byte[] toByteArray(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        byte[] barr = new byte[charSequence.length()];
        for (int i = 0; i < barr.length; ++i) {
            barr[i] = (byte)charSequence.charAt(i);
        }
        return barr;
    }
}

