/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.bytes.ByteEntity;
import de.uniks.networkparser.bytes.ByteList;
import de.uniks.networkparser.bytes.ByteMessage;
import de.uniks.networkparser.interfaces.ByteItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.ObjectMapEntry;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ByteTokener
extends Tokener {
    public static final char SPLITTER = ' ';
    public static final byte DATATYPE_FIXED = 0;
    public static final byte DATATYPE_NULL = 34;
    public static final byte DATATYPE_CLAZZID = 35;
    public static final byte DATATYPE_SHORT = 48;
    public static final byte DATATYPE_INTEGER = 49;
    public static final byte DATATYPE_LONG = 50;
    public static final byte DATATYPE_FLOAT = 51;
    public static final byte DATATYPE_DOUBLE = 52;
    public static final byte DATATYPE_DATE = 53;
    public static final byte DATATYPE_BYTE = 54;
    public static final byte DATATYPE_UNSIGNEDBYTE = 55;
    public static final byte DATATYPE_BYTEARRAY = 58;
    public static final byte DATATYPE_CHAR = 64;
    public static final byte DATATYPE_CLAZZNAME = 65;
    public static final byte DATATYPE_CLAZZNAMELONG = 66;
    public static final byte DATATYPE_CLAZZPACKAGE = 67;
    public static final byte DATATYPE_CLAZZTYP = 68;
    public static final byte DATATYPE_CLAZZTYPLONG = 69;
    public static final byte DATATYPE_ASSOC = 70;
    public static final byte DATATYPE_ASSOCLONG = 71;
    public static final byte DATATYPE_CLAZZSTREAM = 80;
    public static final byte DATATYPE_STRING = 74;
    public static final byte DATATYPE_LIST = 90;
    public static final byte DATATYPE_MAP = 106;
    public static final byte DATATYPE_CHECK = 122;
    public static final byte LEN_LITTLE = 1;
    public static final byte LEN_SHORT = 2;
    public static final byte LEN_MID = 3;
    public static final byte LEN_BIG = 4;
    public static final byte LEN_LAST = 5;
    public static final String CHARSET = "UTF-8";

    public String getCharset() {
        return CHARSET;
    }

    private boolean addClazzTyp(ByteList msg, String clazzName, MapEntity map) {
        try {
            String lastClazz;
            int id = map.getIndexOfClazz(clazzName);
            if (id > 0) {
                if (id <= 127) {
                    msg.add(new ByteEntity().withValue((byte)68, (byte)id));
                } else {
                    msg.add(new ByteEntity().withValue((byte)69, (byte)id));
                }
                return true;
            }
            int pos = clazzName.lastIndexOf(".");
            if (pos > 0 && (lastClazz = map.getLastClazz()) != null && lastClazz.lastIndexOf(".") == pos && clazzName.substring(0, pos).equals(lastClazz.substring(0, pos))) {
                byte[] bytes = clazzName.substring(pos + 1).getBytes(this.getCharset());
                msg.add(new ByteEntity().withValue((byte)67, bytes));
                return true;
            }
            byte[] bytes = clazzName.getBytes(this.getCharset());
            msg.add(new ByteEntity().withValue((byte)65, bytes));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public ByteItem encode(Object entity, MapEntity map) {
        SendableEntityCreator creator = this.getCreatorClass(entity);
        if (creator == null) {
            return null;
        }
        int id = map.getIndexVisitedObjects(entity);
        if (id >= 0) {
            if (id <= 127) {
                return new ByteEntity().withValue((byte)70, (byte)id);
            }
            return new ByteEntity().withValue((byte)71, id);
        }
        ByteList msg = new ByteList();
        if (creator instanceof SendableEntityCreatorTag) {
            String tag = ((SendableEntityCreatorTag)creator).getTag();
            if (tag != null) {
                byte cId = tag.getBytes(Charset.forName(CHARSET))[0];
                msg.add(new ByteEntity().withValue((byte)35, cId));
            }
        } else {
            Object reference = creator.getSendableInstance(true);
            this.addClazzTyp(msg, reference.getClass().getName(), map);
        }
        map.with(new Object[]{entity});
        String[] properties = creator.getProperties();
        if (properties != null) {
            Object referenceObj = creator.getSendableInstance(true);
            for (String property : properties) {
                ByteItem child;
                Object value = creator.getValue(entity, property);
                if (creator.getValue(referenceObj, property) == value) {
                    value = null;
                }
                if ((child = this.encodeValue(value, map)) == null) continue;
                msg.add(child);
            }
            ByteItem[] array = msg.toArray(new ByteItem[msg.size()]);
            for (int i = array.length - 1; i > 0 && array[i].isEmpty(); --i) {
                msg.remove(i);
            }
        }
        return msg;
    }

    public ByteItem encodeValue(Object value, MapEntity filter) {
        ByteEntity msgEntity = new ByteEntity();
        if (msgEntity.setValues(value)) {
            return msgEntity;
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            ByteList byteList = new ByteList().withTyp((byte)90);
            for (Object childValue : list) {
                ByteItem child = this.encodeValue(childValue, filter);
                if (child == null) continue;
                byteList.add(child);
            }
            return byteList;
        }
        if (value instanceof Map) {
            ByteList byteList = new ByteList().withTyp((byte)106);
            Map map = (Map)value;
            for (Map.Entry entity : map.entrySet()) {
                ByteList item = new ByteList().withTyp((byte)122);
                ByteItem child = this.encodeValue(entity.getKey(), filter);
                if (child != null) {
                    item.add(child);
                }
                if ((child = this.encodeValue(entity.getValue(), filter)) != null) {
                    item.add(child);
                }
                byteList.add(item);
            }
            return byteList;
        }
        if (value != null) {
            return this.encode(value, filter);
        }
        return null;
    }

    public Object decodeClazz(Buffer buffer, SendableEntityCreator eventCreater, MapEntity map) {
        if (eventCreater == null) {
            ByteMessage e = new ByteMessage();
            if (buffer != null) {
                e.set("value", buffer.array(-1, true));
            }
            return e;
        }
        Object entity = eventCreater.getSendableInstance(false);
        String[] properties = eventCreater.getProperties();
        if (properties != null) {
            for (String property : properties) {
                if (buffer.remaining() < 1) break;
                Object value = this.decodeValue(buffer.getByte(), buffer, buffer.length() - buffer.position(), map);
                if (value == null) continue;
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object item : list) {
                        eventCreater.setValue(entity, property, item, "new");
                    }
                    continue;
                }
                eventCreater.setValue(entity, property, value, "new");
            }
        }
        return entity;
    }

    public Object decodeValue(ByteEntity entity, MapEntity map) {
        if (entity == null) {
            return null;
        }
        byte typ = entity.getTyp();
        ByteBuffer buffer = new ByteBuffer();
        Object value = entity.getValue("VALUE");
        if (value != null) {
            buffer.with((byte[])value);
        }
        return this.decodeValue(typ, buffer, buffer.length(), map);
    }

    public Object decodeValue(byte current, Buffer buffer, MapEntity map) {
        if (buffer == null || buffer.remaining() < 1) {
            return null;
        }
        return this.decodeValue(current, buffer, buffer.length(), map);
    }

    Object decodeValue(Buffer buffer, int end, MapEntity map) {
        return this.decodeValue(buffer.getByte(), buffer, end, map);
    }

    public Object decodeValue(byte typ, Buffer buffer, int end, MapEntity map) {
        if (buffer == null || buffer.remaining() < 1) {
            return null;
        }
        if (typ == 34) {
            return null;
        }
        if (typ == 54) {
            return buffer.getByte();
        }
        if (typ == 64) {
            return Character.valueOf(buffer.getChar());
        }
        if (typ == 48) {
            return buffer.getShort();
        }
        if (typ == 49) {
            return buffer.getInt();
        }
        if (typ == 50) {
            return buffer.getLong();
        }
        if (typ == 51) {
            return Float.valueOf(buffer.getFloat());
        }
        if (typ == 52) {
            return buffer.getDouble();
        }
        if (typ == 53) {
            return new Date(buffer.getLong());
        }
        if (typ == 65) {
            int len = buffer.getByte() - 32;
            try {
                SendableEntityCreator eventCreater = this.getCreator(new String(buffer.array(len, false), this.getCharset()), true);
                return this.decodeClazz(buffer, eventCreater, map);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (typ == 66) {
            int len = buffer.getInt();
            try {
                SendableEntityCreator eventCreater = this.getCreator(new String(buffer.array(len, false), this.getCharset()), true);
                return this.decodeClazz(buffer, eventCreater, map);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (typ == 68) {
            int pos = buffer.getByte() - 32;
            SendableEntityCreator eventCreater = this.getCreator(map.getClazz(pos), true);
            return this.decodeClazz(buffer, eventCreater, map);
        }
        if (typ == 69) {
            int pos = buffer.getInt();
            SendableEntityCreator eventCreater = this.getCreator(map.getClazz(pos), true);
            return this.decodeClazz(buffer, eventCreater, map);
        }
        if (typ == 35) {
            String id;
            typ = buffer.getByte();
            try {
                id = new String(new byte[]{typ}, CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                id = "";
            }
            SendableEntityCreator eventCreater = this.getCreator(id, true);
            if (eventCreater == null) {
                SimpleKeyValueList<String, SendableEntityCreator> creators = this.getMap().getCreators();
                for (int i = 0; i < creators.size(); ++i) {
                    if (!creators.getKeyByIndex(i).startsWith(id)) continue;
                    eventCreater = creators.getValueByIndex(i);
                    break;
                }
            }
            return this.decodeClazz(buffer, eventCreater, map);
        }
        if (typ == 70) {
            byte pos = buffer.getByte();
            return map.getVisitedObjects(pos);
        }
        if (typ == 71) {
            int pos = buffer.getInt();
            return map.getVisitedObjects(pos);
        }
        if (EntityUtil.isGroup(typ)) {
            byte subgroup = EntityUtil.getSubGroup(typ);
            int len = 0;
            if (subgroup == 1) {
                len = buffer.getByte() - 32;
            } else if (subgroup == 2) {
                len = buffer.getByte();
            } else if (subgroup == 3) {
                len = buffer.getShort();
            } else if (subgroup == 4) {
                len = buffer.getInt();
            } else if (subgroup == 5) {
                len = end - 1;
            }
            byte group = EntityUtil.getGroup(typ);
            if (group == 74) {
                try {
                    return new String(buffer.array(len, false), this.getCharset());
                }
                catch (Exception e) {
                    return "";
                }
            }
            if (group == 58) {
                return buffer.array(len, false);
            }
            if (group == 90) {
                int start = buffer.position();
                ArrayList<Object> values = new ArrayList<Object>();
                while (start + len - buffer.position() > 0) {
                    Object value = this.decodeValue(buffer, start + len - buffer.position(), map);
                    if (value == null) continue;
                    values.add(value);
                }
                return values;
            }
            if (group == 106) {
                Object subValues;
                int start = buffer.position();
                ArrayList values = new ArrayList();
                while (start + len - buffer.position() > 0 && (subValues = this.decodeValue(buffer, start + len - buffer.position(), map)) != null && subValues instanceof List) {
                    List list = (List)subValues;
                    if (list.size() != 2) continue;
                    values.add(new ObjectMapEntry().with(list.get(0), list.get(1)));
                }
                return values;
            }
            if (group == 122) {
                int start = buffer.position();
                if (buffer.length() < start + len) {
                    return null;
                }
                ArrayList<Object> values = new ArrayList<Object>();
                while (start + len - buffer.position() > 0) {
                    values.add(this.decodeValue(buffer, start + len - buffer.position(), map));
                }
                return values;
            }
        }
        return null;
    }

    @Override
    public ByteTokener withMap(IdMap map) {
        super.withMap(map);
        return this;
    }
}

