/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser.excel;

import de.uniks.networkparser.Pos;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.SimpleList;
import java.nio.charset.Charset;
import java.util.Comparator;

public class ExcelCell
implements SendableEntityCreatorTag,
EntityList {
    public static final String TAG = "c";
    public static final String PROPERTY_STYLE = "s";
    public static final String PROPERTY_TYPE = "t";
    public static final String PROPERTY_REFERENZ = "r";
    public static final String[] PROPERTIES = new String[]{"s", "t", "r"};
    private Pos pos;
    private Object content;
    private ExcelCell referenceCell;
    private String style;
    private String type;
    private SimpleList<EntityList> children;

    @Override
    public String[] getProperties() {
        return PROPERTIES;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (!(entity instanceof ExcelCell)) {
            return null;
        }
        if (PROPERTY_STYLE.equals(attribute)) {
            return ((ExcelCell)entity).getStyle();
        }
        if (PROPERTY_TYPE.equals(attribute)) {
            return ((ExcelCell)entity).getType();
        }
        if (PROPERTY_REFERENZ.equals(attribute)) {
            return ((ExcelCell)entity).getReferenz();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (!(entity instanceof ExcelCell)) {
            return false;
        }
        if (PROPERTY_STYLE.equals(attribute)) {
            ((ExcelCell)entity).setStyle("" + value);
            return true;
        }
        if (PROPERTY_TYPE.equals(attribute)) {
            ((ExcelCell)entity).setType("" + value);
            return true;
        }
        if (PROPERTY_REFERENZ.equals(attribute)) {
            ((ExcelCell)entity).withReferenz(Pos.valueOf("" + value));
            return true;
        }
        if ("<CHILDREN>".equals(type)) {
            ((ExcelCell)entity).with(value);
            return true;
        }
        return false;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new ExcelCell();
    }

    @Override
    public String getTag() {
        return TAG;
    }

    public Pos getReferenz() {
        return this.pos;
    }

    public ExcelCell withReferenz(Pos referenz) {
        this.pos = referenz;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getStyle() {
        return this.style;
    }

    public Object getContent() {
        if (this.referenceCell != null) {
            return this.referenceCell.getContent();
        }
        return this.content;
    }

    public String getContentAsString() {
        if (this.referenceCell != null) {
            return this.referenceCell.getContentAsString();
        }
        if (this.content == null) {
            return "";
        }
        return this.content.toString();
    }

    public boolean setContent(Object value) {
        if (this.referenceCell != null) {
            return this.referenceCell.setContent(value);
        }
        if (this.content == null && value != null || this.content != null && !this.content.equals(value)) {
            this.content = value;
            return true;
        }
        return false;
    }

    public ExcelCell withContent(Object value) {
        this.setContent(value);
        return this;
    }

    public ExcelCell getReferenceCell() {
        return this.referenceCell;
    }

    public boolean setStyle(String value) {
        if (this.style == null && value != null || this.style != null && !this.style.equals(value)) {
            this.style = value;
            return true;
        }
        return false;
    }

    public boolean setType(String value) {
        if (this.type == null && value != null || this.type != null && !this.type.equals(value)) {
            this.type = value;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Object context;
        String ref = "";
        if (this.pos != null) {
            ref = this.pos.toString();
        }
        if ((context = this.getContent()) == null) {
            return "";
        }
        if (context instanceof Number) {
            return "<c r=\"" + ref + "\"><v>" + context + "</v></c>";
        }
        if (context instanceof Boolean) {
            if (((Boolean)context).booleanValue()) {
                return "<c r=\"" + ref + "\" t=\"b\"><v>1</v></c>";
            }
            return "<c r=\"" + ref + "\" t=\"b\"><v>0</v></c>";
        }
        return "<c r=\"" + ref + "\" t=\"inlineStr\"><is><t>" + new String(context.toString().getBytes(Charset.forName("UTF-8")), Charset.forName("UTF-8")) + "</t></is></c>";
    }

    @Override
    public String toString(int indentFactor) {
        return this.toString();
    }

    protected String toString(int indentFactor, int indent) {
        return this.toString();
    }

    @Override
    public String toString(Converter converter) {
        return this.toString();
    }

    @Override
    public ExcelCell with(Object ... values) {
        if (values == null) {
            return null;
        }
        if (this.children == null) {
            this.children = new SimpleList();
        }
        for (Object item : values) {
            if (!(item instanceof EntityList)) continue;
            this.children.add((EntityList)item);
        }
        return this;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new ExcelCell();
    }

    @Override
    public SimpleList<EntityList> getChildren() {
        return this.children;
    }

    @Override
    public int size() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public boolean setReferenceCell(ExcelCell value) {
        if (this.referenceCell == null && value != null || this.referenceCell != null && !this.referenceCell.equals(value)) {
            this.referenceCell = value;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComparator() {
        return false;
    }

    @Override
    public Comparator<Object> comparator() {
        return null;
    }

    @Override
    public BaseItem withValue(Buffer values) {
        return this;
    }
}

