/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.bytes.Checksum;

public class CRC
extends Checksum {
    public static final int CRC8 = 263;
    public static final int CRC16 = 32773;
    public static final int CRC32 = -306674912;
    public static final int CCITT16 = 4129;
    protected int[] crc_table = null;
    private int order;

    public CRC() {
    }

    public CRC(int bitMask) {
        this.withCRC(bitMask);
    }

    public CRC withCRC(int bitMask) {
        this.order = bitMask;
        if (this.order == 0) {
            this.order = 16;
            this.crc_table = null;
        } else if (this.order == 8) {
            this.crc_table = this.getGenTable(false, 263);
        } else if (this.order == 16) {
            this.crc_table = this.getGenTable(true, 32773);
        } else if (this.order == 32) {
            this.crc_table = this.getGenTable(false, -306674912);
        } else {
            this.crc_table = null;
            this.order = 0;
        }
        return this;
    }

    @Override
    public boolean update(int data) {
        if (this.order == 0) {
            return false;
        }
        super.update(data);
        if (this.order == 8) {
            this.value = this.crc_table[((int)this.value ^ (byte)data) & 0xFF];
        } else if (this.order == 16) {
            if (this.crc_table == null) {
                for (int i = 0; i < 8; ++i) {
                    boolean bit = (data >> 7 - i & 1) == 1;
                    boolean c15 = (this.value >> 15 & 1L) == 1L;
                    this.value <<= 1;
                    if (!(c15 ^ bit)) continue;
                    this.value ^= 0x1021L;
                }
            } else {
                this.value = this.value >>> 8 ^ (long)this.crc_table[((int)this.value ^ data) & 0xFF];
            }
        } else if (this.order == 32) {
            int c = (int)(this.value ^ 0xFFFFFFFFFFFFFFFFL);
            c = this.crc_table[(c ^ data) & 0xFF] ^ c >>> 8;
            this.value = ~c;
        }
        return true;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public int[] getGenTable(boolean isReflect, int polynom) {
        int[] result = new int[256];
        if (polynom == -306674912) {
            for (int n = 0; n < 256; ++n) {
                int c = n;
                int k = 8;
                while (--k >= 0) {
                    if ((c & 1) != 0) {
                        c = 0xEDB88320 ^ c >>> 1;
                        continue;
                    }
                    c >>>= 1;
                }
                result[n] = c;
            }
            return result;
        }
        int order = this.getOrder();
        long topBit = 1L << order - 1;
        long widthMask = (1 << order - 1) - 1 << 1 | 1;
        int i = 0;
        while (i < 256) {
            result[i] = i;
            if (isReflect) {
                result[i] = CRC.Reflect(i, 8);
            }
            result[i] = result[i] << order - 8;
            for (int j = 0; j < 8; ++j) {
                if (((long)result[i] & topBit) != 0L) {
                    result[i] = result[i] << 1 ^ polynom;
                    continue;
                }
                int n = i;
                result[n] = result[n] << 1;
            }
            if (isReflect) {
                result[i] = CRC.Reflect(result[i], order);
            }
            int n = i++;
            result[n] = (int)((long)result[n] & widthMask);
        }
        return result;
    }

    private static int Reflect(int data, int numBits) {
        int temp = data;
        for (int i = 0; i < numBits; ++i) {
            long bitMask = 1L << numBits - 1 - i;
            data = ((long)temp & 1L) != 0L ? (int)((long)data | bitMask) : (int)((long)data & (bitMask ^ 0xFFFFFFFFFFFFFFFFL));
            temp >>= 1;
        }
        return data;
    }
}

