/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SimpleSet;

public class MapEntityStack {
    private SimpleKeyValueList<Object, SendableEntityCreator> stack = new SimpleKeyValueList();
    private SimpleList<String> tags = new SimpleList();
    private SimpleKeyValueList<String, SimpleSet<String>> childProperties = new SimpleKeyValueList();

    public void popStack() {
        this.stack.removePos(this.stack.size() - 1);
        this.tags.remove(this.tags.size() - 1);
    }

    public int getStackSize() {
        return this.stack.size();
    }

    public Object getCurrentItem() {
        return this.stack.last();
    }

    public Object getPrevItem() {
        int pos = this.stack.size() - 2;
        if (pos < 0) {
            return null;
        }
        return this.stack.get(pos);
    }

    public MapEntityStack withStack(String tag, Object item, SendableEntityCreator creator) {
        String[] properties;
        this.stack.add(item, creator);
        this.tags.add(tag);
        for (String property : properties = creator.getProperties()) {
            int lastPos = property.lastIndexOf(46);
            if (lastPos < 0) continue;
            String prop = lastPos == property.length() - 1 ? "." : property.substring(lastPos + 1);
            int pos = this.childProperties.indexOf(prop);
            if (pos >= 0) {
                this.childProperties.getValueByIndex(pos).add(property);
                continue;
            }
            SimpleSet<String> child = new SimpleSet<String>();
            child.add(property);
            this.childProperties.put(prop, child);
        }
        return this;
    }

    public SendableEntityCreator getCurrentCreator() {
        return this.stack.getValueByIndex(this.stack.size() - 1);
    }

    public void setValue(String key, String value) {
        SimpleSet<String> set = this.childProperties.get(key);
        if (set != null) {
            for (String ChildKey : set) {
                int pos = this.getEntityPos(ChildKey);
                if (pos < 0) continue;
                Object entity = this.stack.getKeyByIndex(pos);
                SendableEntityCreator creator = this.stack.getValueByIndex(pos);
                creator.setValue(entity, ChildKey, value, "new");
            }
        }
    }

    private int getEntityPos(String entity) {
        int start = entity.lastIndexOf(46);
        int pos = this.tags.size() - 1;
        for (int end = start - 1; end >= 0; --end) {
            if (entity.charAt(end) != '.') continue;
            String item = entity.substring(end + 1, start);
            String tag = (String)this.tags.get(pos);
            if (tag == null || !tag.equals(item)) {
                return -1;
            }
            start = end;
            --pos;
        }
        return pos;
    }

    public String getCurrentTag() {
        if (this.tags.size() > 0) {
            return (String)this.tags.get(this.tags.size() - 1);
        }
        return null;
    }
}

