/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.converter.GraphConverter;
import de.uniks.networkparser.graph.GraphList;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.xml.XMLEntity;

public class HTMLEntity
implements BaseItem {
    public static final String PROPERTY_HEADER = "head";
    public static final String PROPERTY_BODY = "body";
    public static final String IMAGEFORMAT = " .bmp .jpg .jpeg .png .gif .svg ";
    private XMLEntity body = new XMLEntity().setType("body");
    private XMLEntity header = new XMLEntity().setType("head");

    @Override
    public String toString() {
        return this.parseItem(new EntityStringConverter());
    }

    public String toString(int indentFactor) {
        return this.parseItem(new EntityStringConverter(indentFactor));
    }

    public HTMLEntity withEncoding(String encoding) {
        XMLEntity metaTag = new XMLEntity().setType("meta");
        metaTag.withKeyValue("http-equiv", "Content-Type");
        metaTag.withKeyValue("content", "text/html;charset=" + encoding);
        this.header.with(metaTag);
        return this;
    }

    public HTMLEntity withTitle(String value) {
        XMLEntity titleTag = new XMLEntity().setType("title").withValue(value);
        this.header.with(titleTag);
        return this;
    }

    protected String parseItem(EntityStringConverter converter) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        converter.add();
        sb.append(this.header.toString(converter));
        sb.append(this.body.toString(converter));
        converter.minus();
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public HTMLEntity with(Object ... values) {
        if (values == null) {
            return this;
        }
        if (values.length % 2 == 0) {
            this.body.with(values);
        } else {
            for (Object item : values) {
                if (!(item instanceof XMLEntity)) continue;
                this.body.withChild((XMLEntity)item);
            }
        }
        return this;
    }

    public Object getValue(Object key) {
        Object result = this.header.getValue(key);
        if (result != null) {
            return result;
        }
        return this.body.getValue(key);
    }

    public HTMLEntity withHeader(String ref) {
        XMLEntity child = this.getChild(ref);
        if (child != null) {
            this.header.with(child);
        }
        return this;
    }

    XMLEntity getChild(String ref) {
        XMLEntity child = null;
        if (ref == null) {
            return null;
        }
        int pos = ref.lastIndexOf(".");
        if (pos < 0) {
            return null;
        }
        String ext = ref.substring(pos).toLowerCase();
        if (ext.equals(".css")) {
            child = new XMLEntity().setType("link");
            child.withKeyValue("rel", "stylesheet");
            child.withKeyValue("type", "text/css");
            child.withKeyValue("href", ref);
        } else if (ext.equals(".js")) {
            child = new XMLEntity().setType("script").withCloseTag();
            child.withKeyValue("src", ref);
        } else if (IMAGEFORMAT.indexOf(" " + ext + " ") >= 0) {
            child = new XMLEntity().setType("img").withCloseTag();
            child.withKeyValue("src", ref);
        }
        return child;
    }

    public HTMLEntity withBody(String ref) {
        XMLEntity child = this.getChild(ref);
        if (child != null) {
            this.body.with(child);
        }
        return this;
    }

    public HTMLEntity withScript(String code) {
        XMLEntity child = new XMLEntity().setType("script").withCloseTag();
        child.withValue(code);
        this.body.with(child);
        return this;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new SimpleSet();
    }

    public HTMLEntity withGraph(GraphList value) {
        return this.withGraph(value, null);
    }

    public HTMLEntity addStyle(String name, String style) {
        XMLEntity styleElement = null;
        for (EntityList child : this.header.getChildren()) {
            XMLEntity xml;
            if (!(child instanceof XMLEntity) || !(xml = (XMLEntity)child).getTag().equals(name)) continue;
            styleElement = xml;
        }
        if (styleElement == null) {
            XMLEntity element = new XMLEntity().setType("style");
            this.header.with(element);
            styleElement = element;
        }
        styleElement.withValue(styleElement.getValue() + "\r\n" + style);
        return this;
    }

    public HTMLEntity withGraph(GraphList value, String path) {
        XMLEntity script = new XMLEntity().setType("script").withKeyValue("type", "text/javascript");
        StringBuilder sb = new StringBuilder();
        sb.append("var json=");
        sb.append(value.toString(new GraphConverter()));
        sb.append(";\r\n");
        sb.append("new Graph(json).layout();");
        script.withValue(sb.toString());
        this.with(script);
        if (path != null) {
            this.withHeader(path + "diagramstyle.css");
            this.withHeader(path + "graph.js");
            this.withHeader(path + "dagre.min.js");
            this.withHeader(path + "drawer.js");
        }
        return this;
    }

    public HTMLEntity withNewLine() {
        XMLEntity xmlEntity = new XMLEntity();
        xmlEntity.withValue("<br />\r\n");
        this.body.withChild(xmlEntity);
        return this;
    }

    public HTMLEntity withText(String text) {
        XMLEntity xmlEntity = new XMLEntity();
        xmlEntity.withValue(text);
        this.body.withChild(xmlEntity);
        return this;
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        if (converter instanceof EntityStringConverter) {
            return this.parseItem((EntityStringConverter)converter);
        }
        return converter.encode(this);
    }
}

