/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.json;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.SimpleGrammar;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.IdMapCounter;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonObject;

public class EMFJsonGrammar
extends SimpleGrammar {
    public static final String SRC = "@src";
    public static final String PROP = "@prop";
    public static final String NV = "@nv";

    @Override
    public BaseItem getProperties(Entity item, IdMap map, Filter filter, boolean isId, String type) {
        JsonObject props = new JsonObject();
        if (item.has(PROP)) {
            String key = item.getString(PROP);
            String value = item.getString(NV);
            SendableEntityCreator result = this.getCreator("read", null, map, false, value);
            if (result != null) {
                props.put(key, new JsonObject().withValue(SRC, value));
            } else {
                props.put(key, value);
            }
            return props;
        }
        return item;
    }

    @Override
    public SendableEntityCreator getCreator(String type, Object item, IdMap map, boolean searchForSuperCreator, String className) {
        if ("read".equals(type) && item instanceof Entity) {
            SendableEntityCreator result = this.getCreator(type, null, map, false, ((Entity)item).getString(SRC));
            if (result != null) {
                return result;
            }
            return super.getCreator(type, item, map, searchForSuperCreator, className);
        }
        if (className == null) {
            return null;
        }
        int pos = className.indexOf("@");
        String clazz = null;
        if (pos > 0) {
            clazz = className.substring(0, pos);
        } else {
            pos = className.lastIndexOf(".");
            if (pos > 0) {
                clazz = className.substring(0, pos);
            }
        }
        if (clazz != null) {
            for (SendableEntityCreator creator : map) {
                Object sendableInstance = creator.getSendableInstance(true);
                String refClazzName = sendableInstance.getClass().getName();
                if (!refClazzName.endsWith("." + clazz)) continue;
                return creator;
            }
        }
        return super.getCreator(type, item, map, searchForSuperCreator, className);
    }

    @Override
    public String getId(Object obj, IdMapCounter counter) {
        String name = obj.getClass().getName();
        int pos = name.lastIndexOf(".");
        counter.withPrefixId(null);
        if (pos > 0) {
            return name.substring(pos + 1) + counter.getSplitter() + counter.getId(obj);
        }
        return name + counter.getSplitter() + counter.getId(obj);
    }

    @Override
    public String getValue(Entity item, String property) {
        if ("id".equals(property)) {
            return item.getString(SRC);
        }
        return item.getString(property);
    }

    @Override
    public boolean hasValue(Entity json, String property) {
        if (property.equals("id")) {
            property = SRC;
        }
        return super.hasValue(json, property);
    }

    @Override
    public CharacterBuffer getPrefixProperties(SendableEntityCreator creator, Tokener format, boolean isId) {
        return new CharacterBuffer();
    }

    @Override
    public Entity writeBasicValue(Entity entity, BaseItem parent, String className, String id, MapEntity map) {
        if (id != null) {
            entity.put(SRC, id);
        }
        return entity;
    }
}

