/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphLabel;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.StringFilter;
import de.uniks.networkparser.list.SimpleSet;
import java.util.Collection;

public class Association
extends GraphMember {
    public static final StringFilter<Association> NAME = new StringFilter("name");
    public static final String PROPERTY_NODE = "node";
    public static final String PROPERTY_CARDINALITY = "cardinality";
    public static final String PROPERTY_PROPERTY = "property";
    private Cardinality cardinality;
    private Association other;
    private AssociationTypes type = AssociationTypes.ASSOCIATION;

    Association() {
    }

    public Association(GraphEntity node) {
        this.parentNode = node;
    }

    public Cardinality getCardinality() {
        if (this.cardinality != null) {
            return this.cardinality;
        }
        if (this.children != null) {
            GraphSimpleSet collection = this.getParents();
            int count = 0;
            for (GraphMember item : collection) {
                if (!(item instanceof Clazz) || ++count <= 1) continue;
                return Cardinality.MANY;
            }
        }
        return Cardinality.ONE;
    }

    @Override
    public String getName() {
        String className;
        GraphMember item;
        GraphSimpleSet collection;
        if (this.name != null) {
            return this.name;
        }
        if (this.parentNode != null && (collection = this.getParents()).size() == 1 && (item = (GraphMember)collection.first()) instanceof Clazz && (className = ((Clazz)item).getName(true)) != null) {
            return className.toLowerCase();
        }
        return null;
    }

    String name() {
        return this.name;
    }

    @Override
    protected boolean setParentNode(GraphMember value) {
        GraphSimpleSet list;
        if (value == this.parentNode) {
            return false;
        }
        if (this.parentNode == null) {
            this.parentNode = value;
            if (value != null) {
                value.withChildren(this);
            }
            return true;
        }
        if (this.parentNode instanceof GraphSimpleSet) {
            list = (GraphSimpleSet)this.parentNode;
        } else {
            list = new GraphSimpleSet();
            list.with(new Object[]{(GraphMember)this.parentNode});
            this.parentNode = list;
        }
        if (list.add(value) && value != null) {
            value.withChildren(this);
        }
        return true;
    }

    Association withoutParent(GraphMember member) {
        if (this.parentNode == null) {
            return this;
        }
        if (this.parentNode == member) {
            this.parentNode = null;
        }
        if (this.parentNode instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.parentNode;
            list.remove(member);
        }
        return this;
    }

    @Override
    SimpleSet<GraphEntity> getNodes() {
        SimpleSet<GraphEntity> collection = new SimpleSet<GraphEntity>();
        if (this.parentNode == null) {
            return collection;
        }
        if (this.parentNode instanceof GraphEntity) {
            collection.add((GraphEntity)this.parentNode);
            return collection;
        }
        if (this.parentNode instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.parentNode;
            for (GraphMember item : list) {
                if (!(item instanceof GraphEntity)) continue;
                collection.add((GraphEntity)item);
            }
        }
        return collection;
    }

    GraphSimpleSet getParents() {
        GraphSimpleSet parents = new GraphSimpleSet();
        if (this.parentNode == null) {
            return parents;
        }
        if (this.parentNode instanceof GraphMember) {
            parents.with(new Object[]{(GraphMember)this.parentNode});
            return parents;
        }
        parents.withList((Collection)((GraphSimpleSet)this.parentNode));
        return parents;
    }

    public Association with(GraphLabel label) {
        super.withChildren(label);
        return this;
    }

    public GraphLabel getInfo() {
        if (this.children == null && this.other.getChildren() == null) {
            return null;
        }
        for (GraphMember child : this.getChildren()) {
            if (!(child instanceof GraphLabel)) continue;
            return (GraphLabel)child;
        }
        for (GraphMember child : this.other.getChildren()) {
            if (!(child instanceof GraphLabel)) continue;
            return (GraphLabel)child;
        }
        return null;
    }

    public Association with(GraphEntity value) {
        super.setParent(value);
        return this;
    }

    @Override
    public Association with(String name) {
        super.with(name);
        return this;
    }

    Association withOther(Association value) {
        this.other = value;
        return this;
    }

    public Association with(Association value) {
        if (this.getOther() == value) {
            return this;
        }
        if (this.other != null) {
            this.other.withOther(null);
        }
        this.other = value;
        this.getOther().with(this);
        return this;
    }

    public Association with(Cardinality cardinality) {
        this.cardinality = cardinality;
        return this;
    }

    public Association getOther() {
        return this.other;
    }

    public static Association create(GraphEntity source, GraphEntity target) {
        Association edge = new Association(source);
        edge.with(new Association(target));
        return edge;
    }

    public AssociationTypes getType() {
        return this.type;
    }

    String getSeperator() {
        if (this.getType() == AssociationTypes.GENERALISATION) {
            return "-^";
        }
        if (this.getOtherType() == AssociationTypes.GENERALISATION) {
            return "^-";
        }
        if (this.getType() == AssociationTypes.IMPLEMENTS) {
            return "-.-^";
        }
        if (this.getOtherType() == AssociationTypes.IMPLEMENTS) {
            return "^-.-";
        }
        if (this.getType() == AssociationTypes.EDGE) {
            return "->";
        }
        if (this.getOtherType() == AssociationTypes.EDGE) {
            return "<-";
        }
        return "-";
    }

    String getCardinalityText() {
        return this.name + "<br>0.." + (Object)((Object)this.cardinality);
    }

    public Association with(AssociationTypes typ) {
        this.type = typ;
        return this;
    }

    public Clazz getOtherClazz() {
        if (this.other != null) {
            return this.other.getClazz();
        }
        return null;
    }

    AssociationTypes getOtherType() {
        if (this.other != null) {
            return this.other.getType();
        }
        return null;
    }

    public Clazz getClazz() {
        GraphMember item;
        GraphSimpleSet collection = this.getParents();
        if (collection.size() > 0 && (item = (GraphMember)collection.get(0)) instanceof Clazz) {
            return (Clazz)item;
        }
        return null;
    }

    public String toString() {
        CharacterBuffer charList = new CharacterBuffer();
        this.addIds(charList);
        charList.with(this.getSeperator());
        if (this.getOther() != null) {
            this.getOther().addIds(charList);
        }
        return charList.toString();
    }

    void addIds(CharacterBuffer sb) {
        if (this.parentNode == null) {
            sb.with("[]");
        } else if (this.parentNode instanceof GraphMember) {
            sb.with(((GraphMember)this.parentNode).getName());
        } else if (this.parentNode instanceof GraphSimpleSet) {
            GraphSimpleSet collection = (GraphSimpleSet)this.parentNode;
            if (collection.size() < 1) {
                return;
            }
            if (collection.size() == 1) {
                sb.with(((GraphMember)collection.get(0)).getName());
                return;
            }
            sb.with("[");
            sb.with(((GraphMember)collection.get(0)).getName());
            for (int i = 1; i < collection.size(); ++i) {
                sb.with("," + ((GraphMember)collection.get(1)).getName());
            }
            sb.with("]");
        }
    }

    boolean contains(GraphEntity key, boolean self, boolean other) {
        boolean contains = false;
        if (self) {
            if (this.parentNode == null) {
                contains = false;
            } else if (this.parentNode instanceof GraphMember) {
                contains = this.parentNode == key;
            } else if (this.parentNode instanceof GraphSimpleSet) {
                contains = ((GraphSimpleSet)this.parentNode).contains(key);
            }
        }
        if (other && !contains) {
            contains = this.other.contains(key, true, false);
        }
        return contains;
    }

    boolean containsAll(Association others, boolean both) {
        if (this.parentNode == null) {
            return false;
        }
        GraphSimpleSet otherChildren = others.getParents();
        if (this.parentNode instanceof GraphMember && (otherChildren.size() != 1 || this.parentNode != otherChildren.first())) {
            return false;
        }
        if (this.parentNode instanceof GraphSimpleSet && ((GraphSimpleSet)this.parentNode).containsAll(otherChildren)) {
            return false;
        }
        if (this.getOther() != null && both) {
            return this.getOther().containsAll(others.getOther(), false);
        }
        return true;
    }

    public Association with(Annotation value) {
        this.withAnnotaion(value);
        return this;
    }

    public Association without(Annotation value) {
        super.without(value);
        return this;
    }

    boolean isSame(Association other) {
        if (this.name == null) {
            return other.name() == null;
        }
        return this.name().equals(other.name());
    }
}

