/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import java.beans.PropertyChangeEvent;

public final class SimpleEvent
extends PropertyChangeEvent {
    private static final long serialVersionUID = 1L;
    private int depth;
    private Entity entity;
    private Object value;
    private String type;
    private Object beforeElement;

    public SimpleEvent(Object source, String property, Object oldValue, Object newValue) {
        super(source, property, oldValue, newValue);
        this.value = newValue;
        this.type = "new";
    }

    public SimpleEvent(String type, BaseItem source, String property, Object oldValue, Object newValue, int depth, Object modelItem) {
        super(source, property, oldValue, newValue);
        this.depth = depth;
        this.type = type;
        this.value = modelItem;
    }

    public SimpleEvent(String type, Entity entity, BaseItem source, String property, Object oldValue, Object newValue) {
        super(source, property, oldValue, newValue);
        this.entity = entity;
        this.type = type;
    }

    public SimpleEvent(String type, Entity entity, PropertyChangeEvent source, IdMap map) {
        super(map, source.getPropertyName(), source.getOldValue(), source.getNewValue());
        this.value = source.getSource();
        this.type = type;
        this.entity = entity;
    }

    public SimpleEvent(String type, BaseItem source, String property, Object oldValue, Object newValue, Object beforeElement, Object value) {
        super(source, property, oldValue, newValue);
        this.type = type;
        this.value = value;
        this.beforeElement = beforeElement;
    }

    public int getDepth() {
        return this.depth;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Object getModelValue() {
        return this.value;
    }

    public SimpleEvent withModelValue(Object value) {
        this.value = value;
        return this;
    }

    public void setModelValue(Object value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public boolean isNewEvent() {
        return "new".equals(this.type);
    }

    public boolean isUpdateEvent() {
        return "upd".equals(this.type);
    }

    public SimpleEvent with(Entity entity) {
        this.entity = entity;
        return this;
    }

    public Object getBeforeElement() {
        return this.beforeElement;
    }
}

